package io.github.xrickastley.sevenelements.mixin;

import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.factory.SevenElementsComponents;
import io.github.xrickastley.sevenelements.interfaces.InfusableProjectile;

@Mixin(class_1676.class)
public abstract class ProjectileEntityMixin
	extends class_1297
	implements class_8046, InfusableProjectile
{
	@Unique
	private ElementalInfusionComponent sevenelements$infusionComponent;

   	public ProjectileEntityMixin(class_1299<? extends class_1676> entityType, class_1937 world) {
   		super(entityType, world);

		throw new AssertionError();
	}

	@Unique
	@Override
	public void sevenelements$setOriginStack(@Nullable class_1799 originStack) {
		if (originStack == null) return;

		this.sevenelements$infusionComponent = originStack.method_57824(SevenElementsComponents.ELEMENTAL_INFUSION_COMPONENT);
	}

	@Unique
	@Override
	public Optional<ElementalDamageSource> sevenelements$attemptInfusion(class_1282 source, class_1297 target) {
		return this.sevenelements$infusionComponent == null
			? Optional.empty()
			: this.sevenelements$infusionComponent.apply(source, target);
	}

	@Inject(
		method = "writeCustomDataToNbt",
		at = @At("TAIL")
	)
	public void writeInfusionToNbt(class_2487 nbt, CallbackInfo ci) {
		if (this.sevenelements$infusionComponent == null) return;

		final class_2520 componentNbt = ElementalInfusionComponent.CODEC
			.encodeStart(class_2509.field_11560, this.sevenelements$infusionComponent)
			.resultOrPartial(SevenElements.sublogger()::error)
			.orElseThrow();

		nbt.method_10566("seven-elements:elemental_infusion", componentNbt);
	}

	@Inject(
		method = "readCustomDataFromNbt",
		at = @At("TAIL")
	)
	public void readInfusionFromNbt(class_2487 nbt, CallbackInfo ci) {
		if (!nbt.method_10545("seven-elements:elemental_infusion")) return;

		this.sevenelements$infusionComponent = ElementalInfusionComponent.CODEC
			.parse(class_2509.field_11560, nbt.method_10580("seven-elements:elemental_infusion"))
			.resultOrPartial(SevenElements.sublogger()::error)
			.orElseThrow();
	}
}
