package io.github.xrickastley.sevenelements.mixin;

import com.mojang.serialization.Decoder;

import java.util.List;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5912;
import net.minecraft.class_6903;
import net.minecraft.class_6903.class_7863;
import net.minecraft.class_7655;
import net.minecraft.class_7782.class_9176;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.registry.dynamic.SevenElementsRegistryLoader;

@Mixin(class_7655.class)
public class RegistryLoaderMixin {
	@Inject(
		method = "loadFromResource(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/registry/RegistryOps$RegistryInfoGetter;Lnet/minecraft/registry/MutableRegistry;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V",
		at = @At("HEAD"),
		cancellable = true
	)
	private static <E> void doSevenElementsLoadFromResource(
		class_3300 resourceManager,
		class_6903.class_7863 infoGetter,
		class_2385<E> registry,
		Decoder<E> elementDecoder,
		Map<class_5321<?>, Exception> errors,
		CallbackInfo ci
	) {
		if (!SevenElementsRegistryLoader.isDynamicRegistry(registry)) return;
		SevenElementsRegistryLoader.loadFromResource(resourceManager, infoGetter, registry, elementDecoder, errors);
		ci.cancel();
	}

	@Inject(
		method = "loadFromNetwork(Ljava/util/Map;Lnet/minecraft/resource/ResourceFactory;Lnet/minecraft/registry/RegistryOps$RegistryInfoGetter;Lnet/minecraft/registry/MutableRegistry;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V",
		at = @At("HEAD"),
		cancellable = true
	)
	private static <E> void doSevenElementsLoadFromNetwork(
		Map<class_5321<? extends class_2378<?>>, List<class_9176>> data,
		class_5912 factory,
		class_7863 infoGetter,
		class_2385<E> registry,
		Decoder<E> decoder,
		Map<class_5321<?>, Exception> loadingErrors,
		CallbackInfo ci
	) {
		if (!SevenElementsRegistryLoader.isDynamicRegistry(registry)) return;
		SevenElementsRegistryLoader.loadFromNetwork(data, factory, infoGetter, registry, decoder, loadingErrors);
		ci.cancel();
	}
}
