package io.github.xrickastley.sevenelements.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.component.FrozenEffectComponent;
import io.github.xrickastley.sevenelements.element.DurationElementalApplication;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.renderer.genshin.ElementEntry;
import io.github.xrickastley.sevenelements.renderer.genshin.SpecialEffectsRenderer;
import io.github.xrickastley.sevenelements.util.ClientConfig;
import io.github.xrickastley.sevenelements.util.Color;
import io.github.xrickastley.sevenelements.util.SphereRenderer;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_922;

@Environment(EnvType.CLIENT)
@Mixin(value = class_922.class, priority = Integer.MAX_VALUE)
public abstract class LivingEntityRendererMixin<T extends class_1309, M extends class_583<T>> extends class_897<T> {
	protected LivingEntityRendererMixin(class_5617.class_5618 context) {
		super(context);

		throw new AssertionError();
	}

	@Inject(
		method = "render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
		at = @At("TAIL")
	)
	private void addRenderers(final T entity, final float yaw, final float tickDelta, final class_4587 matrixStack, final class_4597 vertexConsumers, final int light, CallbackInfo ci) {
		this.sevenelements$renderElementsIfPresent(entity, matrixStack, tickDelta);
		this.sevenelements$renderElementalGauges(entity, matrixStack, tickDelta);
		this.sevenelements$renderCrystallizeShield(entity, matrixStack);
	}

	@Unique
	private void sevenelements$renderElementsIfPresent(final class_1309 entity, final class_4587 matrixStack, final float tickDelta) {
		if (entity.method_29504()) return;

		final ElementComponent component = ElementComponent.KEY.get(entity);
		final List<ElementEntry> elementArray = new ArrayList<>();

		if (component.hasValidLastReaction()) {
			final ElementalReaction reaction = component.getLastReaction().method_15442();
			final long reactionAt = component.getLastReaction().method_15441();

			reaction
				.getReactionDisplayOrder()
				.forEach(element -> elementArray.add(new ElementEntry(element, 60.0, reactionAt, tickDelta)));
		} else {
			if (component.getAppliedElements().isEmpty()) return;

			final Optional<Integer> priority = component.getHighestElementPriority();

			if (priority.isEmpty()) return;

			elementArray.addAll(
				component
					.getAppliedElements()
					.filter(application -> application.getElement().getPriority() == priority.get())
					.map(a -> ElementEntry.of(a, tickDelta))
			);
		}

		final Set<class_2960> textures = new HashSet<>();

		elementArray.removeIf(entry -> !entry.getElement().hasTexture() || !textures.add(entry.getElement().getTexture()));

		final Iterator<class_243> coords = this
			.sevenelements$generateTexturesUsingCenter(new class_243(0, 0, 0), 1, elementArray.size())
			.iterator();

		final Set<class_2960> elementTexs = new HashSet<>();

		elementArray.removeIf(entry -> !elementTexs.add(entry.getElement().getTexture()));
		elementArray.forEach(entry -> entry.render(entity, matrixStack, field_4676.field_4686, (float) coords.next().method_10215()));
	}

	@Unique
	private ArrayList<class_243> sevenelements$generateTexturesUsingCenter(class_243 center, double length, int amount) {
		double totalDistance = length * (amount - 1);
		double offset = totalDistance / 2;

		final ArrayList<class_243> result = new ArrayList<>();
		double curDistance = center.method_10215() + offset;
		for (int i = 0; i < amount; i++) {
			result.add(new class_243(center.method_10216(), center.method_10214(), curDistance));

			curDistance -= length;
		}

		return result;
	}

	@Unique
	private void sevenelements$renderElementalGauges(final class_1309 entity, final class_4587 matrixStack, final float tickDelta) {
		final ClientConfig config = ClientConfig.get();

		if (!config.developer.displayElementalGauges) return;

		if (!entity.method_5805()) return;

		final ElementComponent component = ElementComponent.KEY.get(entity);
		final ArrayList<ElementalApplication> appliedElements = new ArrayList<>(component
			.getAppliedElements()
			.sortElements((a, b) -> a.getElement().getPriority() - b.getElement().getPriority()));

		final int elementCount = appliedElements.size();
		final Iterator<ElementalApplication> aeIterator = appliedElements.iterator();

		Stream
			.iterate(0.0f, n -> (n / 1.25f) < elementCount, n -> n + 1.25f)
			.forEachOrdered(yOffset ->
				sevenelements$renderElementalGauge(entity, aeIterator.next(), yOffset - 0.5f, matrixStack, tickDelta)
			);
	}

	@Unique
	private void sevenelements$renderElementalGauge(final class_1309 entity, final ElementalApplication application, final float yOffset, final class_4587 matrixStack, final float tickDelta) {
		if (application.isEmpty()) return;

		final float GAUGE_SCALE = 0.35f;
		final float SCALE_PER_GU = 2.5f;

		final class_289 tessellator = class_289.method_1348();
		final ClientConfig config = ClientConfig.get();

		matrixStack.method_22903();
		matrixStack.method_22904(0f, entity.method_5829().method_17940() * 1.15, 0f);
		matrixStack.method_34425(new Matrix4f().rotation(field_4676.field_4686.method_23767()));
		matrixStack.method_22905(GAUGE_SCALE, GAUGE_SCALE * 0.5f, GAUGE_SCALE);

		final float xOffset = (float) (entity.method_5829().method_17939() * 1.5f) / GAUGE_SCALE;
		final float gaugeWidth = application.isGaugeUnits()
			? (float) Math.min(SCALE_PER_GU * application.getGaugeUnits(), SCALE_PER_GU * 4)
			: 2 * SCALE_PER_GU;

		final Matrix4f positionMatrix = matrixStack.method_23760().method_23761();

		class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
		buffer.method_22918(positionMatrix, 0 + xOffset, 0 - yOffset, 0).method_39415(0xffffffff);
		buffer.method_22918(positionMatrix, gaugeWidth + xOffset, 0 - yOffset, 0).method_39415(0xffffffff);
		buffer.method_22918(positionMatrix, gaugeWidth + xOffset, 1 - yOffset, 0).method_39415(0xffffffff);
		buffer.method_22918(positionMatrix, 0 + xOffset, 1 - yOffset, 0).method_39415(0xffffffff);

		RenderSystem.setShader(class_757::method_34540);
		class_286.method_43433(buffer.method_60800());

		final float progress = this.sevenelements$getProgress(application, tickDelta);
		final Color elementColor = application.getElement().getDamageColor();
		final int color = application.isGaugeUnits()
			? elementColor.asARGB()
			: elementColor.multiply(1, 1, 1, 0.5).asARGB();

		buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
		buffer.method_22918(positionMatrix, xOffset, 0 - yOffset, 0.0001f).method_39415(color);
		buffer.method_22918(positionMatrix, (gaugeWidth * progress) + xOffset, 0 - yOffset, 0.0001f).method_39415(color);
		buffer.method_22918(positionMatrix, (gaugeWidth * progress) + xOffset, 1 - yOffset, 0.0001f).method_39415(color);
		buffer.method_22918(positionMatrix, xOffset, 1 - yOffset, 0.0001f).method_39415(color);

		class_286.method_43433(buffer.method_60800());

		if (application.isDuration()) {
			final float gaugeProgress = (float) (application.getCurrentGauge() / application.getGaugeUnits());

			buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
			buffer.method_22918(positionMatrix, xOffset, 0 - yOffset, 0.0001f).method_39415(color);
			buffer.method_22918(positionMatrix, (gaugeWidth * gaugeProgress) + xOffset, 0 - yOffset, 0.0001f).method_39415(color);
			buffer.method_22918(positionMatrix, (gaugeWidth * gaugeProgress) + xOffset, 1 - yOffset, 0.0001f).method_39415(color);
			buffer.method_22918(positionMatrix, xOffset, 1 - yOffset, 0.0001f).method_39415(color);

			class_286.method_43433(buffer.method_60800());
		}

		RenderSystem.setShader(class_757::method_34535);
		RenderSystem.disableCull();

		final float scaledGauge = (float) (0.1 * gaugeWidth / application.getGaugeUnits());
		final int splits = (int) Math.floor(gaugeWidth / (0.1 * gaugeWidth / application.getGaugeUnits()));

		for (int c = 1; c < splits && config.developer.displayGaugeRuler; c++) {
			final float i = c * scaledGauge;

			final float addedY = c % 10 == 0
				? 1f
				: c % 5 == 0
					? 0.5f
					: 0.25f;

			final float lineWidth = c % 10 == 0
				? 5f
				: 2.5f;

			buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
			buffer
				.method_22918(positionMatrix, xOffset + i, 0 - yOffset, -0.0005f)
				.method_39415(0xff000000)
				.method_22914(0, lineWidth, 0);
			buffer
				.method_22918(positionMatrix, xOffset + i, addedY - yOffset, -0.0005f)
				.method_39415(0xff000000)
				.method_22914(xOffset + i, lineWidth, 0);

			float prev = RenderSystem.getShaderLineWidth();

			RenderSystem.lineWidth(lineWidth);
			class_286.method_43433(buffer.method_60800());
			RenderSystem.lineWidth(prev);
		}

		RenderSystem.enableCull();

		matrixStack.method_22909();
	}

	@Unique
	private float sevenelements$getProgress(ElementalApplication application, float tickDelta) {
		return application instanceof final DurationElementalApplication durationApp
			? (float) ((application.getRemainingTicks() - tickDelta) / durationApp.getDuration())
			: (float) (application.getCurrentGauge() / application.getGaugeUnits());
	}

	@Unique
	private void sevenelements$renderCrystallizeShield(final class_1309 entity, final class_4587 matrixStack) {
		final ClientConfig config = ClientConfig.get();

		if (!SpecialEffectsRenderer.shouldRender(entity)) return;

		final ElementComponent component = ElementComponent.KEY.get(entity);
		final @Nullable class_3545<Element, Double> crystallizeShield = component.getCrystallizeShield();

		if (crystallizeShield == null) return;

		final double lengthY = entity.method_5829().method_17940();

		matrixStack.method_22903();
		matrixStack.method_22907(class_7833.field_40715.rotationDegrees(field_4676.field_4686.method_19330()));
		matrixStack.method_22904(0, lengthY * 0.6, 0);

		RenderSystem.disableCull();
		RenderSystem.enableBlend();
		RenderSystem.defaultBlendFunc();
		RenderSystem.enableDepthTest();
		RenderSystem.depthMask(false);

		SphereRenderer.render(
			matrixStack,
			new class_243(0, 0, 0),
			(float) (lengthY / 2 * 1.25),
			config.rendering.elements.sphereResolution,
			config.rendering.elements.sphereResolution * 2,
			pos -> crystallizeShield.method_15442().getDamageColor().multiply(1, 1, 1, 0.75 * Math.pow(pos.field_1352, 4)).asARGB()
		);

		RenderSystem.depthMask(true);
		RenderSystem.enableCull();
		RenderSystem.disableBlend();

		matrixStack.method_22909();
	}

	@Unique
	private FrozenEffectComponent sevenelements$getComponent(class_1309 entity) {
		return FrozenEffectComponent.KEY.get(entity);
	}

	@Unique
	private <R> R sevenelements$ifFrozen(class_1309 entity, Function<FrozenEffectComponent, R> ifFrozen, R ifNotFrozen) {
		final FrozenEffectComponent component = FrozenEffectComponent.KEY.get(entity);

		return component.isFrozen()
			? ifFrozen.apply(component)
			: ifNotFrozen;
	}

	@ModifyExpressionValue(
		method = "getRenderLayer",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/render/entity/LivingEntityRenderer;getTexture(Lnet/minecraft/entity/Entity;)Lnet/minecraft/util/Identifier;"
		)
	)
	private class_2960 renderFrostedModel(class_2960 original, @Local(argsOnly = true) class_1309 entity) {
		if (!ClientConfig.getEffectRenderType().allowsSpecialEffects()) return original;

		return this.sevenelements$ifFrozen(entity, c -> class_2960.method_60655("minecraft", "textures/block/ice.png"), original);
	}

	@ModifyReturnValue(
		method = "isShaking",
		at = @At("RETURN")
	)
	private boolean isShakingWhenFrozen(boolean original, @Local(argsOnly = true) class_1309 entity) {
		return original || this.sevenelements$getComponent(entity).isFrozen();
	}

	@Inject(
		method = "render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
		at = @At("HEAD")
	)
	private void forceFrozenPose(T livingEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci, @Local(argsOnly = true) class_1309 entity) {
		final FrozenEffectComponent component = FrozenEffectComponent.KEY.get(entity);

		if (component.isFrozen()) livingEntity.method_18380(component.getForcePose());
	}

	@ModifyExpressionValue(
		method = "render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/util/math/MathHelper;lerpAngleDegrees(FFF)F",
			ordinal = 0
		)
	)
	private float forceFrozenBodyYaw(float original, @Local(argsOnly = true) class_1309 entity) {
		return this.sevenelements$ifFrozen(entity, FrozenEffectComponent::getForceBodyYaw, original);
	}

	@ModifyExpressionValue(
		method = "render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/util/math/MathHelper;lerpAngleDegrees(FFF)F",
			ordinal = 1
		)
	)
	private float forceFrozenHeadYaw(float original, @Local(argsOnly = true) class_1309 entity) {
		return this.sevenelements$ifFrozen(entity, FrozenEffectComponent::getForceHeadYaw, original);
	}

	@ModifyExpressionValue(
		method = "render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/util/math/MathHelper;lerp(FFF)F",
			ordinal = 0
		)
	)
	private float forceFrozenPitch(float original, @Local(argsOnly = true) class_1309 entity) {
		return this.sevenelements$ifFrozen(entity, FrozenEffectComponent::getForcePitch, original);
	}

	@ModifyExpressionValue(
		method = "render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/LimbAnimator;getSpeed(F)F"
		)
	)
	private float forceFrozenLimbDistance(float original, @Local(argsOnly = true) class_1309 entity) {
		return this.sevenelements$ifFrozen(entity, FrozenEffectComponent::getForceLimbDistance, original);
	}

	@ModifyExpressionValue(
		method = "render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/LimbAnimator;getPos(F)F"
		)
	)
	private float forceFrozenLimbAngle(float original, @Local(argsOnly = true) class_1309 entity) {
		return this.sevenelements$ifFrozen(entity, FrozenEffectComponent::getForceLimbAngle, original);
	}
}
