/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element.reaction;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.events.ReactionTriggered;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.networking.ShowElementalReactionS2CPayload;
import io.github.xrickastley.sevenelements.registry.SevenElementsRegistries;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public abstract class ElementalReaction {
    protected final String name;
    protected final class_2960 id;
    @Nullable
    protected final class_2561 text;
    protected final double reactionCoefficient;
    protected final class_3545<Element, Integer> auraElement;
    protected final class_3545<Element, Integer> triggeringElement;
    protected final boolean reversable;
    protected final boolean applyResultAsAura;
    protected final boolean endsReactionTrigger;
    protected final boolean preventsPriorityUpgrade;
    protected final Set<class_2960> preventsReactionsAfter;
    protected final List<Element> reactionDisplayOrder;

    protected ElementalReaction(Settings settings) {
        this.name = settings.name;
        this.id = settings.id;
        this.text = settings.text;
        this.reactionCoefficient = settings.reactionCoefficient;
        this.auraElement = settings.auraElement;
        this.triggeringElement = settings.triggeringElement;
        this.reversable = settings.reversable;
        this.applyResultAsAura = settings.applyResultAsAura;
        this.endsReactionTrigger = settings.endsReactionTrigger;
        this.preventsPriorityUpgrade = settings.preventsPriorityUpgrade;
        this.preventsReactionsAfter = settings.preventsReactionsAfter;
        Stream reactionDisplayOrder = settings.reactionDisplayOrder.isEmpty() ? Stream.of(ClassInstanceUtil.mapOrNull(settings.auraElement, class_3545::method_15442), ClassInstanceUtil.mapOrNull(settings.triggeringElement, class_3545::method_15442)) : settings.reactionDisplayOrder.stream();
        this.reactionDisplayOrder = reactionDisplayOrder.filter(Objects::nonNull).collect(Collectors.toList());
        SevenElementsRegistries.ELEMENTAL_REACTION.method_40269((Object)this);
    }

    public static float getReactionDamage(class_1297 entity, double reactionMultiplier) {
        return ElementalReaction.getReactionDamage(entity, (float)reactionMultiplier);
    }

    public static float getReactionDamage(class_1297 entity, float reactionMultiplier) {
        return SevenElements.getLevelMultiplier(entity) * reactionMultiplier;
    }

    public static float getReactionDamage(class_1937 world, double reactionMultiplier) {
        return ElementalReaction.getReactionDamage(world, (float)reactionMultiplier);
    }

    public static float getReactionDamage(class_1937 world, float reactionMultiplier) {
        return SevenElements.getLevelMultiplier(world) * reactionMultiplier;
    }

    public static List<class_1309> getEntitiesInAoE(class_1309 target, double radius) {
        return ElementalReaction.getEntitiesInAoE(target, radius, e -> true);
    }

    public static List<class_1309> getEntitiesInAoE(class_1309 target, double radius, Predicate<class_1309> filter) {
        List targets = target.method_37908().method_18467(class_1309.class, class_238.method_30048((class_243)target.method_30950(1.0f), (double)(radius * 2.0), (double)(radius * 2.0), (double)(radius * 2.0)));
        targets.removeIf(entity -> entity.method_5858((class_1297)target) >= radius * radius || filter.negate().test((class_1309)entity));
        return targets;
    }

    public boolean hasElement(Element element) {
        return element == this.auraElement.method_15442() || element == this.triggeringElement.method_15442();
    }

    public boolean hasAnyElement(Collection<Element> elements) {
        return this.hasAnyElement(elements.stream());
    }

    public boolean hasAnyElement(Stream<Element> elements) {
        return elements.anyMatch(this::hasElement);
    }

    public Element getAuraElement() {
        return (Element)((Object)this.auraElement.method_15442());
    }

    public Element getTriggeringElement() {
        return (Element)((Object)this.triggeringElement.method_15442());
    }

    public int getAuraElementPriority() {
        return (Integer)this.auraElement.method_15441();
    }

    public int getTriggeringElementPriority() {
        return (Integer)this.triggeringElement.method_15441();
    }

    public int getHighestElementPriority() {
        return Math.min(((Element)((Object)this.auraElement.method_15442())).getPriority(), ((Element)((Object)this.triggeringElement.method_15442())).getPriority());
    }

    @Nullable
    public class_2561 getText() {
        return this.text;
    }

    public class_3545<Element, Integer> getElementPair(Element element) {
        return element == this.auraElement.method_15442() ? this.auraElement : (element == this.triggeringElement.method_15442() ? this.triggeringElement : null);
    }

    public List<Element> getReactionDisplayOrder() {
        return this.reactionDisplayOrder;
    }

    public boolean shouldApplyResultAsAura() {
        return this.applyResultAsAura;
    }

    public boolean shouldEndReactionTrigger() {
        return this.endsReactionTrigger;
    }

    public boolean shouldPreventPriorityUpgrade() {
        return this.preventsPriorityUpgrade;
    }

    public boolean preventsReaction(ElementalReaction reaction) {
        return this.preventsReaction(reaction.getId());
    }

    public boolean preventsReaction(class_2960 reactionId) {
        return this.preventsReactionsAfter.contains(reactionId);
    }

    public int getPriority(ElementalApplication application) {
        return this.getPriority(application.getElement());
    }

    public int getPriority(Element triggeringElement) {
        return triggeringElement.equals(this.triggeringElement.method_15442()) ? (Integer)this.triggeringElement.method_15441() : (triggeringElement.equals(this.auraElement.method_15442()) && this.reversable ? (Integer)this.auraElement.method_15441() : Integer.MAX_VALUE);
    }

    protected abstract void onReaction(class_1309 var1, ElementalApplication var2, ElementalApplication var3, double var4, @Nullable class_1309 var6);

    public class_2960 getId() {
        return this.id;
    }

    public boolean isTriggerable(class_1297 entity) {
        class_1309 livingEntity;
        return entity instanceof class_1309 && this.isTriggerable(livingEntity = (class_1309)entity);
    }

    public boolean isTriggerable(class_1309 entity) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)entity);
        ElementalApplication auraElement = component.getElementalApplication((Element)((Object)this.auraElement.method_15442()));
        ElementalApplication trigElement = component.getElementalApplication((Element)((Object)this.triggeringElement.method_15442()));
        return this.reversable ? auraElement != null && trigElement != null && !auraElement.isEmpty() && !trigElement.isEmpty() : auraElement != null && trigElement != null && auraElement.isAuraElement() && !auraElement.isEmpty() && !trigElement.isEmpty();
    }

    public boolean trigger(class_1309 entity) {
        return this.trigger(entity, null);
    }

    public boolean trigger(class_1309 entity, @Nullable class_1309 origin) {
        if (!this.isTriggerable(entity)) {
            return false;
        }
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)entity);
        ElementalApplication applicationAE = component.getElementalApplication((Element)((Object)this.auraElement.method_15442()));
        ElementalApplication applicationTE = component.getElementalApplication((Element)((Object)this.triggeringElement.method_15442()));
        if (applicationTE.isAuraElement() && !applicationAE.isAuraElement()) {
            ElementalApplication a = applicationTE;
            applicationTE = applicationAE;
            applicationAE = a;
        }
        double reducedGauge = applicationAE.reduceGauge(this.reactionCoefficient * applicationTE.getCurrentGauge());
        applicationTE.reduceGauge(reducedGauge);
        this.onTrigger(entity, applicationAE, applicationTE, reducedGauge, origin);
        return true;
    }

    protected final void onTrigger(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
        this.onReaction(entity, auraElement, triggeringElement, reducedGauge, origin);
        this.displayReaction(entity);
        ((ReactionTriggered)ReactionTriggered.EVENT.invoker()).onReactionTriggered(this, reducedGauge, entity, origin);
        entity.method_37908().method_8396(null, entity.method_24515(), SevenElementsSoundEvents.REACTION, class_3419.field_15248, 1.0f, 1.0f);
    }

    public boolean idEquals(ElementalReaction reaction) {
        return this.getId().equals((Object)reaction.getId());
    }

    protected void displayReaction(class_1309 target) {
        if (target.method_37908().field_9236) {
            return;
        }
        class_238 boundingBox = target.method_5829();
        double x = target.method_23317() + boundingBox.method_17939() * 1.5 * Math.random();
        double y = target.method_23318() + boundingBox.method_17940() * (0.25 + Math.random() / 2.0);
        double z = target.method_23321() + boundingBox.method_17941() * 1.5 * Math.random();
        class_243 pos = new class_243(x, y, z);
        ShowElementalReactionS2CPayload packet = new ShowElementalReactionS2CPayload(pos, this);
        if (target instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)target;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)packet);
        }
        for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)target)) {
            if (otherPlayer.method_5628() == target.method_5628()) continue;
            ServerPlayNetworking.send((class_3222)otherPlayer, (class_8710)packet);
        }
    }

    public static final class Settings {
        private final String name;
        private final class_2960 id;
        @Nullable
        private final class_2561 text;
        private double reactionCoefficient = 1.0;
        private class_3545<Element, Integer> auraElement;
        private class_3545<Element, Integer> triggeringElement;
        private boolean reversable = false;
        private boolean applyResultAsAura = false;
        private boolean endsReactionTrigger = false;
        private boolean preventsPriorityUpgrade = false;
        private Set<class_2960> preventsReactionsAfter = new HashSet<class_2960>();
        private List<Element> reactionDisplayOrder = new ArrayList<Element>();

        public Settings(String name, class_2960 id, @Nullable class_2561 text) {
            this.name = name;
            this.id = id;
            this.text = text;
        }

        public Settings setReactionCoefficient(double reactionCoefficient) {
            this.reactionCoefficient = reactionCoefficient;
            return this;
        }

        public Settings setAuraElement(Element element) {
            return this.setAuraElement(element, -1);
        }

        public Settings setAuraElement(Element element, int priority) {
            this.auraElement = new class_3545((Object)element, (Object)priority);
            return this;
        }

        public Settings setTriggeringElement(Element element) {
            return this.setTriggeringElement(element, -1);
        }

        public Settings setTriggeringElement(Element element, int priority) {
            this.triggeringElement = new class_3545((Object)element, (Object)priority);
            return this;
        }

        public Settings setReactionDisplayOrder(Element ... elementOrder) {
            this.reactionDisplayOrder = List.of(elementOrder);
            Set<Element> onlyElements = Set.of((Element)((Object)this.auraElement.method_15442()), (Element)((Object)this.triggeringElement.method_15442()));
            List<Element> invalidElements = this.reactionDisplayOrder.stream().filter(Predicate.not(onlyElements::contains)).toList();
            if (this.reactionDisplayOrder.stream().anyMatch(Predicate.not(onlyElements::contains))) {
                throw new IllegalArgumentException("The elements: " + String.valueOf(invalidElements) + " are not permitted as part of the reaction display order!");
            }
            return this;
        }

        public Settings reversable(boolean reversable) {
            this.reversable = reversable;
            return this;
        }

        public Settings applyResultAsAura(boolean applyResultAsAura) {
            this.applyResultAsAura = applyResultAsAura;
            return this;
        }

        public Settings endsReactionTrigger(boolean endsReactionTrigger) {
            this.endsReactionTrigger = endsReactionTrigger;
            return this;
        }

        public Settings preventsPriorityUpgrade(boolean preventsPriorityUpgrade) {
            this.preventsPriorityUpgrade = preventsPriorityUpgrade;
            return this;
        }

        public Settings preventsReactionsAfter(class_2960 ... reactions) {
            this.preventsReactionsAfter = Set.of(reactions);
            return this;
        }

        public Element getAuraElement() {
            return (Element)((Object)this.auraElement.method_15442());
        }

        public Element getTriggeringElement() {
            return (Element)((Object)this.triggeringElement.method_15442());
        }
    }
}

