/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.entity.DendroCoreEntity;
import io.github.xrickastley.sevenelements.factory.SevenElementsAttributes;
import io.github.xrickastley.sevenelements.factory.SevenElementsGameRules;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.interfaces.ILivingEntity;
import io.github.xrickastley.sevenelements.interfaces.IPlayerEntity;
import io.github.xrickastley.sevenelements.networking.ShowElementalDamageS2CPayload;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypeTags;
import io.github.xrickastley.sevenelements.util.BoxUtil;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements ILivingEntity {
    @Unique
    private float sevenelements$subdamage;
    @Unique
    private boolean sevenelements$blockedByCrystallizeShield = true;

    public LivingEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
        throw new AssertionError();
    }

    @ModifyReturnValue(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static class_5132.class_5133 addToLivingAttributes(class_5132.class_5133 builder) {
        return SevenElementsAttributes.apply(builder);
    }

    @Inject(method={"onStatusEffectRemoved"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/StatusEffect;onRemoved(Lnet/minecraft/entity/attribute/AttributeContainer;)V", shift=At.Shift.AFTER)})
    private void triggerEntityOnRemoved(class_1293 effect, CallbackInfo ci) {
        ((class_1291)effect.method_5579().comp_349()).onRemoved((class_1309)this, effect.method_5578());
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void applyNaturalElements(CallbackInfo ci) {
        if (this.method_5637() && this.method_37908().method_8450().method_8355(SevenElementsGameRules.HYDRO_FROM_WATER)) {
            ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)this);
            component.addElementalApplication(Element.HYDRO, InternalCooldownContext.ofType(null, "seven-elements:natural_environment", InternalCooldownType.INTERVAL_ONLY).forced(), 1.0);
        } else if (this.method_55667().method_26204() == class_2246.field_10036 && this.method_37908().method_8450().method_8355(SevenElementsGameRules.PYRO_FROM_FIRE)) {
            ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)this);
            component.addElementalApplication(Element.PYRO, InternalCooldownContext.ofType(null, "seven-elements:natural_environment", InternalCooldownType.INTERVAL_ONLY).forced(), 1.0);
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void resetCrystallizeShieldBlockedState(class_1282 source, float amount, CallbackInfoReturnable<Boolean> ci) {
        this.sevenelements$blockedByCrystallizeShield = false;
    }

    @ModifyVariable(method={"applyDamage"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/LivingEntity;modifyAppliedDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"), ordinal=0, argsOnly=true)
    private float applyCrystallizeShield(float amount, @Local(argsOnly=true) class_1282 source) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)this);
        float finalAmount = amount - component.reduceCrystallizeShield(source, amount);
        if (finalAmount < amount) {
            this.method_37908().method_8396(null, this.method_24515(), SevenElementsSoundEvents.CRYSTALLIZE_SHIELD_HIT, class_3419.field_15248, 1.0f, 1.0f);
        }
        if (finalAmount <= 0.0f) {
            this.sevenelements$blockedByCrystallizeShield = true;
        }
        return finalAmount;
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void cancelIfFullyBlocked(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.sevenelements$blockedByCrystallizeShield) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyExpressionValue(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/damage/DamageSource;isIn(Lnet/minecraft/registry/tag/TagKey;)Z", ordinal=7)})
    private boolean preventKnockbackIfCrystallize(boolean original, @Local(argsOnly=true) class_1282 source, @Share(value="sevenelements$hasCrystallizeShield") LocalBooleanRef hasCrystallizeShield) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)this);
        return original || component.reducedCrystallizeShield();
    }

    @Inject(method={"applyDamage"}, at={@At(value="TAIL")})
    private void elementDamageHandler(class_1282 source, float amount, CallbackInfo ci) {
        class_1657 player;
        ElementalDamageSource eds2;
        this.sevenelements$triggerDendroCoreReactions(source);
        if (!source.sevenelements$displayDamage()) {
            return;
        }
        ElementalDamageSource eds = source instanceof ElementalDamageSource ? (eds2 = (ElementalDamageSource)source) : new ElementalDamageSource(source, ElementalApplications.gaugeUnits((class_1309)this, Element.PHYSICAL, 0.0), InternalCooldownContext.ofNone(source.method_5529()));
        this.sevenelements$subdamage += amount;
        if (this.sevenelements$subdamage < 1.0f) {
            return;
        }
        float extra = this.sevenelements$subdamage - (float)Math.floor(this.sevenelements$subdamage);
        this.sevenelements$subdamage = (float)Math.floor(this.sevenelements$subdamage);
        class_1937 world = this.method_37908();
        if (world.field_9236 || !(world instanceof class_3218)) {
            return;
        }
        class_238 boundingBox = this.method_5829();
        double x = this.method_23317() + boundingBox.method_17939() * 1.25 * Math.random();
        double y = this.method_23318() + boundingBox.method_17940() * 0.5 * Math.random() + 0.5;
        double z = this.method_23321() + boundingBox.method_17941() * 1.25 * Math.random();
        class_243 pos = new class_243(x, y, z);
        class_1297 class_12972 = source.method_5529();
        boolean isCrit = class_12972 instanceof class_1657 && ((IPlayerEntity)(player = (class_1657)class_12972)).sevenelements$isCrit(eds);
        Element element = eds.getElementalApplication().getElement();
        ShowElementalDamageS2CPayload showElementalDMGPacket = new ShowElementalDamageS2CPayload(pos, element, this.sevenelements$subdamage, isCrit);
        this.sevenelements$subdamage = extra;
        for (class_3222 player2 : PlayerLookup.tracking((class_1297)this)) {
            if (player2.method_5628() == this.method_5628()) {
                return;
            }
            ServerPlayNetworking.send((class_3222)player2, (class_8710)showElementalDMGPacket);
        }
    }

    @ModifyConstant(method={"damage"}, constant={@Constant(intValue=20, ordinal=0)})
    private int changeTimeUntilRegen(int original, @Local(argsOnly=true) class_1282 source) {
        return source.method_48789(SevenElementsDamageTypeTags.PREVENTS_COOLDOWN_TRIGGER) ? 10 : original;
    }

    @Unique
    private void sevenelements$triggerDendroCoreReactions(class_1282 source) {
        if (!(source instanceof ElementalDamageSource)) {
            return;
        }
        ElementalDamageSource eds = (ElementalDamageSource)source;
        Element element = eds.getElementalApplication().getElement();
        if (element != Element.PYRO && element != Element.ELECTRO) {
            return;
        }
        this.method_37908().method_8390(DendroCoreEntity.class, BoxUtil.multiplyBox(this.method_5829(), 2.0), dc -> true).forEach(dc -> dc.method_5643(source, 1.0f));
    }

    @Override
    @Unique
    public void sevenelements$setBlockedByCrystallizeShield(boolean blocked) {
        this.sevenelements$blockedByCrystallizeShield = blocked;
    }
}

