/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.xrickastley.sevenelements.util.ClientConfig;
import io.github.xrickastley.sevenelements.util.Color;
import io.github.xrickastley.sevenelements.util.Ease;
import io.github.xrickastley.sevenelements.util.TextHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public final class WorldTextRenderer {
    private final List<Entry> entries = new ArrayList<Entry>();

    public void render(WorldRenderContext context) {
        class_4184 camera = context.camera();
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        this.entries.forEach(entry -> entry.render(camera, context.tickCounter().method_60637(false), matrixStack));
    }

    public void tick(class_638 world) {
        this.entries.forEach(Entry::tick);
        this.entries.removeIf(Entry::shouldRemove);
    }

    public WorldTextRenderer addEntry(Entry entry) {
        this.entries.add(entry);
        return this;
    }

    public static void drawText(class_4184 camera, class_4587 matrices, class_4597 vertexConsumers, class_5481 text, double x, double y, double z, int color, float size, boolean center, float offset, boolean visibleThroughObjects) {
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        ClientConfig config = ClientConfig.get();
        double d = camera.method_19326().field_1352;
        double e = camera.method_19326().field_1351;
        double f = camera.method_19326().field_1350;
        float scale = (float)((double)size * config.rendering.text.globalTextScale);
        matrices.method_22903();
        matrices.method_46416((float)(x - d), (float)(y - e), (float)(z - f));
        matrices.method_34425(new Matrix4f().rotation((Quaternionfc)camera.method_23767()));
        matrices.method_22905(scale, -scale, scale);
        float g = center ? (float)(-textRenderer.method_30880(text)) / 2.0f : 0.0f;
        textRenderer.method_22942(text, g -= offset / size, 0.0f, color, false, matrices.method_23760().method_23761(), vertexConsumers, visibleThroughObjects ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
        matrices.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry {
        protected final double x;
        protected final double y;
        protected final double z;
        protected final Color color;
        protected int age;

        Entry(double x, double y, double z, Color color) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.color = color;
            this.age = 0;
        }

        protected abstract void render(class_4184 var1, float var2, class_4587 var3);

        protected void tick() {
            ++this.age;
        }

        protected abstract boolean shouldRemove();
    }

    @Environment(value=EnvType.CLIENT)
    public static final class DamageText
    extends Entry {
        protected final int maxAge = 30;
        protected final int fadeAge = 15;
        protected final int scaleAge = 12;
        protected final class_2561 amount;
        protected final double scale;

        public DamageText(double x, double y, double z, Color color, double amount, double scale) {
            super(x, y, z, color);
            ClientConfig config = ClientConfig.get();
            String damageFormat = config.developer.commafyDamage ? "%,.0f" : "%.0f";
            this.amount = TextHelper.font(String.format(damageFormat, Math.max(amount, 1.0)), TextHelper.GENSHIN_FONT);
            this.scale = scale;
        }

        @Override
        protected void render(class_4184 camera, float tickDelta, class_4587 matrices) {
            class_310 client = class_310.method_1551();
            class_4597.class_4598 immediate = client.method_22940().method_23000();
            float deltaTime = (float)this.age + tickDelta;
            double alpha = Math.max(0.0, class_3532.method_16436((double)((deltaTime - 15.0f) / 15.0f), (double)1.0, (double)0.0));
            double scale = (1.25 - Ease.IN_OUT_QUART.applyLerpProgress(deltaTime / 12.0f, 0.0, 1.0) * 0.5) * this.scale;
            if (alpha <= 0.0 || scale <= 0.0) {
                return;
            }
            double x = this.x;
            double y = this.y + Ease.OUT_SINE.applyLerpProgress(deltaTime, 0.0, 30.0) * 0.75;
            double z = this.z;
            int color = this.color.multiply(1.0, 1.0, 1.0, alpha).asARGB();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            WorldTextRenderer.drawText(camera, matrices, (class_4597)immediate, this.amount.method_30937(), x, y, z, color, 0.04f * (float)scale, true, 0.0f, true);
            immediate.method_22993();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
        }

        @Override
        protected boolean shouldRemove() {
            return this.age > 30;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class ReactionText
    extends Entry {
        protected final class_2561 text;
        protected final int maxAge = 30;
        protected final int fadeAge = 15;
        protected final int scaleAge = 8;

        public ReactionText(double x, double y, double z, Color color, class_2561 text) {
            super(x, y, z, color);
            this.text = text;
        }

        @Override
        protected void render(class_4184 camera, float tickDelta, class_4587 matrices) {
            class_310 client = class_310.method_1551();
            class_4597.class_4598 immediate = client.method_22940().method_23000();
            float deltaTime = (float)this.age + tickDelta;
            double alpha = Math.max(0.0, class_3532.method_16436((double)((deltaTime - 15.0f) / 15.0f), (double)1.0, (double)0.0));
            double scale = 1.25 - Ease.IN_OUT_QUART.applyLerpProgress(deltaTime / 8.0f, 0.0, 1.0) * 0.5;
            if (alpha <= 0.0 || scale <= 0.0) {
                return;
            }
            double x = this.x;
            double y = this.y + Ease.OUT_SINE.applyLerpProgress(deltaTime, 0.0, 30.0) * 0.75;
            double z = this.z;
            int color = this.color.multiply(1.0, 1.0, 1.0, alpha).asARGB();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            WorldTextRenderer.drawText(camera, matrices, (class_4597)immediate, this.text.method_30937(), x, y, z, color, 0.04f * (float)scale, true, 0.0f, true);
            immediate.method_22993();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
        }

        @Override
        protected boolean shouldRemove() {
            return this.age > 30;
        }
    }
}

