/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.util;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class ClassInstanceUtil {
    public static <T> T cast(Object instance) {
        return (T)instance;
    }

    @Nullable
    public static <T> T castOrNull(Object instance, Class<T> castClass) {
        return (T)(castClass.isInstance(instance) ? instance : null);
    }

    @Nullable
    public static <T, R> R mapOrNull(@Nullable T instance, Function<T, R> mapper) {
        return instance == null ? null : (R)mapper.apply(instance);
    }

    public static <T, R> void ifPresentMapped(@Nullable T instance, Function<T, R> mapper, Consumer<R> ifNonNull) {
        if (instance == null) {
            return;
        }
        R value = mapper.apply(instance);
        if (value == null) {
            return;
        }
        ifNonNull.accept(value);
    }
}

