/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.util;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Config(name="seven-elements")
@Environment(value=EnvType.CLIENT)
public class ClientConfig
implements ConfigData {
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="rendering")
    public Rendering rendering = new Rendering();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="developer")
    public Developer developer = new Developer();

    public static ClientConfig get() {
        return (ClientConfig)AutoConfig.getConfigHolder(ClientConfig.class).get();
    }

    public static EffectRenderType getEffectRenderType() {
        return ClientConfig.get().rendering.elements.effectRenderType;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Rendering {
        @ConfigEntry.Gui.CollapsibleObject
        public Text text = new Text();
        @ConfigEntry.Gui.CollapsibleObject
        public Elements elements = new Elements();

        @Environment(value=EnvType.CLIENT)
        public static class Text {
            @ConfigEntry.Gui.Tooltip
            public double globalTextScale = 1.0;
            public boolean showDamageText = true;
            public double normalDMGScale = 0.65;
            public double critDMGScale = 1.0;
            @ConfigEntry.Gui.Tooltip
            public boolean displayTooltipAfterInfusion = true;
            @ConfigEntry.Gui.Tooltip
            @ConfigEntry.BoundedDiscrete(min=5L, max=50L)
            public int tooltipDisplayTicks = 20;
        }

        @Environment(value=EnvType.CLIENT)
        public static class Elements {
            @ConfigEntry.Gui.Tooltip
            @ConfigEntry.BoundedDiscrete(min=4L, max=48L)
            public int sphereResolution = 16;
            @ConfigEntry.Gui.Tooltip(count=4)
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public EffectRenderType effectRenderType = EffectRenderType.ALL;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Developer {
        @ConfigEntry.Gui.Tooltip
        public boolean displayElementalGauges = false;
        @ConfigEntry.Gui.Tooltip
        public boolean displayGaugeRuler = false;
        @ConfigEntry.Gui.Tooltip
        public boolean genshinDamageLim = false;
        @ConfigEntry.Gui.Tooltip
        public boolean commafyDamage = false;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum EffectRenderType {
        NONE(false, false),
        SPECIAL(true, false),
        ALL(true, true);

        private boolean special;
        private boolean normal;

        private EffectRenderType(boolean special, boolean normal) {
            this.special = special;
            this.normal = normal;
        }

        public boolean allowsSpecialEffects() {
            return this.special;
        }

        public boolean allowsNormalEffects() {
            return this.normal;
        }
    }
}

