/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.util;

import java.util.Iterator;
import java.util.function.Predicate;

public final class FilteredIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Predicate<? super T> predicate;
    private T next;
    private boolean hasNext;
    private boolean computed;
    private boolean canRemove;

    private FilteredIterator(Iterator<T> iterator, Predicate<? super T> predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
    }

    public static <T> FilteredIterator<T> of(Iterator<T> iterator, Predicate<? super T> predicate) {
        return new FilteredIterator<T>(iterator, predicate);
    }

    private void computeNext() {
        if (this.computed) {
            return;
        }
        while (this.iterator.hasNext()) {
            T value = this.iterator.next();
            if (!this.predicate.test(value)) continue;
            this.next = value;
            this.hasNext = true;
            this.computed = true;
            return;
        }
        this.next = null;
        this.hasNext = false;
        this.computed = true;
    }

    @Override
    public boolean hasNext() {
        this.computeNext();
        this.canRemove = false;
        return this.hasNext;
    }

    @Override
    public T next() {
        this.computeNext();
        this.computed = false;
        this.canRemove = true;
        return this.next;
    }

    @Override
    public void remove() {
        if (!this.canRemove) {
            throw new IllegalStateException("remove() can only be called once after next()");
        }
        this.iterator.remove();
        this.canRemove = false;
    }
}

