/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.registry.dynamic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.registry.SevenElementsRegistryKeys;
import io.github.xrickastley.sevenelements.registry.dynamic.DynamicRegistryLoadEvents;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7654;
import net.minecraft.class_7655;
import org.jetbrains.annotations.Nullable;

public final class SevenElementsRegistryLoader {
    private static final List<Entry<?, ?>> DYNAMIC_REGISTRIES = new ArrayList();
    private static final Multimap<class_5321<?>, class_2960> UNMODIFIABLE_ENTRIES = HashMultimap.create();

    static void add(Entry<?, ?> entry) {
        DYNAMIC_REGISTRIES.add(entry);
    }

    static void addUnmodifiableEntries(class_5321<? extends class_2378<?>> key, class_2960 ... ids) {
        SevenElementsRegistryLoader.addUnmodifiableEntries(key, List.of(ids));
    }

    static void addUnmodifiableEntries(class_5321<? extends class_2378<?>> key, List<class_2960> ids) {
        if (!SevenElementsRegistryLoader.isDynamicRegistry(key)) {
            throw new IllegalArgumentException("You may only pass a dynamic registry registered to the SevenElementsRegistryLoader!");
        }
        UNMODIFIABLE_ENTRIES.putAll(key, ids);
    }

    public static <E> void load(class_6903.class_7863 registryInfoGetter, class_3300 resourceManager, class_5321<? extends class_2378<E>> registryRef, class_2385<E> newRegistry, Decoder<E> decoder, Map<class_5321<?>, Exception> exceptions) {
        @Nullable Entry<E, C> dynRegEntry = SevenElementsRegistryLoader.getDynamicRegistry(newRegistry);
        if (dynRegEntry == null) {
            throw new IllegalArgumentException("You may only pass a dynamic registry registered to the SevenElementsRegistryLoader!");
        }
        ((DynamicRegistryLoadEvents.BeforeLoad)DynamicRegistryLoadEvents.BEFORE_LOAD.invoker()).onBeforeLoad(new DynamicRegistryLoadEvents.RegistryContextImpl<E>(registryRef, newRegistry));
        dynRegEntry.requireUnmodifiableEntries(newRegistry);
        String path = dynRegEntry.getPath();
        class_7654 resourceFinder = class_7654.method_45114((String)path);
        class_6903 registryOps = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_6903.class_7863)registryInfoGetter);
        for (Map.Entry entry : resourceFinder.method_45113(resourceManager).entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            class_2960 resourceId = resourceFinder.method_45115(identifier);
            if (dynRegEntry.isUnmodifiable(resourceId)) {
                SevenElements.sublogger().warn("The data pack (\"{}\") with file at path ({}/{}) attempted to overwrite the preloaded entry {}, ignoring!", new Object[]{((class_3298)entry.getValue()).method_14480(), identifier.method_12836(), identifier.method_12832(), resourceId});
                continue;
            }
            class_5321 registryKey = class_5321.method_29179(registryRef, (class_2960)resourceId);
            class_3298 resource = (class_3298)entry.getValue();
            try {
                SevenElementsRegistryLoader.parseAndAdd(newRegistry, (Entry)ClassInstanceUtil.cast(dynRegEntry), (class_6903<JsonElement>)registryOps, registryKey, resourceId, resource);
            }
            catch (Exception var15) {
                exceptions.put(registryKey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", identifier, resource.method_14480()), var15));
            }
        }
        ((DynamicRegistryLoadEvents.AfterLoad)DynamicRegistryLoadEvents.AFTER_LOAD.invoker()).onAfterLoad(new DynamicRegistryLoadEvents.RegistryContextImpl<E>(registryRef, newRegistry));
    }

    public static <E> void parseAndAdd(class_2385<E> registry, Entry<E, ?> entry, class_6903<JsonElement> ops, class_5321<E> key, class_2960 identifier, class_3298 resource) throws IOException {
        try (BufferedReader reader = resource.method_43039();){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            class_3545<E, DataResult<?>> pair = entry.parse(ops, jsonElement, identifier);
            Object object = pair.method_15442();
            DataResult dataResult = (DataResult)pair.method_15441();
            registry.method_10272(key, object, resource.method_45305() ? Lifecycle.stable() : dataResult.lifecycle());
            ((DynamicRegistryLoadEvents.EntryLoad)DynamicRegistryLoadEvents.ENTRY_LOAD.invoker()).onEntryLoad(new DynamicRegistryLoadEvents.RegistryEntryContextImpl<Object>(object, (class_5321<class_2378<Object>>)registry.method_30517(), (class_2378<Object>)registry));
        }
    }

    public static boolean isDynamicRegistry(class_2378<?> registry) {
        return SevenElementsRegistryLoader.isDynamicRegistry(registry.method_30517());
    }

    public static boolean isDynamicRegistry(class_5321<? extends class_2378<?>> registryKey) {
        return DYNAMIC_REGISTRIES.stream().anyMatch(entry -> entry.key == registryKey);
    }

    @Nullable
    private static <T, C> Entry<T, C> getDynamicRegistry(class_2378<T> registry) {
        return SevenElementsRegistryLoader.getDynamicRegistry(registry.method_30517());
    }

    @Nullable
    private static <T, C> Entry<T, C> getDynamicRegistry(class_5321<? extends class_2378<T>> registryKey) {
        for (Entry<?, ?> entry : DYNAMIC_REGISTRIES) {
            if (entry.key != registryKey) continue;
            return (Entry)ClassInstanceUtil.cast(entry);
        }
        return null;
    }

    static {
        new IdentifiedEntry<InternalCooldownType, InternalCooldownType.Builder>(InternalCooldownType.class, SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE, InternalCooldownType.Builder.CODEC, InternalCooldownType.Builder::getInstance);
    }

    public static class Entry<T, C> {
        private final Class<T> entryClass;
        private final class_5321<? extends class_2378<T>> key;
        private final Codec<C> elementCodec;
        private boolean useNamespace = false;

        public Entry(Class<T> entryClass, class_5321<? extends class_2378<T>> registryKey, Codec<C> codec) {
            this.entryClass = entryClass;
            this.key = registryKey;
            this.elementCodec = codec;
        }

        public void shouldUseNamespace(boolean useNamespace) {
            this.useNamespace = useNamespace;
        }

        public String getPath() {
            String path = this.key.method_29177().method_12832();
            return this.useNamespace ? this.key.method_29177().method_12836() + "/" + path : path;
        }

        public class_7655.class_7657<T> asRegistryLoaderEntry() {
            return new class_7655.class_7657(this.key, (Codec)ClassInstanceUtil.cast(this.elementCodec));
        }

        public class_3545<T, DataResult<C>> parse(class_6903<JsonElement> ops, JsonElement jsonElement, class_2960 identifier) {
            DataResult dataResult = this.elementCodec.parse(ops, (Object)jsonElement);
            return new class_3545(this.entryClass.cast(dataResult.getOrThrow(false, error -> {})), (Object)dataResult);
        }

        public class_3545<T, DataResult<C>> parse(class_6903<class_2520> ops, class_2520 nbt, class_2960 identifier) {
            DataResult dataResult = this.elementCodec.parse(ops, (Object)nbt);
            return new class_3545(this.entryClass.cast(dataResult.getOrThrow(false, error -> {})), (Object)dataResult);
        }

        public boolean isUnmodifiable(class_2960 id) {
            @Nullable Collection entries = UNMODIFIABLE_ENTRIES.get(this.key);
            return entries != null && entries.contains(id);
        }

        public void requireUnmodifiableEntries(class_2385<?> registry) {
            @Nullable Collection entries = UNMODIFIABLE_ENTRIES.get(this.key);
            if (entries == null) {
                return;
            }
            List<class_2960> unregistered = entries.stream().filter(Predicate.not(arg_0 -> registry.method_10250(arg_0))).toList();
            if (unregistered.isEmpty()) {
                return;
            }
            throw new IllegalStateException("Some unmodifiable holders were not registered: " + String.valueOf(unregistered));
        }
    }

    public static class IdentifiedEntry<T, R>
    extends Entry<T, R> {
        private final BiFunction<R, class_2960, T> resultFn;

        public IdentifiedEntry(Class<T> resultClass, class_5321<? extends class_2378<T>> registryKey, Codec<R> resultCodec, BiFunction<R, class_2960, T> resultFn) {
            super(resultClass, registryKey, resultCodec);
            this.resultFn = resultFn;
        }

        @Override
        public class_3545<T, DataResult<R>> parse(class_6903<JsonElement> ops, JsonElement jsonElement, class_2960 identifier) {
            DataResult dataResult = this.elementCodec.parse(ops, (Object)jsonElement);
            return new class_3545(this.resultFn.apply(dataResult.getOrThrow(false, error -> {}), identifier), (Object)dataResult);
        }

        @Override
        public class_3545<T, DataResult<R>> parse(class_6903<class_2520> ops, class_2520 nbt, class_2960 identifier) {
            DataResult dataResult = this.elementCodec.parse(ops, (Object)nbt);
            return new class_3545(this.resultFn.apply(dataResult.getOrThrow(false, error -> {}), identifier), (Object)dataResult);
        }
    }
}

