package io.github.xrickastley.sevenelements.component;

import com.mojang.serialization.Codec;

import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import net.minecraft.class_4050;

public final class FrozenEffectComponentImpl implements FrozenEffectComponent {
	private static final Codec<class_4050> ENTITY_POSE_CODEC = Codec.INT.xmap(class_4050.field_48322::apply, class_4050::method_56081);

	private final class_1309 owner;
	private boolean isFrozen = false;
	private boolean hadNoAi = false;
	private class_4050 forcePose = class_4050.field_18076;
	private float forceHeadYaw = 0.0f;
	private float forceBodyYaw = 0.0f;
	private float forcePitch = 0.0f;
	private float forceLimbAngle = 0.0f;
	private float forceLimbDistance = 0.0f;
	private int ticksFrozen = 0;

	public FrozenEffectComponentImpl(class_1309 owner) {
		this.owner = owner;
	}

	@Override
	public void readData(class_11368 view) {
		this.isFrozen = view.method_71433("IsFrozen", this.isFrozen);
		this.hadNoAi = view.method_71433("HadNoAi", this.hadNoAi);
		this.forcePose = view.method_71426("ForcePose", ENTITY_POSE_CODEC).orElse(this.forcePose);
		this.forceHeadYaw = view.method_71423("ForceHeadYaw", this.forceHeadYaw);
		this.forceBodyYaw = view.method_71423("ForceBodyYaw", this.forceBodyYaw);
		this.forcePitch = view.method_71423("ForcePitch", this.forcePitch);
		this.forceLimbAngle = view.method_71423("ForceLimbAngle", this.forceLimbAngle);
		this.forceLimbDistance = view.method_71423("ForceLimbDistance", this.forceLimbDistance);
		this.ticksFrozen = view.method_71424("TicksFrozen", this.ticksFrozen);
	}

	@Override
	public void writeData(class_11372 view) {
		view.method_71472("IsFrozen", this.isFrozen);
		view.method_71472("HadNoAi", this.hadNoAi);
		view.method_71468("ForcePose", ENTITY_POSE_CODEC, this.forcePose);
		view.method_71464("ForceHeadYaw", this.forceHeadYaw);
		view.method_71464("ForceBodyYaw", this.forceBodyYaw);
		view.method_71464("ForcePitch", this.forcePitch);
		view.method_71464("ForceLimbAngle", this.forceLimbAngle);
		view.method_71464("ForceLimbDistance", this.forceLimbDistance);
		view.method_71465("TicksFrozen", this.ticksFrozen);
	}

	@Override
	public void clientTick() {
		if (!this.owner.method_6059(SevenElementsStatusEffects.FROZEN) && this.isFrozen)
			this.unfreeze();

		if (!this.isFrozen()) return;

		owner.method_18380(this.forcePose);
		owner.method_5847(this.forceBodyYaw);
		owner.method_5636(this.forceBodyYaw);
		owner.method_36457(this.forcePitch);
	}

	@Override
	public void serverTick() {
		if (!this.owner.method_6059(SevenElementsStatusEffects.FROZEN) && this.isFrozen)
			this.unfreeze();
	}

	public boolean isFrozen() {
		return this.isFrozen;
	}

	public class_4050 getForcePose() {
		return this.forcePose;
	}

	public float getForceHeadYaw() {
		return this.forceHeadYaw;
	}

	public float getForceBodyYaw() {
		return this.forceBodyYaw;
	}

	public float getForcePitch() {
		return this.forcePitch;
	}

	public float getForceLimbAngle() {
		return this.forceLimbAngle;
	}

	public float getForceLimbDistance() {
		return this.forceLimbDistance;
	}

	public void freeze() {
		if (this.isFrozen) return;

		this.isFrozen = true;
		this.hadNoAi = owner instanceof final class_1308 mob && mob.method_5987();
		this.forcePose = owner.method_18376();
		this.forceHeadYaw = owner.method_5791();
		this.forceBodyYaw = owner.method_73188();
		this.forcePitch = owner.method_36455();
		this.forceLimbAngle = class_3532.method_15344(owner.method_59922(), 0, 0.5f);
		this.forceLimbDistance = class_3532.method_15344(owner.method_59922(), -0.5f, 0.5f);
		this.ticksFrozen = owner.method_32312();

		owner.method_5803(true);

		if (owner instanceof final class_1308 mob) mob.method_5977(true);

		FrozenEffectComponent.sync(owner);
	}

	public void unfreeze() {
		if (!this.isFrozen) return;

		this.isFrozen = false;

		owner.method_5803(false);

		if (owner instanceof final class_1308 mob) mob.method_5977(this.hadNoAi);

		owner.method_32317(this.ticksFrozen);

		FrozenEffectComponent.sync(owner);
	}
}
