package io.github.xrickastley.sevenelements.gui.render.state;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public record CircleGuiElementRenderState(RenderPipeline pipeline, Matrix3x2f matrix, float x, float y, float radius, int color, @Nullable class_8030 scissorArea, @Nullable class_8030 bounds) implements class_11244 {
	public CircleGuiElementRenderState(RenderPipeline pipeline, Matrix3x2f matrix, float x, float y, float radius, int color, @Nullable class_8030 scissorArea) {
		this(pipeline, matrix, x, y, radius, color, scissorArea, createBounds(x, y, radius, matrix, scissorArea));
	}

	@Nullable
	private static class_8030 createBounds(float x, float y, float radius, Matrix3x2f matrix, @Nullable class_8030 scissorArea) {
		final class_8030 screenRect = new class_8030(
			(int) Math.floor(x - radius),
			(int) Math.floor(y - radius),
			(int) Math.ceil(x + radius),
			(int) Math.ceil(y + radius)
		).method_71523(matrix);

		return scissorArea != null ? scissorArea.method_49701(screenRect) : screenRect;
	}

	@Override
	public void method_70917(class_4588 vertices) {
		vertices.method_70815(this.matrix, this.x - this.radius, this.y + this.radius).method_22913(0, 0).method_39415(this.color);
		vertices.method_70815(this.matrix, this.x + this.radius, this.y + this.radius).method_22913(1, 0).method_39415(this.color);
		vertices.method_70815(this.matrix, this.x + this.radius, this.y - this.radius).method_22913(1, 1).method_39415(this.color);
		vertices.method_70815(this.matrix, this.x - this.radius, this.y - this.radius).method_22913(0, 1).method_39415(this.color);
	}

	@Override
	public class_11231 comp_4056() {
		return class_11231.method_70899();
	}
}
