package io.github.xrickastley.sevenelements.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.interfaces.IEnderDragonFight;
import net.minecraft.class_1510;
import net.minecraft.class_2881;
import net.minecraft.class_3213;

@Mixin(class_2881.class)
public class EnderDragonFightMixin implements IEnderDragonFight {
	@Shadow
	@Final
	private class_3213 bossBar;

	@Unique
	public void sevenelements$setDragon(class_1510 enderDragon) {
		this.bossBar.sevenelements$setEntity(enderDragon);
	}

	@Inject(
		method = "updateFight",
		at = @At("HEAD")
	)
	private void updateDragonEntity(class_1510 dragon, CallbackInfo ci) {
		if (this.bossBar.sevenelements$getEntity() == null) this.bossBar.sevenelements$setEntity(dragon);
	}
}
