/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element.reaction;

import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.reaction.CryoSwirlElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElectroSwirlElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.FrozenSwirlElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.HydroSwirlElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.PyroSwirlElementalReaction;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypes;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public abstract sealed class AbstractSwirlElementalReaction
extends ElementalReaction
permits PyroSwirlElementalReaction, HydroSwirlElementalReaction, ElectroSwirlElementalReaction, CryoSwirlElementalReaction, FrozenSwirlElementalReaction {
    private final Element swirlElement;
    private final boolean elementalAbsorptionOnly;

    AbstractSwirlElementalReaction(ElementalReaction.Settings settings) {
        this(settings, settings.getAuraElement());
    }

    AbstractSwirlElementalReaction(ElementalReaction.Settings settings, boolean elementalAbsorptionOnly) {
        super(settings);
        this.swirlElement = settings.getAuraElement();
        this.elementalAbsorptionOnly = elementalAbsorptionOnly;
    }

    AbstractSwirlElementalReaction(ElementalReaction.Settings settings, Element swirlElement) {
        super(settings);
        this.swirlElement = swirlElement;
        this.elementalAbsorptionOnly = false;
    }

    @Override
    protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
        class_1937 class_19372 = entity.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        double gaugeOriginAura = auraElement.getCurrentGauge() + reducedGauge;
        double gaugeAnemo = triggeringElement.getCurrentGauge() + reducedGauge;
        double gaugeReaction = gaugeOriginAura >= 0.5 * gaugeAnemo ? gaugeAnemo : gaugeOriginAura;
        double gaugeSwirlAttack = (gaugeReaction - 0.04) * 1.25 + 1.0;
        for (class_1309 target : ElementalReaction.getEntitiesInAoE(entity, 6.0, t -> t != origin)) {
            float damage = !this.elementalAbsorptionOnly || target == entity ? ElementalReaction.getReactionDamage((class_1297)entity, 0.6) : 0.0f;
            ElementalDamageSource source = new ElementalDamageSource(entity.method_48923().method_48796(SevenElementsDamageTypes.SWIRL, (class_1297)origin), ElementalApplications.gaugeUnits(target, this.swirlElement, target == entity ? 0.0 : gaugeSwirlAttack, true), InternalCooldownContext.ofNone(origin)).shouldApplyDMGBonus(false);
            target.method_64397(world, (class_1282)source, damage);
        }
    }
}

