/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.entity;

import com.mojang.serialization.Codec;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReactions;
import io.github.xrickastley.sevenelements.entity.SevenElementsEntity;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypes;
import io.github.xrickastley.sevenelements.registry.SevenElementsEntityTypeTags;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.ViewHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_4844;
import net.minecraft.class_5699;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public final class DendroCoreEntity
extends SevenElementsEntity {
    private static final double SPRAWLING_SHOT_SPEED = 0.75;
    private static final double SPRAWLING_SHOT_GRAVITY = -0.05;
    private static final double SPRAWLING_SHOT_RADIUS = 24.0;
    private static final int SPRAWLING_SHOT_DELAY = 6;
    private static final double DENDRO_CORES_IN_RADIUS = 64.0;
    private List<UUID> owners;
    @Nullable
    private UUID target;
    private Type type = Type.NORMAL;
    private boolean exploded = false;
    private int hyperbloomAge = 0;
    private int curTicksInHitbox = 0;

    public DendroCoreEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        this(entityType, world, null);
    }

    public DendroCoreEntity(class_1299<? extends class_1309> entityType, class_1937 world, @Nullable class_1309 owner) {
        super(entityType, world);
        this.owners = new ArrayList<UUID>();
        if (owner != null) {
            this.owners.add(owner.method_5667());
        }
    }

    public DendroCoreEntity setOwner(class_1309 owner) {
        this.owners = new ArrayList<UUID>();
        if (owner != null) {
            this.owners.add(owner.method_5667());
        }
        return this;
    }

    public DendroCoreEntity addOwner(class_1309 owner) {
        if (owner != null) {
            this.owners.add(owner.method_5667());
        }
        return this;
    }

    public void setAsHyperbloom() {
        if (this.type != Type.NORMAL) {
            throw new IllegalStateException("This DendroCoreEntity has already been transformed! Type: " + String.valueOf((Object)this.type));
        }
        this.type = Type.HYPERBLOOM;
        this.hyperbloomAge = this.field_6012;
        this.field_5960 = true;
        this.method_5875(true);
        @Nullable class_1309 target = ElementalReaction.getEntitiesInAoE(this, 24.0).stream().filter(e -> !this.owners.contains(e.method_5667()) && !e.method_29504() && !(e instanceof SevenElementsEntity) && !e.method_5864().method_20210(SevenElementsEntityTypeTags.IGNORED_TARGETS)).min(Comparator.comparing(e -> e.method_5858((class_1297)this))).orElse(null);
        if (target == null) {
            return;
        }
        this.target = target.method_5667();
        this.sendSyncPayload();
    }

    public void setAsBurgeon() {
        if (this.type != Type.NORMAL) {
            throw new IllegalStateException("This DendroCoreEntity has already been transformed! Type: " + String.valueOf((Object)this.type));
        }
        this.type = Type.BURGEON;
        this.explode(3.0);
    }

    public boolean isNormal() {
        return this.type == Type.NORMAL;
    }

    public boolean isHyperbloom() {
        return this.type == Type.HYPERBLOOM;
    }

    public boolean isBurgeon() {
        return this.type == Type.BURGEON;
    }

    public void syncFromPayload(SyncDendroCoreS2CPayload payload) {
        this.type = payload.type;
        this.field_6012 = payload.age;
    }

    public void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71468("Type", Type.CODEC, (Object)this.type);
        view.method_71477("Target", class_4844.field_40825, (Object)this.target);
        ViewHelper.putList(view, "Owners", class_4844.field_40825, this.owners);
    }

    public void method_5749(class_11368 view) {
        super.method_5749(view);
        this.type = view.method_71426("Type", Type.CODEC).orElse(Type.NORMAL);
        this.target = view.method_71426("Target", class_4844.field_40825).orElse(null);
        this.owners.clear();
        this.owners.addAll(ViewHelper.getList(view, "Owners", class_4844.field_40825));
    }

    private void doHyperbloom() {
        class_1937 class_19372 = this.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        int hyperbloomTick = this.field_6012 - this.hyperbloomAge;
        class_1309 target = ClassInstanceUtil.castOrNull(world.method_66347(this.target), class_1309.class);
        if (target != null) {
            class_243 targetPos = target.method_33571().method_1020(this.method_73189());
            double distance = Math.sqrt(targetPos.field_1352 * targetPos.field_1352 + targetPos.field_1350 * targetPos.field_1350);
            int ticks = Math.max(1, (int)(distance / 0.75));
            class_243 velocity = new class_243(targetPos.field_1352 / (double)ticks, (targetPos.field_1351 - -0.025 * (double)ticks * (double)ticks) / (double)ticks, targetPos.field_1350 / (double)ticks);
            super.method_18799(velocity);
            class_238 boundingBox = target.method_5829();
            if (!boundingBox.method_1006(this.method_73189())) {
                return;
            }
            ++this.curTicksInHitbox;
            if (this.curTicksInHitbox < 6) {
                return;
            }
            for (class_1297 class_12972 : ElementalReaction.getEntitiesInAoE(target, 1.0, e -> !this.owners.contains(e.method_5667()))) {
                class_12972.method_64397(world, (class_1282)this.createDamageSource(target), ElementalReaction.getReactionDamage((class_1297)this, 3.0));
            }
            this.method_5650(class_1297.class_5529.field_26998);
            this.method_73183().method_8396(null, this.method_24515(), SevenElementsSoundEvents.SPRAWLING_SHOT_HIT, class_3419.field_15248, 0.5f, 1.0f);
        } else {
            super.method_18799(new class_243(0.0, 0.5, 0.0));
            if (hyperbloomTick >= 40) {
                this.method_5650(class_1297.class_5529.field_26998);
            }
        }
    }

    @Override
    public void method_5768(class_3218 world) {
        this.explode(2.0);
    }

    @Override
    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        ElementalDamageSource eds;
        block5: {
            block4: {
                if (!((source = ElementComponent.applyElementalInfusions(source, this)) instanceof ElementalDamageSource)) break block4;
                eds = (ElementalDamageSource)source;
                if (this.isNormal()) break block5;
            }
            return false;
        }
        Element element = eds.getElementalApplication().getElement();
        if (element != Element.PYRO && element != Element.ELECTRO) {
            return false;
        }
        ElementalReaction reaction = element == Element.PYRO ? ElementalReactions.BURGEON : ElementalReactions.HYPERBLOOM;
        reaction.trigger(this, ClassInstanceUtil.castOrNull(source.method_5529(), class_1309.class));
        return true;
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6012 == 1) {
            this.removeOldDendroCores();
        }
        if (this.type == Type.HYPERBLOOM) {
            this.doHyperbloom();
        }
        if (this.field_6012 >= 120 && this.type != Type.HYPERBLOOM) {
            this.explode(2.0);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    private void removeOldDendroCores() {
        class_1937 class_19372 = this.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        class_238 box = class_238.method_30048((class_243)this.method_30950(1.0f), (double)64.0, (double)64.0, (double)64.0);
        List dendroCores = this.method_73183().method_8390(DendroCoreEntity.class, box, dc -> true);
        if (dendroCores.size() <= 5) {
            return;
        }
        dendroCores.sort(Comparator.comparing(SevenElementsEntity::getAge).reversed());
        LinkedList queue = new LinkedList(dendroCores);
        while (queue.peek() != null && queue.size() > 5) {
            ((DendroCoreEntity)((Object)queue.remove())).method_5768(world);
        }
    }

    private boolean explode(double reactionMultiplier) {
        class_1937 class_19372 = this.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 world = (class_3218)class_19372;
        if (this.exploded) {
            return false;
        }
        this.exploded = true;
        this.field_6012 = 117;
        if (!this.method_73183().method_8608()) {
            this.sendSyncPayload();
        }
        @Nullable class_1309 recentOwner = this.getRecentOwner();
        for (class_1309 target : ElementalReaction.getEntitiesInAoE(this, 5.0)) {
            if (target instanceof DendroCoreEntity) continue;
            ElementalDamageSource source = this.createDamageSource(target, recentOwner);
            float damage = ElementalReaction.getReactionDamage((class_1297)this, reactionMultiplier);
            if (this.owners.contains(target.method_5667())) {
                damage *= 0.02f;
            }
            target.method_64397(world, (class_1282)source, damage);
        }
        this.method_73183().method_8396(null, this.method_24515(), SevenElementsSoundEvents.DENDRO_CORE_EXPLOSION, class_3419.field_15248, 0.5f, 1.0f);
        return true;
    }

    @Nullable
    private class_1309 getRecentOwner() {
        return !this.owners.isEmpty() && this.method_73183() instanceof class_3218 ? this.getEntityFromUUID(this.owners.get(this.owners.size() - 1)) : null;
    }

    private ElementalDamageSource createDamageSource(class_1309 target) {
        @Nullable class_1309 recentOwner = this.getRecentOwner();
        return this.createDamageSource(target, recentOwner);
    }

    private ElementalDamageSource createDamageSource(class_1309 target, class_1309 recentOwner) {
        return new ElementalDamageSource(this.method_73183().method_48963().method_48797(SevenElementsDamageTypes.DENDRO_CORE, (class_1297)this, (class_1297)recentOwner), ElementalApplications.gaugeUnits(target, Element.DENDRO, 0.0), InternalCooldownContext.ofNone(recentOwner)).shouldApplyDMGBonus(false);
    }

    private void sendSyncPayload() {
        SyncDendroCoreS2CPayload packet = new SyncDendroCoreS2CPayload(this);
        for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)this)) {
            ServerPlayNetworking.send((class_3222)otherPlayer, (class_8710)packet);
        }
    }

    static {
        ElementComponent.denyElementsFor(DendroCoreEntity.class);
    }

    private static enum Type {
        NORMAL,
        HYPERBLOOM,
        BURGEON;

        static final Codec<Type> CODEC;

        static {
            CODEC = class_5699.field_41759.xmap(Type::valueOf, Enum::toString);
        }
    }

    public static class SyncDendroCoreS2CPayload
    implements class_8710 {
        public static final class_8710.class_9154<SyncDendroCoreS2CPayload> ID = new class_8710.class_9154(SevenElements.identifier("s2c/sync_dendro_core"));
        public static final class_9139<class_9129, SyncDendroCoreS2CPayload> CODEC = class_9139.method_56436((class_9139)class_9135.field_49675, inst -> inst.entityId, (class_9139)class_9135.field_49675, inst -> inst.age, (class_9139)class_9135.method_56368(Type.CODEC), inst -> inst.type, SyncDendroCoreS2CPayload::new);
        private final int entityId;
        private final int age;
        private final Type type;

        private SyncDendroCoreS2CPayload(int entityId, int age, Type type) {
            this.entityId = entityId;
            this.age = age;
            this.type = type;
        }

        private SyncDendroCoreS2CPayload(DendroCoreEntity dendroCore) {
            this.entityId = dendroCore.method_5628();
            this.age = dendroCore.getAge();
            this.type = dendroCore.type;
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }

        public int entityId() {
            return this.entityId;
        }
    }
}

