/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.compat;

import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownTag;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.element.PartialElementalDamageSource;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

public class SpellPowerCompat {
    private static final Map<class_2960, Entry> SPELL_INFUSIONS = new HashMap<class_2960, Entry>();

    public static void registerInfusion(class_2960 spellSchoolId, Element element) {
        SpellPowerCompat.registerInfusion(spellSchoolId, ElementalApplications.builder().setElement(element).setType(ElementalApplication.Type.GAUGE_UNIT).setGaugeUnits(1.0));
    }

    public static void registerInfusion(class_2960 spellSchoolId, ElementalApplication.Builder infusionBuilder) {
        SpellPowerCompat.registerInfusion(spellSchoolId, infusionBuilder, InternalCooldownContext.builder().setTag(InternalCooldownTag.of("spell_power:spell_school")).setType(InternalCooldownType.DEFAULT));
    }

    public static void registerInfusion(class_2960 spellSchoolId, ElementalApplication.Builder infusionBuilder, InternalCooldownContext.Builder icdBuilder) {
        if (SPELL_INFUSIONS.containsKey(spellSchoolId)) {
            throw new IllegalStateException("The provided Spell Power id: " + String.valueOf(spellSchoolId) + " has already been registered!");
        }
        SPELL_INFUSIONS.put(spellSchoolId, new Entry(infusionBuilder, icdBuilder));
    }

    @ApiStatus.Internal
    public static class_1282 create(class_1309 target, class_1282 source, class_2960 spellSchoolId) {
        if (!FabricLoader.getInstance().isModLoaded("spell_power")) {
            return source;
        }
        return SPELL_INFUSIONS.containsKey(spellSchoolId) ? SPELL_INFUSIONS.get(spellSchoolId).create(target, source) : source;
    }

    @ApiStatus.Internal
    public static class_1282 create(class_1282 source, class_2960 spellSchoolId) {
        if (!FabricLoader.getInstance().isModLoaded("spell_power")) {
            return source;
        }
        return SPELL_INFUSIONS.containsKey(spellSchoolId) ? SPELL_INFUSIONS.get(spellSchoolId).create(source) : source;
    }

    static {
        SpellPowerCompat.registerInfusion(class_2960.method_43902((String)"spell_power", (String)"fire"), Element.PYRO);
        SpellPowerCompat.registerInfusion(class_2960.method_43902((String)"spell_power", (String)"water"), Element.HYDRO);
        SpellPowerCompat.registerInfusion(class_2960.method_43902((String)"spell_power", (String)"air"), Element.ANEMO);
        SpellPowerCompat.registerInfusion(class_2960.method_43902((String)"spell_power", (String)"lightning"), Element.ELECTRO);
        SpellPowerCompat.registerInfusion(class_2960.method_43902((String)"spell_power", (String)"frost"), Element.CRYO);
        SpellPowerCompat.registerInfusion(class_2960.method_43902((String)"spell_power", (String)"earth"), Element.GEO);
    }

    @ApiStatus.Internal
    private record Entry(ElementalApplication.Builder infusionBuilder, InternalCooldownContext.Builder icdBuilder) {
        public ElementalDamageSource create(class_1309 target, class_1282 source) {
            return new ElementalDamageSource(source, this.infusionBuilder.build(target), this.icdBuilder.build(ClassInstanceUtil.castOrNull(source.method_5529(), class_1309.class)));
        }

        public PartialElementalDamageSource create(class_1282 source) {
            return new PartialElementalDamageSource(source, this.infusionBuilder, this.icdBuilder.build(ClassInstanceUtil.castOrNull(source.method_5529(), class_1309.class)));
        }
    }
}

