/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.component;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementHolder;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.PartialElementalDamageSource;
import io.github.xrickastley.sevenelements.element.reaction.AbstractBurningElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElectroChargedElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.FrozenElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.QuickenElementalReaction;
import io.github.xrickastley.sevenelements.events.ElementEvents;
import io.github.xrickastley.sevenelements.factory.SevenElementsGameRules;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypeTags;
import io.github.xrickastley.sevenelements.registry.SevenElementsEntityTypeTags;
import io.github.xrickastley.sevenelements.registry.SevenElementsRegistries;
import io.github.xrickastley.sevenelements.util.Array;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.ImmutablePair;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ElementComponentImpl
implements ElementComponent {
    static final Set<Class<class_1309>> DENIED_ENTITIES = new HashSet<Class<class_1309>>();
    static final Map<class_6862<class_1299<?>>, Element> ENTITY_TYPE_ELEMENT_MAP = new HashMap();
    static final Map<class_6862<class_8110>, Element> DAMAGE_TYPE_ELEMENT_MAP = new HashMap<class_6862<class_8110>, Element>();
    private final class_1309 owner;
    private final Map<Element, ElementHolder> elementHolders = new ConcurrentHashMap<Element, ElementHolder>();
    private final FreezeDecayHandler freezeDecayHandler;
    private class_3545<ElementalReaction, Long> lastReaction = new class_3545(null, (Object)-1L);
    private long electroChargedCooldown = -1L;
    @Nullable
    private class_1309 electroChargedOrigin = null;
    private long burningCooldown = -1L;
    @Nullable
    private class_1309 burningOrigin = null;
    private CrystallizeShield crystallizeShield = null;
    private int crystallizeShieldReducedAt = -1;

    @ApiStatus.Internal
    public static <T extends class_1309> boolean canApplyElement(Class<T> entityClass) {
        return !DENIED_ENTITIES.contains(entityClass);
    }

    @ApiStatus.Internal
    public static ElementalDamageSource resolve(class_1282 source, class_1309 target) {
        ElementalDamageSource elementalDamageSource;
        if (source instanceof ElementalDamageSource) {
            ElementalDamageSource eds;
            elementalDamageSource = eds = (ElementalDamageSource)source;
        } else if (source instanceof PartialElementalDamageSource) {
            PartialElementalDamageSource partialEds = (PartialElementalDamageSource)source;
            elementalDamageSource = partialEds.resolve(target);
        } else {
            elementalDamageSource = ElementalDamageSource.of(source, target);
        }
        return elementalDamageSource;
    }

    public ElementComponentImpl(class_1309 owner) {
        this.owner = owner;
        this.freezeDecayHandler = new FreezeDecayHandler(this);
        for (Element element : Element.values()) {
            this.elementHolders.put(element, ElementHolder.of(owner, element));
        }
    }

    @Override
    public boolean isElectroChargedOnCD() {
        return this.owner.method_37908().method_8510() < this.electroChargedCooldown;
    }

    @Override
    public boolean isBurningOnCD() {
        return this.owner.method_37908().method_8510() < this.burningCooldown;
    }

    @Override
    public void resetElectroChargedCD() {
        this.electroChargedCooldown = this.owner.method_37908().method_8510() + 20L;
    }

    @Override
    public void resetBurningCD() {
        this.burningCooldown = this.owner.method_37908().method_8510() + 5L;
    }

    @Override
    public void setElectroChargedOrigin(@Nullable class_1309 origin) {
        this.electroChargedOrigin = origin;
    }

    @Override
    public void setBurningOrigin(@Nullable class_1309 origin) {
        this.burningOrigin = origin;
    }

    @Override
    @Nullable
    public class_1309 getElectroChargedOrigin() {
        return this.electroChargedOrigin;
    }

    @Override
    @Nullable
    public class_1309 getBurningOrigin() {
        return this.burningOrigin;
    }

    @Override
    public double getFreezeDecayTimeModifier() {
        return this.freezeDecayHandler.getDecayTimeModifier();
    }

    @Override
    public void setCrystallizeShield(Element element, double amount) {
        this.crystallizeShield = new CrystallizeShield(element, amount, this.owner.method_37908().method_8510());
        ElementComponent.sync((class_1297)this.owner);
    }

    @Override
    @Nullable
    public class_3545<Element, Double> getCrystallizeShield() {
        return this.crystallizeShield == null ? null : new class_3545((Object)this.crystallizeShield.element, (Object)this.crystallizeShield.amount);
    }

    @Override
    public float reduceCrystallizeShield(class_1282 source, float amount) {
        if (this.crystallizeShield == null) {
            return 0.0f;
        }
        ElementalDamageSource[] elementalDamageSourceArray = new ElementalDamageSource[]{ClassInstanceUtil.castOrNull(source, ElementalDamageSource.class), ElementalDamageSource.of(source, this.owner)};
        ElementalDamageSource eds = JavaScriptUtil.nullishCoalesing(elementalDamageSourceArray);
        float reduced = this.crystallizeShield.reduce(eds, amount);
        if (reduced > 0.0f) {
            this.crystallizeShieldReducedAt = this.owner.field_6012;
        }
        if (this.crystallizeShield == null || this.crystallizeShield.isEmpty()) {
            this.owner.method_37908().method_8396(null, this.owner.method_24515(), SevenElementsSoundEvents.CRYSTALLIZE_SHIELD_BREAK, class_3419.field_15248, 1.0f, 1.0f);
        }
        return reduced;
    }

    @Override
    public boolean reducedCrystallizeShield() {
        return this.crystallizeShieldReducedAt == this.owner.field_6012;
    }

    @Override
    public class_1309 getOwner() {
        return this.owner;
    }

    @Override
    public ElementHolder getElementHolder(Element element) {
        return this.elementHolders.computeIfAbsent(element, e -> ElementHolder.of(this.owner, e));
    }

    @Override
    public class_3545<ElementalReaction, Long> getLastReaction() {
        return ImmutablePair.of(this.lastReaction);
    }

    public void setLastReaction(class_3545<ElementalReaction, Long> lastReaction) {
        this.lastReaction = lastReaction;
    }

    @Override
    public boolean canApplyElement(Element element, InternalCooldownContext icdContext, boolean handleICD) {
        if (element.bypassesInternalCooldown() || !icdContext.hasInternalCooldown()) {
            return true;
        }
        return this.getElementHolder(element).canApplyElement(element, icdContext, true) && DENIED_ENTITIES.stream().noneMatch(c -> c.isInstance(this.owner));
    }

    @Override
    public List<ElementalReaction> addElementalApplication(ElementalApplication application, InternalCooldownContext icdContext) {
        if (application.getEntity().method_37908().field_9236 || !application.getEntity().method_37908().method_8450().method_8355(SevenElementsGameRules.DO_ELEMENTS)) {
            return Collections.emptyList();
        }
        if (application.isGaugeUnits() && !application.isAuraElement() && this.getAppliedElements().isEmpty()) {
            application = application.asAura();
        }
        if (application.isGaugeUnits() && application.isAuraElement() && !this.getAppliedElements().isEmpty()) {
            application = application.asNonAura();
        }
        if (application.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.canApplyElement(application.getElement(), icdContext, true)) {
            return Collections.emptyList();
        }
        if (this.attemptReapply(application)) {
            return Collections.emptyList();
        }
        Set<ElementalReaction> triggeredReactions = this.triggerReactions(application, icdContext.getOrigin());
        ElementComponent.sync((class_1297)this.owner);
        return new ArrayList<ElementalReaction>(triggeredReactions);
    }

    @Override
    public Array<ElementalApplication> getAppliedElements() {
        return new Array<ElementalApplication>(this.elementHolders.values().stream().map(ElementHolder::getElementalApplication).filter(application -> application != null && !application.isEmpty()));
    }

    @Override
    public List<ElementalReaction> applyFromDamageSource(ElementalDamageSource source) {
        return this.addElementalApplication(source.getElementalApplication(), source.getIcdContext());
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 list = new class_2499();
        this.getAppliedElements().forEach(application -> list.add((Object)application.asNbt()));
        tag.method_10566("AppliedElements", (class_2520)list);
        tag.method_10544("SyncedAt", this.owner.method_37908().method_8510());
        tag.method_10544("ElectroChargedCooldown", this.electroChargedCooldown);
        tag.method_10544("BurningCooldown", this.burningCooldown);
        class_2487 freezeDecayHandler = new class_2487();
        this.freezeDecayHandler.writeToNbt(freezeDecayHandler);
        tag.method_10566("FreezeDecay", (class_2520)freezeDecayHandler);
        if (this.lastReaction.method_15442() != null) {
            class_2487 lastReaction = new class_2487();
            lastReaction.method_10582("Id", ((ElementalReaction)this.lastReaction.method_15442()).getId().toString());
            lastReaction.method_10544("Time", ((Long)this.lastReaction.method_15441()).longValue());
            tag.method_10566("LastReaction", (class_2520)lastReaction);
        }
        if (this.crystallizeShield != null && !this.crystallizeShield.isEmpty()) {
            this.crystallizeShield.writeToNbt(tag);
        }
    }

    public void readFromNbt(class_2487 tag) {
        this.electroChargedCooldown = tag.method_10537("ElectroChargedCooldown");
        this.burningCooldown = tag.method_10537("BurningCooldown");
        if (tag.method_10545("LastReaction")) {
            class_2487 lastReaction = tag.method_10562("LastReaction");
            this.lastReaction = new class_3545((Object)((ElementalReaction)SevenElementsRegistries.ELEMENTAL_REACTION.method_10223(class_2960.method_12829((String)lastReaction.method_10558("Id")))), (Object)lastReaction.method_10537("Time"));
        }
        this.crystallizeShield = tag.method_10545("CrystallizeShield") ? CrystallizeShield.ofNbt(tag.method_10562("CrystallizeShield")) : null;
        class_2499 list = tag.method_10554("AppliedElements", 10);
        long syncedAt = tag.method_10537("SyncedAt");
        this.elementHolders.values().forEach(holder -> holder.setElementalApplication(null));
        for (class_2520 nbt : list) {
            if (!(nbt instanceof class_2487)) {
                return;
            }
            class_2487 compound = (class_2487)nbt;
            ElementalApplication application = ElementalApplications.fromNbt(this.owner, (class_2520)compound, syncedAt);
            this.getElementHolder(application.getElement()).setElementalApplication(application);
        }
        this.freezeDecayHandler.readFromNbt(tag.method_10562("FreezeDecay"), this.owner.method_37908().method_8510() - syncedAt);
    }

    public void tick() {
        ElectroChargedElementalReaction.mixin$tick(this.owner);
        AbstractBurningElementalReaction.mixin$tick(this.owner);
        Array<ElementalApplication> appliedElements = this.getAppliedElements();
        int tickedElements = appliedElements.peek(ElementalApplication::tick).length();
        if (tickedElements > 0) {
            this.removeConsumedElements();
        }
        if (this.crystallizeShield != null) {
            this.crystallizeShield.tick(this);
        }
        this.freezeDecayHandler.tick(appliedElements.anyMatch(a -> a.getElement() == Element.FREEZE));
    }

    private void removeConsumedElements() {
        boolean hasRemovedElements = this.elementHolders.values().stream().filter(ElementHolder::hasElementalApplication).anyMatch(ec -> ec.getElementalApplication().isEmpty());
        if (hasRemovedElements) {
            ElementComponent.sync((class_1297)this.owner);
        }
    }

    @Override
    public Optional<Integer> getHighestElementPriority() {
        return this.getAppliedElements().sortElements((a, b) -> a.getElement().getPriority() - b.getElement().getPriority()).findFirst().map(application -> application.getElement().getPriority());
    }

    @Override
    public Array<ElementalApplication> getPrioritizedElements() {
        Optional<Integer> priority = this.getHighestElementPriority();
        return priority.map(integer -> new Array<ElementalApplication>(this.getAppliedElements().filter(application -> !application.isEmpty() && application.getElement().getPriority() == integer.intValue()))).orElseGet(Array::new);
    }

    private Stream<ElementalReaction> getTriggerableReactions(int priority, ElementalApplication triggeringElement) {
        Array<Element> validElements = this.getAppliedElements().filter(application -> application.getElement().getPriority() == priority).map(ElementalApplication::getElement);
        return SevenElementsRegistries.ELEMENTAL_REACTION.method_40270().map(class_6880.class_6883::comp_349).filter(reaction -> reaction.isTriggerable(this.owner) && reaction.hasAnyElement(validElements) && reaction.getHighestElementPriority() == priority).sorted(Comparator.comparing(reaction -> reaction.getPriority(triggeringElement)));
    }

    private boolean attemptReapply(ElementalApplication application) {
        ElementalApplication currentApplication = this.getElementalApplication(application.getElement());
        if (QuickenElementalReaction.mixin$preventReapplication(application, this)) {
            return false;
        }
        if (currentApplication != null && !currentApplication.isEmpty() && application.getElement().canBeAura()) {
            Optional<Integer> priority = this.getHighestElementPriority();
            if (priority.isEmpty() || priority.get().intValue() == currentApplication.getElement().getPriority()) {
                currentApplication.reapply(application);
            } else {
                AbstractBurningElementalReaction.mixin$forceReapplyDendroWhenBurning(this, application);
            }
            return true;
        }
        return false;
    }

    private Set<ElementalReaction> triggerReactions(ElementalApplication application, @Nullable class_1309 origin) {
        boolean hasHigherPriority;
        Optional<Integer> optionalPriority = this.getHighestElementPriority();
        ElementHolder context = this.getElementHolder(application.getElement());
        context.setElementalApplication(application);
        if (optionalPriority.isEmpty()) {
            if (!context.getElement().canBeAura()) {
                context.setElementalApplication(null);
            }
            return Collections.emptySet();
        }
        int priority = Math.min(optionalPriority.get(), application.getElement().getPriority());
        Optional<ElementalReaction> optional = this.getTriggerableReactions(priority, application).filter(reaction -> reaction.hasElement(application.getElement())).findFirst();
        optional = AbstractBurningElementalReaction.mixin$changeReaction(optional, this, application);
        boolean applyElementAsAura = true;
        LinkedHashSet<ElementalReaction> triggeredReactions = new LinkedHashSet<ElementalReaction>();
        while (optional.isPresent() && (application.getCurrentGauge() > 0.0 || optional.get().isTriggerable(this.owner))) {
            ElementalReaction reaction2 = optional.get();
            reaction2.trigger(this.owner, origin);
            applyElementAsAura = applyElementAsAura && reaction2.shouldApplyResultAsAura();
            triggeredReactions.add(reaction2);
            if (reaction2.shouldEndReactionTrigger()) break;
            optional = this.getTriggerableReactions(priority, application).filter(r -> FrozenElementalReaction.mixin$modifySwirlReactions(AbstractBurningElementalReaction.mixin$onlyAllowPyroReactions(triggeredReactions.stream().noneMatch(r2 -> r2.idEquals((ElementalReaction)r)), this, r), this, r)).filter(Predicate.not(reaction2::preventsReaction)).findFirst();
            if (!optional.isEmpty() || reaction2.shouldPreventPriorityUpgrade()) continue;
            int newPriority = this.getHighestElementPriority().orElse(-1);
            if (newPriority == -1 || newPriority >= priority) break;
            priority = newPriority;
            optional = this.getTriggerableReactions(priority, application).filter(r -> FrozenElementalReaction.mixin$modifySwirlReactions(AbstractBurningElementalReaction.mixin$onlyAllowPyroReactions(triggeredReactions.stream().noneMatch(r2 -> r2.idEquals((ElementalReaction)r)), this, r), this, r)).findFirst();
        }
        Optional firstReaction = triggeredReactions.stream().findFirst();
        firstReaction.ifPresent(elementalReaction -> {
            this.lastReaction = new class_3545(elementalReaction, (Object)this.owner.method_37908().method_8510());
        });
        boolean cantBeAura = !context.getElement().canBeAura();
        boolean hasTriggeredReactions = !triggeredReactions.isEmpty();
        boolean isGaugeUnits = application.isGaugeUnits();
        boolean bl = hasHigherPriority = this.getHighestElementPriority().orElse(Integer.MIN_VALUE) < application.getElement().getPriority();
        if (cantBeAura || hasTriggeredReactions && !applyElementAsAura && isGaugeUnits || AbstractBurningElementalReaction.mixin$allowDendroPassthrough(hasHigherPriority, this, application)) {
            context.setElementalApplication(null);
        } else if (isGaugeUnits) {
            context.setElementalApplication(application.asAura());
        }
        return triggeredReactions;
    }

    static {
        ElementComponent.denyElementsFor(class_1531.class);
        ENTITY_TYPE_ELEMENT_MAP.put(SevenElementsEntityTypeTags.DEALS_PYRO_DAMAGE, Element.PYRO);
        ENTITY_TYPE_ELEMENT_MAP.put(SevenElementsEntityTypeTags.DEALS_HYDRO_DAMAGE, Element.HYDRO);
        ENTITY_TYPE_ELEMENT_MAP.put(SevenElementsEntityTypeTags.DEALS_ELECTRO_DAMAGE, Element.ELECTRO);
        ENTITY_TYPE_ELEMENT_MAP.put(SevenElementsEntityTypeTags.DEALS_ANEMO_DAMAGE, Element.ANEMO);
        ENTITY_TYPE_ELEMENT_MAP.put(SevenElementsEntityTypeTags.DEALS_DENDRO_DAMAGE, Element.DENDRO);
        ENTITY_TYPE_ELEMENT_MAP.put(SevenElementsEntityTypeTags.DEALS_CRYO_DAMAGE, Element.CRYO);
        ENTITY_TYPE_ELEMENT_MAP.put(SevenElementsEntityTypeTags.DEALS_GEO_DAMAGE, Element.GEO);
        DAMAGE_TYPE_ELEMENT_MAP.put(SevenElementsDamageTypeTags.HAS_PYRO_INFUSION, Element.PYRO);
        DAMAGE_TYPE_ELEMENT_MAP.put(SevenElementsDamageTypeTags.HAS_HYDRO_INFUSION, Element.HYDRO);
        DAMAGE_TYPE_ELEMENT_MAP.put(SevenElementsDamageTypeTags.HAS_ELECTRO_INFUSION, Element.ELECTRO);
        DAMAGE_TYPE_ELEMENT_MAP.put(SevenElementsDamageTypeTags.HAS_ANEMO_INFUSION, Element.ANEMO);
        DAMAGE_TYPE_ELEMENT_MAP.put(SevenElementsDamageTypeTags.HAS_DENDRO_INFUSION, Element.DENDRO);
        DAMAGE_TYPE_ELEMENT_MAP.put(SevenElementsDamageTypeTags.HAS_CRYO_INFUSION, Element.CRYO);
        DAMAGE_TYPE_ELEMENT_MAP.put(SevenElementsDamageTypeTags.HAS_GEO_INFUSION, Element.GEO);
    }

    private static class CrystallizeShield {
        private final Element element;
        private final long appliedAt;
        private double amount;

        private CrystallizeShield(Element element, double amount, long appliedAt) {
            this.element = element;
            this.appliedAt = appliedAt;
            this.amount = amount;
        }

        private static CrystallizeShield ofNbt(class_2487 tag) {
            return new CrystallizeShield(Element.valueOf(tag.method_10558("Element")), tag.method_10574("Amount"), tag.method_10537("AppliedAt"));
        }

        private float reduce(ElementalDamageSource source, float amount) {
            double elementBonus = this.element == Element.GEO ? 1.5 : (source.getElementalApplication().getElement() == this.element ? 2.5 : 1.0);
            double dmgTakenByShield = Math.min(this.amount * elementBonus, (double)amount);
            this.amount = Math.max(this.amount - dmgTakenByShield / elementBonus, 0.0);
            return (float)dmgTakenByShield;
        }

        private void writeToNbt(class_2487 tag) {
            class_2487 crystallizeShield = new class_2487();
            crystallizeShield.method_10582("Element", this.element.toString());
            crystallizeShield.method_10549("Amount", this.amount);
            crystallizeShield.method_10544("AppliedAt", this.appliedAt);
            tag.method_10566("CrystallizeShield", (class_2520)crystallizeShield);
        }

        private boolean isEmpty() {
            return this.amount <= 0.0 || this.element == null;
        }

        private void tick(ElementComponentImpl impl) {
            if (this.appliedAt + 300L >= impl.owner.method_37908().method_8510() && !this.isEmpty() || impl.crystallizeShield == null) {
                return;
            }
            impl.crystallizeShield = null;
            impl.owner.method_37908().method_8396(null, impl.owner.method_24515(), SevenElementsSoundEvents.CRYSTALLIZE_SHIELD_BREAK, class_3419.field_15248, 1.0f, 1.0f);
            ElementComponent.sync((class_1297)impl.owner);
        }
    }

    private static class FreezeDecayHandler {
        private final ElementComponentImpl impl;
        private boolean isFreezeReapplied = false;
        private long freezeReappliedAt;
        private int freezeTicks;
        private int unfreezeTicks;

        private FreezeDecayHandler(ElementComponentImpl impl) {
            this.impl = impl;
        }

        private double getDecayTimeModifier() {
            return (double)Math.max(0, this.freezeTicks - 2 * this.unfreezeTicks) / 20.0;
        }

        private void tick(boolean hasFreezeAura) {
            if (!this.isFreezeReapplied) {
                return;
            }
            if (hasFreezeAura) {
                ++this.freezeTicks;
            } else {
                ++this.unfreezeTicks;
            }
            if (this.freezeTicks - 2 * this.unfreezeTicks > 0) {
                return;
            }
            this.isFreezeReapplied = false;
            this.freezeReappliedAt = 0L;
            this.freezeTicks = 0;
            this.unfreezeTicks = 0;
            ElementComponent.sync((class_1297)this.impl.owner);
        }

        public void writeToNbt(class_2487 tag) {
            tag.method_10556("FreezeReapplied", this.isFreezeReapplied);
            tag.method_10544("FreezeReappliedAt", this.freezeReappliedAt);
            tag.method_10569("FreezeTicks", this.freezeTicks);
            tag.method_10569("UnfreezeTicks", this.unfreezeTicks);
        }

        public void readFromNbt(class_2487 tag, long syncDiff) {
            this.isFreezeReapplied = tag.method_10577("FreezeReapplied");
            this.freezeReappliedAt = tag.method_10537("FreezeReappliedAt");
            this.freezeTicks = tag.method_10550("FreezeTicks");
            @Nullable ElementalApplication freezeApp = this.impl.getElementalApplication(Element.FREEZE);
            int syncUnfrozenTicks = JavaScriptUtil.nullishCoalesing(ClassInstanceUtil.mapOrNull(freezeApp, ElementalApplication::getRemainingTicks), 0);
            this.unfreezeTicks = tag.method_10550("UnfreezeTicks") + (int)Math.max(0L, syncDiff - (long)syncUnfrozenTicks);
        }

        static {
            ElementEvents.REAPPLIED.register((element, result) -> {
                if (element != Element.FREEZE) {
                    return;
                }
                ElementComponentImpl component = (ElementComponentImpl)ElementComponent.KEY.get((Object)result.getEntity());
                component.freezeDecayHandler.freezeReappliedAt = component.owner.method_37908().method_8510();
                component.freezeDecayHandler.isFreezeReapplied = true;
            });
        }
    }
}

