/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element;

import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.interfaces.DamageSourceWrapper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;

public final class ElementalDamageSource
extends class_1282
implements DamageSourceWrapper {
    @Nullable
    private final class_1282 original;
    private final ElementalApplication application;
    private final InternalCooldownContext icdContext;
    private boolean applyDMGBonus = true;
    private boolean applyRES = true;
    private boolean shouldInfuse = true;

    public ElementalDamageSource(class_1282 source, ElementalApplication application, InternalCooldownContext icdContext) {
        super(source.method_48793(), source.method_5526(), source.method_5529());
        this.original = source;
        this.application = application;
        this.icdContext = icdContext;
    }

    public ElementalDamageSource(class_6880<class_8110> type, @Nullable class_1297 source, @Nullable class_1297 attacker, ElementalApplication application, InternalCooldownContext icdContext) {
        super(type, source, attacker);
        this.original = null;
        this.application = application;
        this.icdContext = icdContext;
    }

    public ElementalDamageSource(class_6880<class_8110> type, class_243 position, ElementalApplication application, InternalCooldownContext icdContext) {
        super(type, position);
        this.original = null;
        this.application = application;
        this.icdContext = icdContext;
    }

    public ElementalDamageSource(class_6880<class_8110> type, @Nullable class_1297 attacker, ElementalApplication application, InternalCooldownContext icdContext) {
        super(type, attacker, attacker);
        this.original = null;
        this.application = application;
        this.icdContext = icdContext;
    }

    public ElementalDamageSource(class_6880<class_8110> type, ElementalApplication application, InternalCooldownContext icdContext) {
        super(type);
        this.original = null;
        this.application = application;
        this.icdContext = icdContext;
    }

    public static ElementalDamageSource of(class_1282 source, @Nullable class_1309 target) {
        return new ElementalDamageSource(source, ElementalApplications.gaugeUnits(target, Element.PHYSICAL, 0.0), InternalCooldownContext.ofNone());
    }

    public ElementalDamageSource shouldApplyDMGBonus(boolean dmgBonus) {
        this.applyDMGBonus = dmgBonus;
        return this;
    }

    public ElementalDamageSource shouldApplyRES(boolean res) {
        this.applyRES = res;
        return this;
    }

    public ElementalDamageSource shouldInfuse(boolean infusion) {
        this.shouldInfuse = infusion;
        return this;
    }

    public ElementalApplication getElementalApplication() {
        return this.application;
    }

    public InternalCooldownContext getIcdContext() {
        return this.icdContext;
    }

    @Override
    @Nullable
    public class_1282 getOriginalSource() {
        return this.original;
    }

    public boolean applyDMGBonus() {
        return this.applyDMGBonus;
    }

    public boolean applyRES() {
        return this.applyRES;
    }

    public boolean shouldInfuse() {
        return this.shouldInfuse;
    }
}

