/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element.reaction;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.annotation.mixin.At;
import io.github.xrickastley.sevenelements.annotation.mixin.Local;
import io.github.xrickastley.sevenelements.annotation.mixin.ModifyExpressionValue;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.effect.ElementalStatusEffect;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementHolder;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReactions;
import io.github.xrickastley.sevenelements.util.TextHelper;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public final class FrozenElementalReaction
extends ElementalReaction {
    FrozenElementalReaction() {
        super(new ElementalReaction.Settings("Frozen", SevenElements.identifier("frozen"), (class_2561)TextHelper.reaction("reaction.seven-elements.frozen", "#b4ffff")).setReactionCoefficient(0.0).setAuraElement(Element.CRYO, 4).setTriggeringElement(Element.HYDRO, 3).reversable(true).preventsReactionsAfter(SevenElements.identifier("shatter_geo"), SevenElements.identifier("shatter_heavy")));
    }

    @Override
    protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double _reducedGauge, @Nullable class_1309 origin) {
        double reducedGauge = auraElement.getElement() == Element.HYDRO ? auraElement.reduceGauge(1.0 * triggeringElement.getCurrentGauge()) : auraElement.reduceGauge(Double.MAX_VALUE * triggeringElement.getCurrentGauge());
        double freezeAuraGauge = 2.0 * triggeringElement.reduceGauge(reducedGauge);
        double freezeTickDuration = this.getFreezeDuration(freezeAuraGauge, entity) * 20.0;
        ElementalApplication application = ElementalApplications.duration(entity, Element.FREEZE, freezeAuraGauge, freezeTickDuration);
        ElementHolder holder = ((ElementComponent)ElementComponent.KEY.get((Object)entity)).getElementHolder(Element.FREEZE);
        if (holder.hasElementalApplication()) {
            holder.getElementalApplication().reapply(application);
        } else {
            holder.setElementalApplication(application);
        }
        ElementalStatusEffect.applyPossibleStatusEffect(application);
    }

    private double getFreezeDuration(double freezeAuraGauge, class_1309 target) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)target);
        boolean reapplied = component.hasElementalApplication(Element.FREEZE);
        if (!reapplied) {
            return 2.0 * Math.sqrt(5.0 * freezeAuraGauge + 4.0) - 4.0;
        }
        double decayTimeModifier = component.getFreezeDecayTimeModifier();
        return Math.sqrt(20.0 * freezeAuraGauge + Math.pow(decayTimeModifier + 4.0, 2.0)) - decayTimeModifier - 4.0;
    }

    @ModifyExpressionValue(method={"Lio/github/xrickastley/sevenelements/component/ElementComponentImpl;triggerReactions(Lio/github/xrickastley/sevenelements/element/ElementalApplication;Lnet/minecraft/entity/LivingEntity;)Ljava/util/Set;"}, at={@At(value="INVOKE", target="Ljava/util/stream/Stream;noneMatch(Ljava/util/function/Predicate;)Z")})
    public static boolean mixin$modifySwirlReactions(boolean original, @Local(self=true) ElementComponent component, @Local ElementalReaction reaction) {
        if (reaction != ElementalReactions.FROZEN_SWIRL || !component.hasElementalApplication(Element.FREEZE) || !component.hasElementalApplication(Element.HYDRO)) {
            return original;
        }
        ElementalApplication hydroApp = component.getElementalApplication(Element.HYDRO);
        ElementalApplication freezeApp = component.getElementalApplication(Element.FREEZE);
        return original && hydroApp.getAppliedAt() < freezeApp.getAppliedAt();
    }
}

