/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.entity;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReactions;
import io.github.xrickastley.sevenelements.entity.SevenElementsEntity;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.networking.SyncDendroCoreAgeS2CPayload;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypes;
import io.github.xrickastley.sevenelements.registry.SevenElementsEntityTypeTags;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.Functions;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public final class DendroCoreEntity
extends SevenElementsEntity {
    private static final double SPRAWLING_SHOT_SPEED = 0.75;
    private static final double SPRAWLING_SHOT_GRAVITY = -0.05;
    private static final double SPRAWLING_SHOT_RADIUS = 24.0;
    private static final int SPRAWLING_SHOT_DELAY = 6;
    private static final double DENDRO_CORES_IN_RADIUS = 64.0;
    private List<UUID> owners;
    @Nullable
    private UUID target;
    private Type type = Type.NORMAL;
    private boolean exploded = false;
    private int hyperbloomAge = 0;
    private int curTicksInHitbox = 0;

    public DendroCoreEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        this(entityType, world, null);
    }

    public DendroCoreEntity(class_1299<? extends class_1309> entityType, class_1937 world, @Nullable class_1309 owner) {
        super(entityType, world);
        this.owners = new ArrayList<UUID>();
        if (owner != null) {
            this.owners.add(owner.method_5667());
        }
    }

    public DendroCoreEntity setOwner(class_1309 owner) {
        this.owners = new ArrayList<UUID>();
        if (owner != null) {
            this.owners.add(owner.method_5667());
        }
        return this;
    }

    public DendroCoreEntity addOwner(class_1309 owner) {
        if (owner != null) {
            this.owners.add(owner.method_5667());
        }
        return this;
    }

    public void setAsHyperbloom() {
        if (this.type != Type.NORMAL) {
            throw new IllegalStateException("This DendroCoreEntity has already been transformed! Type: " + String.valueOf((Object)this.type));
        }
        this.type = Type.HYPERBLOOM;
        this.hyperbloomAge = this.field_6012;
        this.field_5960 = true;
        this.method_5875(true);
        @Nullable class_1309 target = ElementalReaction.getEntitiesInAoE(this, 24.0).stream().filter(e -> !this.owners.contains(e.method_5667()) && !e.method_29504() && !(e instanceof SevenElementsEntity) && !e.method_5864().method_20210(SevenElementsEntityTypeTags.IGNORED_TARGETS)).min(Comparator.comparing(e -> e.method_5858((class_1297)this))).orElse(null);
        if (target == null) {
            return;
        }
        this.target = target.method_5667();
    }

    public void setAsBurgeon() {
        if (this.type != Type.NORMAL) {
            throw new IllegalStateException("This DendroCoreEntity has already been transformed! Type: " + String.valueOf((Object)this.type));
        }
        this.type = Type.BURGEON;
        this.explode(3.0);
    }

    public boolean isNormal() {
        return this.type == Type.NORMAL;
    }

    public boolean isHyperbloom() {
        return this.type == Type.HYPERBLOOM;
    }

    public boolean isBurgeon() {
        return this.type == Type.BURGEON;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Type", this.type.toString());
        if (this.target != null) {
            nbt.method_25927("Target", this.target);
        }
        class_2499 list = new class_2499();
        this.owners.forEach(Functions.consumer(Functions.compose(class_2512::method_25929, arg_0 -> list.add(arg_0))));
        nbt.method_10566("Owners", (class_2520)list);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.type = JavaScriptUtil.nullishCoalesing(nbt.method_10545("Type") ? Type.valueOf(nbt.method_10558("Type")) : null, Type.NORMAL);
        this.target = nbt.method_10545("Target") ? nbt.method_25926("Target") : null;
        this.owners.clear();
        nbt.method_10554("Owners", 9).forEach(Functions.consumer(Functions.compose(class_2512::method_25930, this.owners::add)));
    }

    private void doHyperbloom() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        int hyperbloomTick = this.field_6012 - this.hyperbloomAge;
        class_1309 target = ClassInstanceUtil.castOrNull(world.method_14190(this.target), class_1309.class);
        if (target != null) {
            class_243 targetPos = target.method_33571().method_1020(this.method_19538());
            double distance = Math.sqrt(targetPos.field_1352 * targetPos.field_1352 + targetPos.field_1350 * targetPos.field_1350);
            int ticks = Math.max(1, (int)(distance / 0.75));
            class_243 velocity = new class_243(targetPos.field_1352 / (double)ticks, (targetPos.field_1351 - -0.025 * (double)ticks * (double)ticks) / (double)ticks, targetPos.field_1350 / (double)ticks);
            super.method_18799(velocity);
            class_238 boundingBox = target.method_5829();
            if (!boundingBox.method_1006(this.method_19538())) {
                return;
            }
            ++this.curTicksInHitbox;
            if (this.curTicksInHitbox < 6) {
                return;
            }
            for (class_1297 class_12972 : ElementalReaction.getEntitiesInAoE(target, 1.0, e -> !this.owners.contains(e.method_5667()))) {
                class_12972.method_5643((class_1282)this.createDamageSource(target), ElementalReaction.getReactionDamage((class_1297)this, 3.0));
            }
            this.method_5650(class_1297.class_5529.field_26998);
            this.method_37908().method_8396(null, this.method_24515(), SevenElementsSoundEvents.SPRAWLING_SHOT_HIT, class_3419.field_15248, 0.5f, 1.0f);
        } else {
            super.method_18799(new class_243(0.0, 0.5, 0.0));
            if (hyperbloomTick >= 40) {
                this.method_5650(class_1297.class_5529.field_26998);
            }
        }
    }

    @Override
    public void method_5768() {
        this.explode(2.0);
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (!this.isNormal()) {
            return false;
        }
        ElementalDamageSource eds = ElementComponent.applyElementalInfusions(source, this);
        Element element = eds.getElementalApplication().getElement();
        if (element != Element.PYRO && element != Element.ELECTRO) {
            return false;
        }
        ElementalReaction reaction = element == Element.PYRO ? ElementalReactions.BURGEON : ElementalReactions.HYPERBLOOM;
        reaction.trigger(this, ClassInstanceUtil.castOrNull(source.method_5529(), class_1309.class));
        return true;
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6012 == 1) {
            this.removeOldDendroCores();
        }
        if (this.type == Type.HYPERBLOOM) {
            this.doHyperbloom();
        }
        if (this.field_6012 >= 120 && this.type != Type.HYPERBLOOM) {
            this.explode(2.0);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    private void removeOldDendroCores() {
        class_238 box = class_238.method_30048((class_243)this.method_30950(1.0f), (double)64.0, (double)64.0, (double)64.0);
        List dendroCores = this.method_37908().method_8390(DendroCoreEntity.class, box, dc -> true);
        if (dendroCores.size() <= 5) {
            return;
        }
        dendroCores.sort(Comparator.comparing(SevenElementsEntity::getAge).reversed());
        LinkedList queue = new LinkedList(dendroCores);
        while (queue.peek() != null && queue.size() > 5) {
            ((DendroCoreEntity)((Object)queue.remove())).method_5768();
        }
    }

    private boolean explode(double reactionMultiplier) {
        if (this.exploded) {
            return false;
        }
        this.exploded = true;
        this.field_6012 = 117;
        if (!this.method_37908().field_9236) {
            SyncDendroCoreAgeS2CPayload packet = new SyncDendroCoreAgeS2CPayload(this.method_5628(), this.field_6012);
            for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)this)) {
                ServerPlayNetworking.send((class_3222)otherPlayer, (FabricPacket)packet);
            }
        }
        @Nullable class_1309 recentOwner = this.getRecentOwner();
        for (class_1309 target : ElementalReaction.getEntitiesInAoE(this, 5.0)) {
            if (target instanceof DendroCoreEntity) continue;
            ElementalDamageSource source = this.createDamageSource(target, recentOwner);
            float damage = ElementalReaction.getReactionDamage((class_1297)this, reactionMultiplier);
            if (this.owners.contains(target.method_5667())) {
                damage *= 0.02f;
            }
            target.method_5643((class_1282)source, damage);
        }
        this.method_37908().method_8396(null, this.method_24515(), SevenElementsSoundEvents.DENDRO_CORE_EXPLOSION, class_3419.field_15248, 0.5f, 1.0f);
        return true;
    }

    @Nullable
    private class_1309 getRecentOwner() {
        return !this.owners.isEmpty() && this.method_37908() instanceof class_3218 ? this.getEntityFromUUID(this.owners.get(this.owners.size() - 1)) : null;
    }

    private ElementalDamageSource createDamageSource(class_1309 target) {
        @Nullable class_1309 recentOwner = this.getRecentOwner();
        return this.createDamageSource(target, recentOwner);
    }

    private ElementalDamageSource createDamageSource(class_1309 target, class_1309 recentOwner) {
        return new ElementalDamageSource(this.method_37908().method_48963().method_48797(SevenElementsDamageTypes.DENDRO_CORE, (class_1297)this, (class_1297)recentOwner), ElementalApplications.gaugeUnits(target, Element.DENDRO, 0.0), InternalCooldownContext.ofNone(recentOwner)).shouldApplyDMGBonus(false);
    }

    static {
        ElementComponent.denyElementsFor(DendroCoreEntity.class);
    }

    private static enum Type {
        NORMAL,
        HYPERBLOOM,
        BURGEON;

    }
}

