/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.events;

import io.github.xrickastley.sevenelements.annotation.ExpectedEnvironment;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;

@ExpectedEnvironment(value=EnvType.SERVER)
public final class ElementEvents {
    public static final Event<ElementApplied> APPLIED = EventFactory.createArrayBacked(ElementApplied.class, listeners -> (element, application) -> {
        for (ElementApplied listener : listeners) {
            listener.onElementApplied(element, application);
        }
    });
    public static final Event<ElementReapplied> REAPPLIED = EventFactory.createArrayBacked(ElementReapplied.class, listeners -> (element, result) -> {
        for (ElementReapplied listener : listeners) {
            listener.onElementReapplied(element, result);
        }
    });
    public static final Event<ElementRefreshed> REFRESHED = EventFactory.createArrayBacked(ElementRefreshed.class, listeners -> (element, cur, prev) -> {
        for (ElementRefreshed listener : listeners) {
            listener.onElementRefreshed(element, cur, prev);
        }
    });
    public static final Event<ElementRemoved> REMOVED = EventFactory.createArrayBacked(ElementRemoved.class, listeners -> (element, application) -> {
        for (ElementRemoved listener : listeners) {
            listener.onElementRemoved(element, application);
        }
    });

    @FunctionalInterface
    public static interface ElementRemoved {
        public void onElementRemoved(Element var1, ElementalApplication var2);
    }

    @FunctionalInterface
    public static interface ElementRefreshed {
        public void onElementRefreshed(Element var1, ElementalApplication var2, ElementalApplication var3);
    }

    @FunctionalInterface
    public static interface ElementReapplied {
        public void onElementReapplied(Element var1, ElementalApplication var2);
    }

    @FunctionalInterface
    public static interface ElementApplied {
        public void onElementApplied(Element var1, ElementalApplication var2);
    }
}

