/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class Array<T>
implements List<T> {
    private CopyOnWriteArrayList<T> array = new CopyOnWriteArrayList();

    public Array() {
    }

    public Array(T ... elements) {
        this.array.addAll(Arrays.asList(elements));
    }

    public Array(Iterable<T> iterable) {
        for (T element : iterable) {
            this.array.add(element);
        }
    }

    public Array(Stream<T> stream) {
        stream.forEachOrdered(this.array::add);
    }

    public Array(Iterator<T> iterator) {
        while (iterator.hasNext()) {
            this.array.add(iterator.next());
        }
    }

    public Array(Collection<T> collection) {
        this.array = new CopyOnWriteArrayList<T>(collection);
    }

    public Array(Array<T> array) {
        this.array = new CopyOnWriteArrayList<T>(array.array);
    }

    @Override
    public boolean add(T e) {
        return this.array.add(e);
    }

    @Override
    public void add(int index, T e) {
        this.array.add(index, e);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        return this.array.addAll(c);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c) {
        return this.array.addAll(index, c);
    }

    @Override
    public T set(int index, T element) {
        return this.array.set(index, element);
    }

    @Override
    public int size() {
        return this.length();
    }

    public T at(int index) {
        int newIndex = this.normalizeIndex(index);
        if (newIndex >= this.array.size()) {
            return null;
        }
        return this.array.get(index);
    }

    @Override
    public void clear() {
        this.array.clear();
    }

    public Array<T> concat(T ... items) {
        Array<T> concatArray = new Array<T>(this.array);
        concatArray.array.addAll(Arrays.asList(items));
        return concatArray;
    }

    public Array<T> concat(T[] ... arrays) {
        Array<T> concatArray = new Array<T>(this.array);
        for (T[] array : arrays) {
            concatArray.array.addAll(Arrays.asList(array));
        }
        return concatArray;
    }

    @Override
    public boolean contains(Object object) {
        return this.includes(object);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return new HashSet<T>(this.array).containsAll(c);
    }

    public boolean every(Predicate<? super T> predicate) {
        return this.array.stream().allMatch(predicate);
    }

    public boolean allMatch(Predicate<? super T> predicate) {
        return this.every(predicate);
    }

    public boolean anyMatch(Predicate<T> predicate) {
        return this.array.stream().anyMatch(predicate);
    }

    public Array<T> fill(T value) {
        return this.fill(value, 0, this.length() - 1);
    }

    public Array<T> fill(T value, int start) {
        return this.fill(value, start, this.length() - 1);
    }

    public Array<T> fill(T value, int start, int end) {
        int newStart = start < 0 ? start + this.length() : start;
        int newEnd = end < 0 ? end + this.length() : end;
        for (int i = 0; i < this.array.size(); ++i) {
            if (newStart > i || i >= newEnd) continue;
            this.array.set(i, value);
        }
        return this;
    }

    public Array<T> filter(Predicate<? super T> predicate) {
        Array<T> result = new Array<T>();
        for (T e : this.array) {
            if (!predicate.test(e)) continue;
            result.add(e);
        }
        return result;
    }

    public T find(Predicate<? super T> predicate) {
        for (T element : this.array) {
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }

    public Optional<T> findAsOptional(Predicate<? super T> predicate) {
        return Optional.ofNullable(this.find(predicate));
    }

    public Optional<T> findFirst() {
        return Optional.ofNullable(this.at(0));
    }

    public int findIndex(Predicate<? super T> predicate) {
        return this.findIndexAsOptional(predicate).orElse(-1);
    }

    public Optional<Integer> findIndexAsOptional(Predicate<? super T> predicate) {
        for (int i = 0; i < this.array.size(); ++i) {
            if (!predicate.test(this.array.get(i))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public T findLast(Predicate<? super T> predicate) {
        return this.toReversed().find(predicate);
    }

    public Optional<T> findLastAsOptional(Predicate<? super T> predicate) {
        return this.toReversed().findAsOptional(predicate);
    }

    public int findLastIndex(Predicate<? super T> predicate) {
        return this.toReversed().findIndex(predicate);
    }

    @Override
    public T get(int index) {
        return this.at(index);
    }

    public boolean includes(Object object) {
        return this.array.contains(object);
    }

    @Override
    public int indexOf(Object object) {
        return this.array.indexOf(object);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.array.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    public String join() {
        return this.join(",");
    }

    public String join(String separator) {
        Iterator<T> iterator = this.array.iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.array.lastIndexOf(object);
    }

    public int length() {
        return this.array.size();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.array.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return this.array.listIterator(index);
    }

    @Override
    public T @NotNull [] toArray() {
        return this.array.toArray();
    }

    @Override
    public <U> U @NotNull [] toArray(U @NotNull [] a) {
        return this.array.toArray(a);
    }

    public <R> Array<R> map(Function<? super T, ? extends R> mapper) {
        return new Array<R>(this.array.stream().map(mapper));
    }

    public Array<T> peek(Consumer<? super T> consumer) {
        this.forEach(consumer);
        return this;
    }

    public T pop() {
        return this.array.remove(this.array.size() - 1);
    }

    public int push(T ... elements) {
        this.array.addAll(Arrays.asList(elements));
        return this.array.size();
    }

    public <U> U reduce(BiFunction<U, T, U> accumulator, U initialValue) {
        U value = initialValue;
        for (T element : this.array) {
            value = accumulator.apply(value, element);
        }
        return value;
    }

    public <U> U reduceRight(BiFunction<U, T, U> accumulator, U initialValue) {
        return this.reduce(accumulator, initialValue);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.array.retainAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.array.removeAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return this.array.remove(o);
    }

    @Override
    public T remove(int index) {
        return this.array.remove(index);
    }

    public Array<T> reverse() {
        CopyOnWriteArrayList<T> reverseArray = new CopyOnWriteArrayList<T>();
        for (int i = this.array.size() - 1; i >= 0; --i) {
            reverseArray.add(this.array.get(i));
        }
        this.array = reverseArray;
        return this;
    }

    public T shift() {
        return this.array.remove(0);
    }

    public Array<T> slice() {
        return this.slice(0, this.array.size());
    }

    public Array<T> slice(int start) {
        return this.slice(start, this.array.size());
    }

    public Array<T> slice(int start, int end) {
        int newStart = this.normalizeIndex(start);
        int newEnd = this.normalizeIndex(end);
        return this.filter(element -> newStart <= this.indexOf(element) && this.indexOf(element) < newEnd);
    }

    public boolean some(Predicate<T> predicate) {
        return this.array.stream().anyMatch(predicate);
    }

    public Array<T> sortElements() {
        return this.sortElements((a, b) -> a.toString().compareTo(b.toString()));
    }

    public Array<T> sortElements(BiFunction<T, T, Integer> compareFn) {
        this.array.sort(compareFn::apply);
        return this;
    }

    @Override
    @NotNull
    public Stream<T> stream() {
        return this.array.stream();
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.array.subList(fromIndex, toIndex);
    }

    public Array<T> toReversed() {
        return new Array<T>(this).reverse();
    }

    public Array<T> toSorted(BiFunction<T, T, Integer> compareFn) {
        return new Array<T>(this).sortElements(compareFn);
    }

    private int normalizeIndex(int index) {
        return index < 0 ? index + this.array.size() : index;
    }

    public String toString() {
        return this.array.toString();
    }
}

