/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.util;

import io.github.xrickastley.sevenelements.util.Ease;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Color {
    private final int red;
    private final int green;
    private final int blue;
    private final float alpha;

    public Color(int red, int green, int blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(int red, int green, int blue, float alpha) {
        this.alpha = Math.min(1.0f, Math.max(alpha, 0.0f));
        this.red = Math.min(255, Math.max(red, 0));
        this.green = Math.min(255, Math.max(green, 0));
        this.blue = Math.min(255, Math.max(blue, 0));
    }

    private Color(double red, double green, double blue, double alpha) {
        this((int)red, (int)green, (int)blue, (float)alpha);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getRedAsPercent() {
        return (float)this.red / 255.0f;
    }

    public float getGreenAsPercent() {
        return (float)this.green / 255.0f;
    }

    public float getBlueAsPercent() {
        return (float)this.blue / 255.0f;
    }

    public int getAlphaAsRange() {
        return (int)this.alpha * 255;
    }

    public String asHex() {
        return String.format("#%s%s%s%s", Integer.toHexString(this.red), Integer.toHexString(this.green), Integer.toHexString(this.blue), Integer.toHexString((int)(this.alpha * 255.0f)));
    }

    public int asRGB() {
        int r = this.red & 0xFF;
        int g = this.green & 0xFF;
        int b = this.blue & 0xFF;
        return r << 16 | g << 8 | b;
    }

    public int asARGB() {
        int a = (int)(this.alpha * 255.0f) & 0xFF;
        int r = this.red & 0xFF;
        int g = this.green & 0xFF;
        int b = this.blue & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public Color from() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    public Color add(double factor) {
        return this.add(factor, factor, factor, factor);
    }

    public Color add(double r, double g, double b) {
        return this.add(r, g, b, 1.0);
    }

    public Color add(double r, double g, double b, double a) {
        return new Color((double)this.red + r, (double)this.green + g, (double)this.blue + b, (double)this.alpha + a);
    }

    public Color multiply(double factor) {
        return this.multiply(factor, factor, factor, factor);
    }

    public Color multiply(double r, double g, double b) {
        return this.multiply(r, g, b, 1.0);
    }

    public Color multiply(double r, double g, double b, double a) {
        return new Color((double)this.red * r, (double)this.green * g, (double)this.blue * b, (double)this.alpha * a);
    }

    public String toString() {
        return String.format("%s(r=%d, g=%d, b=%d, a=%f)", this.getClass().getSimpleName(), this.red, this.green, this.blue, Float.valueOf(this.alpha));
    }

    public static Color fromRGBAHex(String rgbaHex) {
        Pattern pattern = Pattern.compile("[a-f0-9]{2}");
        Matcher matcher = pattern.matcher(rgbaHex.strip().replace("#", "").toLowerCase());
        ArrayList<String> hexCodes = new ArrayList<String>();
        while (matcher.find()) {
            hexCodes.add(matcher.group());
        }
        return new Color(Integer.parseInt((String)hexCodes.get(0), 16), Integer.parseInt((String)hexCodes.get(1), 16), Integer.parseInt((String)hexCodes.get(2), 16), hexCodes.size() >= 4 ? (float)Integer.parseInt((String)hexCodes.get(3), 16) / 255.0f : 1.0f);
    }

    public static Color fromARGBHex(int argbHex) {
        int alpha = argbHex >>> 24;
        int red = argbHex >>> 16 & 0xFF;
        int green = argbHex >>> 8 & 0xFF;
        int blue = argbHex & 0xFF;
        float a = (float)alpha / 255.0f;
        return new Color(red, green, blue, a);
    }

    public static List<Color> gradient(Color start, Color end, int steps) {
        return Color.gradient(start, end, steps, Ease.LINEAR);
    }

    public static List<Color> gradient(Color start, Color end, int steps, Ease ease) {
        ArrayList<Color> result = new ArrayList<Color>();
        for (int i = 0; i < steps; ++i) {
            result.add(Color.gradientStep(start, end, (double)i / (double)(steps - 1), ease));
        }
        return result;
    }

    public static Color gradientStep(Color start, Color end, double step) {
        return Color.gradientStep(start, end, step, Ease.LINEAR);
    }

    public static Color gradientStep(Color start, Color end, double step, Ease ease) {
        return new Color(ease.applyLerp(step, start.red, end.red), ease.applyLerp(step, start.green, end.green), ease.applyLerp(step, start.blue, end.blue), ease.applyLerp(step, start.alpha, end.alpha));
    }
}

