/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.util;

import java.util.function.Function;
import net.minecraft.class_3532;

public enum Ease {
    LINEAR(x -> x),
    IN_SINE(x -> 1.0 - Math.cos(x * Math.PI / 2.0)),
    OUT_SINE(x -> Math.sin(x * Math.PI / 2.0)),
    IN_OUT_SINE(x -> -(Math.cos(Math.PI * x) - 1.0) / 2.0),
    IN_QUAD(x -> x * x),
    OUT_QUAD(x -> 1.0 - Math.pow(1.0 - x, 2.0)),
    IN_OUT_QUAD(x -> x < 0.5 ? 2.0 * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 2.0) / 2.0),
    IN_CUBIC(x -> x * x * x),
    OUT_CUBIC(x -> 1.0 - Math.pow(1.0 - x, 3.0)),
    IN_OUT_CUBIC(x -> x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0),
    IN_QUART(x -> x * x * x * x),
    OUT_QUART(x -> 1.0 - Math.pow(1.0 - x, 4.0)),
    IN_OUT_QUART(x -> x < 0.5 ? 8.0 * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 4.0) / 2.0);

    private final Function<Double, Double> easeFunction;

    private Ease(Function<Double, Double> easeFunction) {
        this.easeFunction = easeFunction;
    }

    public double apply(double range) {
        return this.easeFunction.apply(range);
    }

    public double applyLerp(double delta, double start, double end) {
        return class_3532.method_16436((double)this.easeFunction.apply(class_3532.method_15350((double)delta, (double)0.0, (double)1.0)), (double)start, (double)end);
    }

    public double applyLerpProgress(double value, double start, double end) {
        return this.easeFunction.apply(class_3532.method_15350((double)class_3532.method_15370((double)value, (double)start, (double)end), (double)0.0, (double)1.0));
    }
}

