/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.util;

import com.google.common.collect.Sets;
import io.github.xrickastley.sevenelements.mixin.ExplosionAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1900;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class NonEntityDamagingExplosion
extends class_1927 {
    private class_1937 world;
    private double x;
    private double y;
    private double z;
    @Nullable
    private class_1297 entity;
    private float power;
    private class_5362 behavior;
    private ObjectArrayList<class_2338> affectedBlocks;
    private Map<class_1657, class_243> affectedPlayers;
    private List<class_1297> affectedEntities = new ArrayList<class_1297>();

    public NonEntityDamagingExplosion(class_1937 world, @Nullable class_1297 entity, double x, double y, double z, float power, List<class_2338> affectedBlocks) {
        super(world, entity, x, y, z, power, false, class_1927.class_4179.field_40879, affectedBlocks);
        this.supplyFromAccessor();
    }

    public NonEntityDamagingExplosion(class_1937 world, @Nullable class_1297 entity, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType, List<class_2338> affectedBlocks) {
        super(world, entity, x, y, z, power, createFire, destructionType);
        this.supplyFromAccessor();
    }

    public NonEntityDamagingExplosion(class_1937 world, @Nullable class_1297 entity, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType) {
        super(world, entity, null, null, x, y, z, power, createFire, destructionType);
        this.supplyFromAccessor();
    }

    public NonEntityDamagingExplosion(class_1937 world, @Nullable class_1297 entity, @Nullable class_5362 behavior, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType) {
        super(world, entity, null, behavior, x, y, z, power, createFire, destructionType);
        this.supplyFromAccessor();
    }

    public void collectBlocksAndPushEntities() {
        int l;
        int k;
        this.world.method_43275(this.entity, class_5712.field_28178, new class_243(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                block2: for (l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d = (float)j / 15.0f * 2.0f - 1.0f;
                    double e = (float)k / 15.0f * 2.0f - 1.0f;
                    double f = (float)l / 15.0f * 2.0f - 1.0f;
                    double g = Math.sqrt(d * d + e * e + f * f);
                    d /= g;
                    e /= g;
                    f /= g;
                    double m = this.x;
                    double n = this.y;
                    double o = this.z;
                    for (float h = this.power * (0.7f + this.world.field_9229.method_43057() * 0.6f); h > 0.0f; h -= 0.22500001f) {
                        class_2338 blockPos = class_2338.method_49637((double)m, (double)n, (double)o);
                        class_2680 blockState = this.world.method_8320(blockPos);
                        class_3610 fluidState = this.world.method_8316(blockPos);
                        if (!this.world.method_24794(blockPos)) continue block2;
                        Optional optional = this.behavior.method_29555((class_1927)this, (class_1922)this.world, blockPos, blockState, fluidState);
                        if (optional.isPresent()) {
                            h -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (h > 0.0f && this.behavior.method_29554((class_1927)this, (class_1922)this.world, blockPos, blockState, h)) {
                            set.add(blockPos);
                        }
                        m += d * (double)0.3f;
                        n += e * (double)0.3f;
                        o += f * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlocks.addAll((Collection)set);
        float q = this.power * 2.0f;
        k = class_3532.method_15357((double)(this.x - (double)q - 1.0));
        l = class_3532.method_15357((double)(this.x + (double)q + 1.0));
        int r = class_3532.method_15357((double)(this.y - (double)q - 1.0));
        int s = class_3532.method_15357((double)(this.y + (double)q + 1.0));
        int t = class_3532.method_15357((double)(this.z - (double)q - 1.0));
        int u = class_3532.method_15357((double)(this.z + (double)q + 1.0));
        List list = this.world.method_8335(this.entity, new class_238((double)k, (double)r, (double)t, (double)l, (double)s, (double)u));
        class_243 vec3d = new class_243(this.x, this.y, this.z);
        for (class_1297 entity : list) {
            class_1657 playerEntity;
            double d;
            double y;
            double x;
            double v;
            if (entity.method_5659() || (v = Math.sqrt(entity.method_5707(vec3d)) / (double)q) > 1.0) continue;
            double w = entity.method_23317() - this.x;
            double z = Math.sqrt(w * w + (x = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.y) * x + (y = entity.method_23321() - this.z) * y);
            if (z == 0.0) continue;
            w /= z;
            x /= z;
            y /= z;
            double aa = NonEntityDamagingExplosion.method_17752((class_243)vec3d, (class_1297)entity);
            double ab = (1.0 - v) * aa;
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                d = class_1900.method_8237((class_1309)livingEntity, (double)ab);
            } else {
                d = ab;
            }
            double ac = d;
            this.affectedEntities.add(entity);
            class_243 vec3d2 = new class_243(w *= ac, x *= ac, y *= ac);
            entity.method_18799(entity.method_18798().method_1019(vec3d2));
            if (!(entity instanceof class_1657) || (playerEntity = (class_1657)entity).method_7325() || playerEntity.method_7337() && playerEntity.method_31549().field_7479) continue;
            this.affectedPlayers.put(playerEntity, vec3d2);
        }
    }

    public List<class_1297> getAffectedEntities() {
        return this.affectedEntities;
    }

    private void supplyFromAccessor() {
        ExplosionAccessor accessor = (ExplosionAccessor)((Object)this);
        this.world = accessor.getWorld();
        this.x = accessor.getX();
        this.y = accessor.getY();
        this.z = accessor.getZ();
        this.entity = accessor.getEntity();
        this.power = accessor.getPower();
        this.behavior = accessor.getBehavior();
        this.affectedBlocks = accessor.getAffectedBlocks();
        this.affectedPlayers = accessor.getAffectedPlayers();
    }
}

