/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownTag;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.factory.SevenElementsComponents;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9299;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public record ElementalInfusionComponent(@Nullable ElementalApplication.Builder elementalInfusion, @Nullable InternalCooldownContext.Builder internalCooldown) implements class_9299
{
    public static final Codec<ElementalInfusionComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ElementalApplication.Builder.CODEC.fieldOf("elemental_infusion").forGetter(ElementalInfusionComponent::elementalInfusion), (App)InternalCooldownContext.Builder.CODEC.optionalFieldOf("internal_cooldown", (Object)InternalCooldownContext.Builder.ofNone()).forGetter(ElementalInfusionComponent::internalCooldown)).apply((Applicative)instance, ElementalInfusionComponent::new));

    public static Optional<ElementalDamageSource> applyToDamageSource(class_1282 source, class_1297 target) {
        try {
            class_1297 class_12972;
            class_1309 livingTarget;
            block7: {
                block6: {
                    if (!source.method_60489() || !(target instanceof class_1309)) break block6;
                    livingTarget = (class_1309)target;
                    class_12972 = source.method_5529();
                    if (class_12972 instanceof class_1309) break block7;
                }
                return Optional.empty();
            }
            class_1309 attacker = (class_1309)class_12972;
            @Nullable ElementalInfusionComponent component = (ElementalInfusionComponent)attacker.method_59958().method_58694(SevenElementsComponents.ELEMENTAL_INFUSION_COMPONENT);
            if (component == null || !component.hasElementalInfusion()) {
                return Optional.empty();
            }
            return Optional.of(new ElementalDamageSource(source, component.getElementalInfusion(livingTarget), component.internalCooldown().build(attacker)));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static void applyInfusion(class_1799 stack, ElementalApplication.Builder applicationBuilder, InternalCooldownContext.Builder icdBuilder) {
        stack.method_57379(SevenElementsComponents.ELEMENTAL_INFUSION_COMPONENT, (Object)new ElementalInfusionComponent(applicationBuilder, icdBuilder));
    }

    public static boolean removeInfusion(class_1799 stack) {
        if (!ElementalInfusionComponent.hasInfusion(stack)) {
            return false;
        }
        stack.method_57381(SevenElementsComponents.ELEMENTAL_INFUSION_COMPONENT);
        return true;
    }

    public static boolean hasInfusion(class_1799 stack) {
        return JavaScriptUtil.isTruthy(ClassInstanceUtil.mapOrNull((ElementalInfusionComponent)stack.method_58694(SevenElementsComponents.ELEMENTAL_INFUSION_COMPONENT), ElementalInfusionComponent::hasElementalInfusion));
    }

    public static ElementalInfusionComponent ofNone() {
        return new ElementalInfusionComponent(null, null);
    }

    public boolean hasElementalInfusion() {
        return this.elementalInfusion != null;
    }

    @Nullable
    public ElementalApplication getElementalInfusion(class_1309 target) {
        return this.hasElementalInfusion() ? this.elementalInfusion.build(target) : null;
    }

    @Nullable
    public Element getElement() {
        return this.hasElementalInfusion() ? this.elementalInfusion.getElement() : null;
    }

    public double getGaugeUnits() {
        return this.hasElementalInfusion() ? this.elementalInfusion.getGaugeUnits() : 0.0;
    }

    public Optional<ElementalDamageSource> apply(class_1282 source, class_1297 target) {
        class_1309 attacker;
        class_1309 livingTarget;
        block3: {
            block2: {
                if (!(target instanceof class_1309)) break block2;
                livingTarget = (class_1309)target;
                class_1297 class_12972 = source.method_5529();
                if (!(class_12972 instanceof class_1309)) break block2;
                attacker = (class_1309)class_12972;
                if (this.hasElementalInfusion()) break block3;
            }
            return Optional.empty();
        }
        return Optional.of(new ElementalDamageSource(source, this.getElementalInfusion(livingTarget), this.internalCooldown().build(attacker)));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ElementalInfusionComponent)) {
            return false;
        }
        ElementalInfusionComponent component = (ElementalInfusionComponent)obj;
        return Objects.equals(this.elementalInfusion, component.elementalInfusion) && Objects.equals(this.internalCooldown, component.internalCooldown);
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 tooltipType, class_9473 components) {
        if (!tooltipType.method_8035()) {
            return;
        }
        @Nullable ElementalInfusionComponent component = (ElementalInfusionComponent)components.method_58694(SevenElementsComponents.ELEMENTAL_INFUSION_COMPONENT);
        if (component == null || !component.hasElementalInfusion()) {
            return;
        }
        InternalCooldownContext.Builder builder = component.internalCooldown();
        textConsumer.accept((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"item.seven-elements.components.infusion.infusion").method_27692(class_124.field_1068)).method_10852(ElementalApplication.Builder.getText(component.elementalInfusion())));
        @Nullable InternalCooldownTag tag = ClassInstanceUtil.mapOrNull(builder, InternalCooldownContext.Builder::getTag);
        class_5250 tagText = tag != null ? tag.getText(class_124.field_1063) : class_2561.method_43470((String)"none").method_27692(class_124.field_1061);
        textConsumer.accept((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"item.seven-elements.components.infusion.tag").method_27692(class_124.field_1068)).method_10852((class_2561)tagText));
        InternalCooldownType type = JavaScriptUtil.nullishCoalesing(ClassInstanceUtil.mapOrNull(builder, InternalCooldownContext.Builder::getType), InternalCooldownType.DEFAULT);
        textConsumer.accept((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"item.seven-elements.components.infusion.type").method_27692(class_124.field_1068)).method_10852((class_2561)type.getText(true).method_27692(class_124.field_1063)));
    }
}

