/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.entity;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.entity.SevenElementsEntity;
import io.github.xrickastley.sevenelements.entity.SevenElementsEntityTypes;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.registry.SevenElementsEntityTypeTags;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import io.github.xrickastley.sevenelements.util.MathHelper2;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4844;
import net.minecraft.class_7094;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public final class CrystallizeShardEntity
extends SevenElementsEntity {
    public final class_7094 idleAnimationState = new class_7094();
    @Nullable
    private Element element;
    @Nullable
    private UUID owner;

    CrystallizeShardEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        this(entityType, world, null, null);
    }

    public CrystallizeShardEntity(class_1299<? extends class_1309> entityType, class_1937 world, Element element) {
        this(entityType, world, element, null);
    }

    public CrystallizeShardEntity(class_1299<? extends class_1309> entityType, class_1937 world, Element element, @Nullable class_1309 owner) {
        super(entityType, world);
        this.element = this.method_73183().method_8608() ? null : JavaScriptUtil.nullishCoalesing(element, Element.GEO);
        this.owner = ClassInstanceUtil.mapOrNull(owner, class_1297::method_5667);
    }

    public static CrystallizeShardEntity create(class_3218 world, @Nullable class_1309 owner, Element element, class_243 pos, class_3730 reason) {
        return (CrystallizeShardEntity)SevenElementsEntityTypes.CRYSTALLIZE_SHARD.method_5888(world, shard -> {
            shard.element = element;
            shard.owner = ClassInstanceUtil.mapOrNull(owner, class_1297::method_5667);
        }, MathHelper2.asBlockPos(pos), reason, true, false);
    }

    public void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71468("Element", Element.CODEC, (Object)this.element);
        view.method_71477("Owner", class_4844.field_40825, (Object)this.owner);
    }

    public void method_5749(class_11368 view) {
        super.method_5749(view);
        this.element = view.method_71426("Element", Element.CODEC).orElse(this.element);
        this.owner = view.method_71426("Owner", class_4844.field_40825).orElse(this.owner);
    }

    public void method_5773() {
        super.method_5773();
        this.idleAnimationState.method_41324(this.field_6012);
        this.checkCrystallizeShield();
        this.syncToPlayers();
    }

    @Override
    public boolean method_30949(class_1297 other) {
        return other instanceof CrystallizeShardEntity;
    }

    @Nullable
    public Element getElement() {
        return this.element;
    }

    public void syncFromPacket(SyncCrystallizeShardTypeS2CPayload packet) {
        this.element = packet.element;
    }

    public void syncToPlayers() {
        if (!(this.method_73183() instanceof class_3218)) {
            return;
        }
        SyncCrystallizeShardTypeS2CPayload packet = new SyncCrystallizeShardTypeS2CPayload(this.method_5628(), this.element);
        for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)this)) {
            ServerPlayNetworking.send((class_3222)otherPlayer, (class_8710)packet);
        }
    }

    private void checkCrystallizeShield() {
        if (this.method_73183().method_8608()) {
            return;
        }
        List<class_1309> entities = ElementalReaction.getEntitiesInAoE(this, 1.0, e -> !(e instanceof SevenElementsEntity) && !e.method_5864().method_20210(SevenElementsEntityTypeTags.IGNORED_TARGETS));
        @Nullable class_1309 owner = this.getEntityFromUUID(this.owner);
        @Nullable class_1309 target = null;
        if (this.field_6012 > 300) {
            this.method_5650(class_1297.class_5529.field_26998);
        } else if (this.field_6012 <= 150 && entities.contains(owner)) {
            target = owner;
        } else if (this.owner == null || this.field_6012 > 150) {
            target = entities.stream().min(Comparator.comparingDouble(arg_0 -> ((CrystallizeShardEntity)this).method_5739(arg_0))).orElse(null);
        }
        if (target == null) {
            return;
        }
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get(target);
        component.setCrystallizeShield(this.element, SevenElements.getLevelMultiplier((class_1297)this));
        this.method_73183().method_8396(null, this.method_24515(), SevenElementsSoundEvents.CRYSTALLIZE_SHIELD, class_3419.field_15248, 1.0f, 1.0f);
        this.method_5650(class_1297.class_5529.field_26998);
    }

    static {
        ElementComponent.denyElementsFor(CrystallizeShardEntity.class);
    }

    public static class SyncCrystallizeShardTypeS2CPayload
    implements class_8710 {
        public static final class_8710.class_9154<SyncCrystallizeShardTypeS2CPayload> ID = new class_8710.class_9154(SevenElements.identifier("s2c/sync_crystallize_shard_type"));
        public static final class_9139<class_9129, SyncCrystallizeShardTypeS2CPayload> CODEC = class_9139.method_56435((class_9139)class_9135.field_49675, SyncCrystallizeShardTypeS2CPayload::entityId, (class_9139)class_9135.method_56368(Element.CODEC), inst -> inst.element, SyncCrystallizeShardTypeS2CPayload::new);
        private final int entityId;
        private final Element element;

        private SyncCrystallizeShardTypeS2CPayload(int entityId, Element element) {
            this.entityId = entityId;
            this.element = element;
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }

        public int entityId() {
            return this.entityId;
        }
    }
}

