/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements;

import io.github.xrickastley.sevenelements.entity.SevenElementsEntityTypes;
import io.github.xrickastley.sevenelements.gui.screen.ingame.ElementalInfusionScreen;
import io.github.xrickastley.sevenelements.networking.SevenElementsPacketsS2C;
import io.github.xrickastley.sevenelements.networking.SyncBossBarEntityPayloadHandler;
import io.github.xrickastley.sevenelements.particle.SevenElementsClientParticleFactory;
import io.github.xrickastley.sevenelements.renderer.WorldTextRenderer;
import io.github.xrickastley.sevenelements.renderer.entity.CrystallizeShardEntityRenderer;
import io.github.xrickastley.sevenelements.renderer.entity.DendroCoreEntityRenderer;
import io.github.xrickastley.sevenelements.renderer.entity.model.CrystallizeShardEntityModel;
import io.github.xrickastley.sevenelements.renderer.entity.model.DendroCoreEntityModel;
import io.github.xrickastley.sevenelements.renderer.genshin.SpecialEffectsRenderer;
import io.github.xrickastley.sevenelements.screen.SevenElementsScreenHandlers;
import io.github.xrickastley.sevenelements.util.ClientConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_3929;
import net.minecraft.class_5601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class SevenElementsClient
implements ClientModInitializer {
    public static final String MOD_ID = "seven-elements";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"seven-elements");
    private static final SpecialEffectsRenderer SPECIAL_EFFECTS_RENDERER = new SpecialEffectsRenderer();
    public static final WorldTextRenderer WORLD_TEXT_RENDERER = new WorldTextRenderer();
    public static final SyncBossBarEntityPayloadHandler SYNC_BOSS_BAR_ENTITY_HANDLER = new SyncBossBarEntityPayloadHandler();

    public void onInitializeClient() {
        LOGGER.info("Seven Elements (Client) Initialized!");
        SevenElementsPacketsS2C.registerHandler(SPECIAL_EFFECTS_RENDERER);
        SevenElementsPacketsS2C.registerHandler(SYNC_BOSS_BAR_ENTITY_HANDLER);
        WorldRenderEvents.END.register(SPECIAL_EFFECTS_RENDERER::render);
        ClientTickEvents.START_WORLD_TICK.register(SPECIAL_EFFECTS_RENDERER::tick);
        WorldRenderEvents.END.register(WORLD_TEXT_RENDERER::render);
        ClientTickEvents.START_WORLD_TICK.register(WORLD_TEXT_RENDERER::tick);
        EntityRendererRegistry.register(SevenElementsEntityTypes.DENDRO_CORE, DendroCoreEntityRenderer::new);
        EntityRendererRegistry.register(SevenElementsEntityTypes.CRYSTALLIZE_SHARD, CrystallizeShardEntityRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)DendroCoreEntityModel.MODEL_LAYER, DendroCoreEntityModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)CrystallizeShardEntityModel.MODEL_LAYER, CrystallizeShardEntityModel::getTexturedModelData);
        SevenElementsPacketsS2C.register();
        SevenElementsClientParticleFactory.register();
        AutoConfig.register(ClientConfig.class, GsonConfigSerializer::new);
        class_3929.method_17542(SevenElementsScreenHandlers.ELEMENTAL_INFUSION_SCREEN_HANDLER, ElementalInfusionScreen::new);
    }
}

