/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.xrickastley.sevenelements.element.DurationElementalApplication;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.GaugeUnitElementalApplication;
import io.github.xrickastley.sevenelements.element.reaction.AbstractBurningElementalReaction;
import io.github.xrickastley.sevenelements.exception.ElementalApplicationOperationException;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import io.github.xrickastley.sevenelements.util.TextHelper;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public abstract sealed class ElementalApplication
permits DurationElementalApplication, GaugeUnitElementalApplication {
    protected static final DecimalFormat GAUGE_UNIT_FORMAT = new DecimalFormat("0.0");
    protected static final DecimalFormat DURATION_FORMAT = new DecimalFormat("0.00");
    protected final Type type;
    protected final Element element;
    protected final class_1309 entity;
    protected final boolean isAura;
    protected final UUID uuid;
    protected double gaugeUnits;
    protected double currentGauge;
    protected long appliedAt;

    ElementalApplication(Type type, class_1309 entity, Element element, UUID uuid, double gaugeUnits, boolean isAura) {
        this.type = type;
        this.entity = entity;
        this.element = element;
        this.isAura = isAura;
        this.uuid = uuid;
        this.gaugeUnits = gaugeUnits;
        this.currentGauge = gaugeUnits;
        this.appliedAt = entity.method_37908().method_8510();
    }

    public Type getType() {
        return this.type;
    }

    public Element getElement() {
        return this.element;
    }

    public class_1309 getEntity() {
        return this.entity;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public double getGaugeUnits() {
        return this.gaugeUnits;
    }

    public double getCurrentGauge() {
        return this.currentGauge;
    }

    public long getAppliedAt() {
        return this.appliedAt;
    }

    public long getAppliedTicks() {
        return this.entity.method_37908().method_8510() - this.appliedAt;
    }

    protected abstract double getDefaultDecayRate();

    public abstract int getRemainingTicks();

    public class_2561 getText() {
        return this.getText(GAUGE_UNIT_FORMAT, DURATION_FORMAT);
    }

    public class_2561 getText(@Nullable String gaugeFormat) {
        return this.getText(ClassInstanceUtil.mapOrNull(gaugeFormat, DecimalFormat::new), DURATION_FORMAT);
    }

    public class_2561 getText(@Nullable DecimalFormat gaugeFormat) {
        return this.getText(gaugeFormat, DURATION_FORMAT);
    }

    public class_2561 getText(@Nullable String gaugeFormat, @Nullable String durationFormat) {
        return this.getText(ClassInstanceUtil.mapOrNull(gaugeFormat, DecimalFormat::new), ClassInstanceUtil.mapOrNull(durationFormat, DecimalFormat::new));
    }

    public abstract class_2561 getText(@Nullable DecimalFormat var1, @Nullable DecimalFormat var2);

    public boolean isGaugeUnits() {
        return this.type == Type.GAUGE_UNIT;
    }

    public boolean isDuration() {
        return this.type == Type.DURATION;
    }

    public boolean isOfElement(Element element) {
        return this.element == element;
    }

    public boolean isAuraElement() {
        return this.isAura;
    }

    public abstract boolean isEmpty();

    public double reduceGauge(double gaugeUnits) {
        double previousValue = this.currentGauge;
        this.currentGauge = Math.max(this.currentGauge - gaugeUnits, 0.0);
        this.element.reduceLinkedElements(previousValue - this.currentGauge, this, false);
        return previousValue - this.currentGauge;
    }

    public void tick() {
        AbstractBurningElementalReaction.mixin$reduceQuickenGauge(this);
    }

    public void reapply(Element element, double gaugeUnits) {
        this.reapply(ElementalApplications.gaugeUnits(this.entity, element, gaugeUnits));
    }

    public abstract void reapply(ElementalApplication var1);

    public abstract ElementalApplication asAura();

    public abstract ElementalApplication asNonAura();

    public class_2487 asNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("Type", this.type.toString());
        nbt.method_10582("Element", this.element.toString());
        nbt.method_25927("UUID", this.uuid);
        nbt.method_10556("IsAura", this.isAura);
        nbt.method_10549("GaugeUnits", this.gaugeUnits);
        nbt.method_10549("CurrentGauge", this.currentGauge);
        nbt.method_10544("AppliedAt", this.appliedAt);
        return nbt;
    }

    public void updateFromNbt(class_2520 nbt, long syncedAt) {
        if (!(nbt instanceof class_2487)) {
            throw new ElementalApplicationOperationException(ElementalApplicationOperationException.Operation.INVALID_NBT_DATA, null, null);
        }
        class_2487 compound = (class_2487)nbt;
        ElementalApplication application = ElementalApplications.fromNbt(this.entity, (class_2520)compound, syncedAt);
        if (!application.uuid.equals(this.uuid)) {
            throw new ElementalApplicationOperationException(ElementalApplicationOperationException.Operation.INVALID_UUID_VALUES, this, application);
        }
        if (application.type != this.type) {
            throw new ElementalApplicationOperationException(ElementalApplicationOperationException.Operation.REAPPLICATION_INVALID_TYPES, this, application);
        }
        if (application.element != this.element) {
            throw new ElementalApplicationOperationException(ElementalApplicationOperationException.Operation.REAPPLICATION_INVALID_ELEMENT, this, application);
        }
        this.currentGauge = application.currentGauge;
        this.gaugeUnits = application.gaugeUnits;
        this.appliedAt = application.appliedAt;
    }

    public static enum Type {
        GAUGE_UNIT,
        DURATION;

        public static final Codec<Type> CODEC;

        static {
            CODEC = class_5699.field_41759.xmap(Type::valueOf, Enum::toString);
        }
    }

    public static final class Builder {
        public static final Codec<Builder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.optionalFieldOf("type", (Object)Type.GAUGE_UNIT).forGetter(i -> i.type), (App)Element.CODEC.fieldOf("element").forGetter(i -> i.element), (App)Codec.BOOL.optionalFieldOf("aura", (Object)true).forGetter(i -> i.isAura), (App)Codec.DOUBLE.fieldOf("gauge_units").forGetter(i -> i.gaugeUnits), (App)Codec.DOUBLE.optionalFieldOf("duration", (Object)-1.0).forGetter(i -> i.duration)).apply((Applicative)instance, Builder::new));
        private Type type;
        private Element element;
        private boolean isAura;
        private double gaugeUnits;
        private double duration;

        Builder() {
            this.isAura = true;
        }

        public static class_2561 getText(Builder builder) {
            return Builder.getText(builder, GAUGE_UNIT_FORMAT, DURATION_FORMAT);
        }

        public static class_2561 getText(Builder builder, @Nullable String gaugeFormat) {
            return Builder.getText(builder, ClassInstanceUtil.mapOrNull(gaugeFormat, DecimalFormat::new), DURATION_FORMAT);
        }

        public static class_2561 getText(Builder builder, @Nullable DecimalFormat gaugeFormat) {
            return Builder.getText(builder, gaugeFormat, DURATION_FORMAT);
        }

        public static class_2561 getText(Builder builder, @Nullable String gaugeFormat, @Nullable String durationFormat) {
            return Builder.getText(builder, ClassInstanceUtil.mapOrNull(gaugeFormat, DecimalFormat::new), ClassInstanceUtil.mapOrNull(durationFormat, DecimalFormat::new));
        }

        public static class_2561 getText(Builder builder, @Nullable DecimalFormat gaugeFormat, @Nullable DecimalFormat durationFormat) {
            gaugeFormat = JavaScriptUtil.nullishCoalesing(gaugeFormat, GAUGE_UNIT_FORMAT);
            durationFormat = JavaScriptUtil.nullishCoalesing(durationFormat, DURATION_FORMAT);
            return TextHelper.color(builder.type == Type.GAUGE_UNIT ? class_2561.method_43469((String)"formats.seven-elements.elemental_application.gauge_unit", (Object[])new Object[]{gaugeFormat.format(builder.gaugeUnits), builder.element.getString()}) : class_2561.method_43469((String)"formats.seven-elements.elemental_application.duration", (Object[])new Object[]{gaugeFormat.format(builder.gaugeUnits), builder.element.getString(), durationFormat.format(builder.duration / 20.0)}), builder.element.getDamageColor());
        }

        private Builder(Type type, Element element, boolean isAura, double gaugeUnits, double duration) {
            this.type = type;
            this.element = element;
            this.isAura = isAura;
            this.gaugeUnits = gaugeUnits;
            this.duration = duration;
        }

        public Element getElement() {
            return this.element;
        }

        public double getGaugeUnits() {
            return this.gaugeUnits;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setElement(Element element) {
            this.element = element;
            return this;
        }

        public Builder setAsAura(boolean isAura) {
            this.isAura = isAura;
            return this;
        }

        public Builder setGaugeUnits(double gaugeUnits) {
            this.gaugeUnits = gaugeUnits;
            return this;
        }

        public Builder setDuration(double duration) {
            this.duration = duration;
            return this;
        }

        public ElementalApplication build(class_1309 entity) {
            Objects.requireNonNull(this.type);
            Objects.requireNonNull(this.element);
            if (this.type == Type.DURATION) {
                return ElementalApplications.duration(entity, this.element, this.gaugeUnits, this.duration);
            }
            return ElementalApplications.gaugeUnits(entity, this.element, this.gaugeUnits, this.isAura);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)obj;
            return this.type == builder.type && this.element == builder.element && this.isAura == builder.isAura && this.gaugeUnits == builder.gaugeUnits && this.duration == builder.duration;
        }
    }
}

