/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.entity.DendroCoreEntity;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.interfaces.DamageSourceWrapper;
import io.github.xrickastley.sevenelements.interfaces.IPlayerEntity;
import io.github.xrickastley.sevenelements.networking.ShowElementalDamageS2CPayload;
import io.github.xrickastley.sevenelements.util.BoxUtil;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements IPlayerEntity {
    @Unique
    private float sevenelements$subdamage;
    @Unique
    private Set<class_1282> sevenelements$critDamageSources = new HashSet<class_1282>();

    public PlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(class_1299.field_6097, world);
        throw new AssertionError();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Unique
    public boolean sevenelements$isCrit(class_1282 source) {
        if (this.sevenelements$critDamageSources == null) return false;
        if (!DamageSourceWrapper.getDamageSources(source).anyMatch(this.sevenelements$critDamageSources::contains)) return false;
        return true;
    }

    @ModifyVariable(method={"applyDamage"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/player/PlayerEntity;modifyAppliedDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"), ordinal=0, argsOnly=true)
    private float applyCrystallizeShield(float amount, @Local(argsOnly=true) class_1282 source) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)this);
        float finalAmount = amount - component.reduceCrystallizeShield(source, amount);
        if (finalAmount < amount) {
            this.method_37908().method_8396(null, this.method_24515(), SevenElementsSoundEvents.CRYSTALLIZE_SHIELD_HIT, class_3419.field_15248, 1.0f, 1.0f);
        }
        if (finalAmount <= 0.0f) {
            this.sevenelements$setBlockedByCrystallizeShield(true);
        }
        return finalAmount;
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="k", local={@Local(type=float.class, ordinal=5)})
    @Expression(value={"k > 0.0"})
    private boolean preventKnockbackIfCrystallize(boolean original, @Local(argsOnly=true) class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return original;
        }
        class_1309 livingEntity = (class_1309)entity;
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)livingEntity);
        return original && !component.reducedCrystallizeShield();
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;sidedDamage(Lnet/minecraft/entity/damage/DamageSource;F)Z"), index=0)
    private class_1282 checkForCritMain(class_1282 source, @Local(ordinal=2) boolean crit) {
        if (this.sevenelements$critDamageSources == null) {
            this.sevenelements$critDamageSources = new HashSet<class_1282>();
        }
        if (crit) {
            this.sevenelements$critDamageSources.add(source);
        }
        return source;
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;serverDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"), index=0)
    private class_1282 checkForCritSweep(class_1282 source, @Local(ordinal=2) boolean crit) {
        if (this.sevenelements$critDamageSources == null) {
            this.sevenelements$critDamageSources = new HashSet<class_1282>();
        }
        if (crit) {
            this.sevenelements$critDamageSources.add(source);
        }
        return source;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void removeCritDS(CallbackInfo ci) {
        if (this.sevenelements$critDamageSources != null) {
            this.sevenelements$critDamageSources.clear();
        } else {
            this.sevenelements$critDamageSources = new HashSet<class_1282>();
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="TAIL")})
    private void elementDamageHandler(class_3218 world, class_1282 source, float amount, CallbackInfo ci) {
        class_1657 player;
        ElementalDamageSource eds2;
        this.sevenelements$triggerDendroCoreReactions(world, source);
        if (!source.sevenelements$displayDamage()) {
            return;
        }
        ElementalDamageSource eds = source instanceof ElementalDamageSource ? (eds2 = (ElementalDamageSource)source) : new ElementalDamageSource(source, ElementalApplications.gaugeUnits(this, Element.PHYSICAL, 0.0), InternalCooldownContext.ofNone(source.method_5529()));
        this.sevenelements$subdamage += amount;
        if (this.sevenelements$subdamage < 1.0f) {
            return;
        }
        float extra = this.sevenelements$subdamage - (float)Math.floor(this.sevenelements$subdamage);
        this.sevenelements$subdamage = (float)Math.floor(this.sevenelements$subdamage);
        class_238 boundingBox = this.method_5829();
        double x = this.method_23317() + boundingBox.method_17939() * 1.25 * Math.random();
        double y = this.method_23318() + boundingBox.method_17940() * 0.5 * Math.random() + 0.5;
        double z = this.method_23321() + boundingBox.method_17941() * 1.25 * Math.random();
        class_243 pos = new class_243(x, y, z);
        class_1297 class_12972 = source.method_5529();
        boolean isCrit = class_12972 instanceof class_1657 && ((IPlayerEntity)(player = (class_1657)class_12972)).sevenelements$isCrit(eds);
        Element element = eds.getElementalApplication().getElement();
        ShowElementalDamageS2CPayload showElementalDMGPacket = new ShowElementalDamageS2CPayload(pos, element, this.sevenelements$subdamage, isCrit);
        this.sevenelements$subdamage = extra;
        for (class_3222 player2 : PlayerLookup.tracking((class_1297)this)) {
            if (player2.method_5628() == this.method_5628()) {
                return;
            }
            ServerPlayNetworking.send((class_3222)player2, (class_8710)showElementalDMGPacket);
        }
    }

    @Unique
    private void sevenelements$triggerDendroCoreReactions(class_3218 world, class_1282 source) {
        if (!(source instanceof ElementalDamageSource)) {
            return;
        }
        ElementalDamageSource eds = (ElementalDamageSource)source;
        Element element = eds.getElementalApplication().getElement();
        if (element != Element.PYRO && element != Element.ELECTRO) {
            return;
        }
        this.method_37908().method_8390(DendroCoreEntity.class, BoxUtil.multiplyBox(this.method_5829(), 2.0), dc -> true).forEach(dc -> dc.method_64397(world, source, 1.0f));
    }
}

