/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.component.ElementComponentImpl;
import io.github.xrickastley.sevenelements.effect.ElementalStatusEffect;
import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.reaction.AdditiveElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.AmplifyingElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReactions;
import io.github.xrickastley.sevenelements.factory.SevenElementsAttributes;
import io.github.xrickastley.sevenelements.interfaces.ILivingEntity;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.FilteredIterator;
import io.github.xrickastley.sevenelements.util.Functions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3545;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class}, priority=2147482647)
public abstract class PrioritizedLivingEntityMixin
extends class_1297
implements ILivingEntity {
    @Shadow
    protected float field_6253;
    @Shadow
    @Final
    private Map<class_1291, class_1293> field_6280;
    @Unique
    private List<ElementalReaction> sevenelements$reactions = new ArrayList<ElementalReaction>();
    @Unique
    @Nullable
    private class_1297 sevenelements$plannedAttacker;
    @Unique
    @Nullable
    private class_1282 sevenelements$plannedDamageSource;

    @Shadow
    protected abstract void method_6129(class_1293 var1);

    @Shadow
    public abstract boolean method_29504();

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    @Shadow
    public abstract boolean method_6016(class_1291 var1);

    public PrioritizedLivingEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
        throw new AssertionError();
    }

    @Override
    @Unique
    @Nullable
    public class_1297 sevenelements$getPlannedAttacker() {
        return this.sevenelements$plannedAttacker;
    }

    @Override
    @Unique
    @Nullable
    public class_1282 sevenelements$getPlannedDamageSource() {
        return this.sevenelements$plannedDamageSource;
    }

    @Inject(method={"canHaveStatusEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void forceElementEffects(class_1293 effect, CallbackInfoReturnable<Boolean> cir) {
        if (ElementalStatusEffect.isElementalEffect(effect.method_5579())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"removeStatusEffectInternal"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventElementEffectRemoval(class_1291 effect, CallbackInfoReturnable<class_1293> cir) {
        if (this.method_29504() || !ElementalStatusEffect.isElementalEffect(effect)) {
            return;
        }
        ElementalStatusEffect elementEffect = (ElementalStatusEffect)effect;
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)this);
        if (component.hasElementalApplication(elementEffect.getElement())) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setPose(Lnet/minecraft/entity/EntityPose;)V")})
    private void removeForcedEffectsOnDeath(class_1282 damageSource, CallbackInfo ci) {
        ElementalStatusEffect.getElementEffects().forEach(this::method_6016);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void removeExpiredElementEffects(CallbackInfo ci) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)this);
        ElementalStatusEffect.getElementEffects().stream().filter(this::method_6059).filter(Predicate.not(Functions.composePredicate(ElementalStatusEffect::getElement, component::hasElementalApplication))).forEach(this::method_6016);
    }

    @ModifyVariable(method={"clearStatusEffects"}, at=@At(value="STORE"), ordinal=0)
    private Iterator<class_1293> persistElementEffectsOnClear(Iterator<class_1293> value) {
        if (this.method_29504()) {
            return value;
        }
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)this);
        return FilteredIterator.of(value, v -> ElementalStatusEffect.asElementEffect(v.method_5579()).map(Functions.compose(ElementalStatusEffect::getElement, component::hasElementalApplication, b -> b == false)).orElse(false));
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void setPlannedAttacker(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.sevenelements$plannedAttacker = source.method_5529();
        this.sevenelements$plannedDamageSource = source;
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventDamageWhenFrozen(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 entity;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309 && (entity = (class_1309)class_12972).method_6059(SevenElementsStatusEffects.FROZEN)) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1282 applyElementalInfusions(class_1282 source) {
        return ElementComponent.applyElementalInfusions(source, (class_1309)this);
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    private float applyDMGModifiers(float amount, @Local(argsOnly=true) class_1282 source) {
        boolean doShatter;
        ElementalDamageSource eds2;
        boolean damageCooldown;
        boolean fireResistance = source.method_48789(class_8103.field_42246) && this.method_6059(class_1294.field_5918);
        boolean bl = damageCooldown = (float)this.field_6008 > 10.0f && !source.method_48789(class_8103.field_42969) && amount <= this.field_6253;
        if (this.method_5679(source) || this.method_37908().field_9236 || this.method_29504() || fireResistance || damageCooldown) {
            return amount;
        }
        ElementalDamageSource eds = source instanceof ElementalDamageSource ? (eds2 = (ElementalDamageSource)source) : new ElementalDamageSource(source, ElementalApplications.gaugeUnits((class_1309)this, Element.PHYSICAL, 0.0), InternalCooldownContext.ofNone(source.method_5529()));
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)this);
        this.sevenelements$reactions = new ArrayList<ElementalReaction>(component.applyFromDamageSource(eds));
        @Nullable ElementalReaction lastReaction = this.sevenelements$reactions.isEmpty() ? null : this.sevenelements$reactions.get(this.sevenelements$reactions.size() - 1);
        boolean bl2 = doShatter = !this.sevenelements$reactions.contains(ElementalReactions.GEO_SHATTER) && !this.sevenelements$reactions.contains(ElementalReactions.SHATTER) && ElementalReactions.SHATTER.isTriggerable(this) && (lastReaction == null || !lastReaction.preventsReaction(ElementalReactions.SHATTER));
        if (doShatter) {
            this.sevenelements$reactions.add(ElementalReactions.SHATTER);
            ((ElementComponentImpl)component).setLastReaction((class_3545<ElementalReaction, Long>)new class_3545((Object)ElementalReactions.SHATTER, (Object)this.method_37908().method_8510()));
            ElementalReactions.SHATTER.trigger((class_1309)this, ClassInstanceUtil.castOrNull(source.method_5529(), class_1309.class));
        }
        float additive = this.sevenelements$reactions != null && !this.sevenelements$reactions.isEmpty() ? Math.max(this.sevenelements$reactions.stream().filter(reaction -> reaction instanceof AdditiveElementalReaction).map(reaction -> (AdditiveElementalReaction)reaction).reduce(Float.valueOf(0.0f), (acc, reaction) -> Float.valueOf(acc.floatValue() + (float)reaction.getDamageBonus(this.method_37908())), Float::sum).floatValue(), 0.0f) : 0.0f;
        return SevenElementsAttributes.modifyDamage((class_1309)this, eds, amount + additive);
    }

    @ModifyVariable(method={"modifyAppliedDamage"}, at=@At(value="TAIL", shift=At.Shift.BEFORE), argsOnly=true)
    private float applyReactionAmplifiers(float amount, @Local(argsOnly=true) class_1282 source) {
        double amplifier = this.sevenelements$reactions != null && !this.sevenelements$reactions.isEmpty() ? Math.max(this.sevenelements$reactions.stream().filter(reaction -> reaction instanceof AmplifyingElementalReaction).map(reaction -> (AmplifyingElementalReaction)reaction).reduce(0.0, (acc, reaction) -> acc + reaction.getAmplifier(), Double::sum), 1.0) : 1.0;
        return amount * (float)amplifier;
    }
}

