/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element.reaction;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.annotation.mixin.At;
import io.github.xrickastley.sevenelements.annotation.mixin.Inject;
import io.github.xrickastley.sevenelements.annotation.mixin.Local;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReactions;
import io.github.xrickastley.sevenelements.networking.ShowElectroChargeS2CPayload;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypes;
import io.github.xrickastley.sevenelements.util.TextHelper;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class ElectroChargedElementalReaction
extends ElementalReaction {
    ElectroChargedElementalReaction() {
        super(new ElementalReaction.Settings("Electro-Charged", SevenElements.identifier("electro-charged"), (class_2561)TextHelper.reaction("reaction.seven-elements.electro-charged", "#d691fc")).setReactionCoefficient(0.0).setAuraElement(Element.ELECTRO, 5).setTriggeringElement(Element.HYDRO, 6).applyResultAsAura(true).reversable(true));
    }

    @Override
    public boolean isTriggerable(class_1309 entity) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)entity);
        ElementalApplication applicationAE = component.getElementalApplication((Element)((Object)this.auraElement.method_15442()));
        ElementalApplication applicationTE = component.getElementalApplication((Element)((Object)this.triggeringElement.method_15442()));
        return applicationAE != null && !applicationAE.isEmpty() && applicationTE != null && !applicationTE.isEmpty() && !component.isElectroChargedOnCD() && !component.hasElementalApplication(Element.FREEZE);
    }

    @Override
    public boolean trigger(class_1309 entity, @Nullable class_1309 origin) {
        if (!this.isTriggerable(entity) || entity.method_37908().field_9236) {
            return false;
        }
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)entity);
        ElementalApplication auraElement = component.getElementalApplication((Element)((Object)this.auraElement.method_15442()));
        ElementalApplication triggeringElement = component.getElementalApplication((Element)((Object)this.triggeringElement.method_15442()));
        double reducedGauge = auraElement.reduceGauge(0.4);
        triggeringElement.reduceGauge(reducedGauge);
        this.onTrigger(entity, auraElement, triggeringElement, reducedGauge, origin);
        return true;
    }

    @Override
    protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
        ElementComponent entityComponent = (ElementComponent)ElementComponent.KEY.get((Object)entity);
        entityComponent.setOrRetainElectroChargedOrigin(origin);
        Predicate<class_1309> predicate = e -> {
            ElementComponent c = (ElementComponent)ElementComponent.KEY.get(e);
            return (e == entity || c.hasElementalApplication(Element.HYDRO)) && !c.isElectroChargedOnCD();
        };
        List<class_1309> targets = ElementalReaction.getEntitiesInAoE(entity, 2.5, predicate);
        for (class_1309 target : targets) {
            float damage = ElementalReaction.getReactionDamage((class_1297)entity, 2.0);
            ElementalDamageSource source = new ElementalDamageSource(entity.method_48923().method_48797(SevenElementsDamageTypes.ELECTRO_CHARGED, (class_1297)entity, (class_1297)origin), ElementalApplications.gaugeUnits(target, Element.ELECTRO, 0.0), InternalCooldownContext.ofNone(origin)).shouldApplyDMGBonus(false);
            target.method_5643((class_1282)source, damage);
            ((ElementComponent)ElementComponent.KEY.get((Object)target)).resetElectroChargedCD();
        }
        this.sendDisplayPacket(entity, targets);
    }

    private void sendDisplayPacket(class_1309 mainTarget, List<class_1309> otherTargets) {
        if (otherTargets.isEmpty()) {
            return;
        }
        ShowElectroChargeS2CPayload packet = new ShowElectroChargeS2CPayload(mainTarget, otherTargets);
        if (mainTarget instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)mainTarget;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)packet);
        }
        for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)mainTarget)) {
            if (otherPlayer.method_5628() == mainTarget.method_5628()) continue;
            ServerPlayNetworking.send((class_3222)otherPlayer, (class_8710)packet);
        }
    }

    @Inject(method={"Lio/github/xrickastley/sevenelements/component/ElementComponentImpl;tick()V"}, at={@At(value="HEAD")})
    public static void mixin$tick(@Local(field="owner:Lnet/minecraft/entity/LivingEntity;") class_1309 entity) {
        if (!ElementalReactions.ELECTRO_CHARGED.isTriggerable(entity) || entity.method_37908().field_9236 || entity.method_29504()) {
            return;
        }
        ElementalReactions.ELECTRO_CHARGED.trigger(entity);
        ElementComponent.sync((class_1297)entity);
    }
}

