/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.component.FrozenEffectComponent;
import io.github.xrickastley.sevenelements.element.DurationElementalApplication;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.renderer.genshin.ElementEntry;
import io.github.xrickastley.sevenelements.renderer.genshin.SpecialEffectsRenderer;
import io.github.xrickastley.sevenelements.util.ClientConfig;
import io.github.xrickastley.sevenelements.util.Color;
import io.github.xrickastley.sevenelements.util.SphereRenderer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_922.class}, priority=0x7FFFFFFF)
public abstract class LivingEntityRendererMixin<T extends class_1309, M extends class_583<T>>
extends class_897<T> {
    protected LivingEntityRendererMixin(class_5617.class_5618 context) {
        super(context);
        throw new AssertionError();
    }

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="TAIL")})
    private void addRenderers(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        this.sevenelements$renderElementsIfPresent((class_1309)entity, matrixStack, tickDelta);
        this.sevenelements$renderElementalGauges((class_1309)entity, matrixStack, tickDelta);
        this.sevenelements$renderCrystallizeShield((class_1309)entity, matrixStack);
    }

    @Unique
    private void sevenelements$renderElementsIfPresent(class_1309 entity, class_4587 matrixStack, float tickDelta) {
        if (entity.method_29504()) {
            return;
        }
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)entity);
        ArrayList<ElementEntry> elementArray = new ArrayList<ElementEntry>();
        if (component.hasValidLastReaction()) {
            ElementalReaction reaction = (ElementalReaction)component.getLastReaction().method_15442();
            long reactionAt = (Long)component.getLastReaction().method_15441();
            reaction.getReactionDisplayOrder().forEach(element -> elementArray.add(new ElementEntry((Element)((Object)element), 60.0, reactionAt, tickDelta)));
        } else {
            if (component.getAppliedElements().isEmpty()) {
                return;
            }
            Optional<Integer> priority = component.getHighestElementPriority();
            if (priority.isEmpty()) {
                return;
            }
            elementArray.addAll(component.getAppliedElements().filter(application -> application.getElement().getPriority() == ((Integer)priority.get()).intValue()).map(a -> ElementEntry.of(a, tickDelta)));
        }
        HashSet textures = new HashSet();
        elementArray.removeIf(entry -> !entry.getElement().hasTexture() || !textures.add(entry.getElement().getTexture()));
        Iterator<class_243> coords = this.sevenelements$generateTexturesUsingCenter(new class_243(0.0, 0.0, 0.0), 1.0, elementArray.size()).iterator();
        HashSet elementTexs = new HashSet();
        elementArray.removeIf(entry -> !elementTexs.add(entry.getElement().getTexture()));
        elementArray.forEach(entry -> entry.render(entity, matrixStack, this.field_4676.field_4686, (float)((class_243)coords.next()).method_10215()));
    }

    @Unique
    private ArrayList<class_243> sevenelements$generateTexturesUsingCenter(class_243 center, double length, int amount) {
        double totalDistance = length * (double)(amount - 1);
        double offset = totalDistance / 2.0;
        ArrayList<class_243> result = new ArrayList<class_243>();
        double curDistance = center.method_10215() + offset;
        for (int i = 0; i < amount; ++i) {
            result.add(new class_243(center.method_10216(), center.method_10214(), curDistance));
            curDistance -= length;
        }
        return result;
    }

    @Unique
    private void sevenelements$renderElementalGauges(class_1309 entity, class_4587 matrixStack, float tickDelta) {
        ClientConfig config = ClientConfig.get();
        if (!config.developer.displayElementalGauges) {
            return;
        }
        if (!entity.method_5805()) {
            return;
        }
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)entity);
        ArrayList<ElementalApplication> appliedElements = new ArrayList<ElementalApplication>(component.getAppliedElements().sortElements((a, b) -> a.getElement().getPriority() - b.getElement().getPriority()));
        int elementCount = appliedElements.size();
        Iterator<ElementalApplication> aeIterator = appliedElements.iterator();
        Stream.iterate(Float.valueOf(0.0f), n -> n.floatValue() / 1.25f < (float)elementCount, n -> Float.valueOf(n.floatValue() + 1.25f)).forEachOrdered(yOffset -> this.sevenelements$renderElementalGauge(entity, (ElementalApplication)aeIterator.next(), yOffset.floatValue() - 0.5f, matrixStack, tickDelta));
    }

    @Unique
    private void sevenelements$renderElementalGauge(class_1309 entity, ElementalApplication application, float yOffset, class_4587 matrixStack, float tickDelta) {
        if (application.isEmpty()) {
            return;
        }
        float GAUGE_SCALE = 0.35f;
        float SCALE_PER_GU = 2.5f;
        class_289 tessellator = class_289.method_1348();
        ClientConfig config = ClientConfig.get();
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, entity.method_5829().method_17940() * 1.15, 0.0);
        matrixStack.method_34425(new Matrix4f().rotation((Quaternionfc)this.field_4676.field_4686.method_23767()));
        matrixStack.method_22905(0.35f, 0.175f, 0.35f);
        float xOffset = (float)(entity.method_5829().method_17939() * 1.5) / 0.35f;
        float gaugeWidth = application.isGaugeUnits() ? (float)Math.min(2.5 * application.getGaugeUnits(), 10.0) : 5.0f;
        Matrix4f positionMatrix = matrixStack.method_23760().method_23761();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(positionMatrix, 0.0f + xOffset, 0.0f - yOffset, 0.0f).method_39415(-1);
        buffer.method_22918(positionMatrix, gaugeWidth + xOffset, 0.0f - yOffset, 0.0f).method_39415(-1);
        buffer.method_22918(positionMatrix, gaugeWidth + xOffset, 1.0f - yOffset, 0.0f).method_39415(-1);
        buffer.method_22918(positionMatrix, 0.0f + xOffset, 1.0f - yOffset, 0.0f).method_39415(-1);
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_9801)buffer.method_60800());
        float progress = this.sevenelements$getProgress(application, tickDelta);
        Color elementColor = application.getElement().getDamageColor();
        int color = application.isGaugeUnits() ? elementColor.asARGB() : elementColor.multiply(1.0, 1.0, 1.0, 0.5).asARGB();
        buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(positionMatrix, xOffset, 0.0f - yOffset, 1.0E-4f).method_39415(color);
        buffer.method_22918(positionMatrix, gaugeWidth * progress + xOffset, 0.0f - yOffset, 1.0E-4f).method_39415(color);
        buffer.method_22918(positionMatrix, gaugeWidth * progress + xOffset, 1.0f - yOffset, 1.0E-4f).method_39415(color);
        buffer.method_22918(positionMatrix, xOffset, 1.0f - yOffset, 1.0E-4f).method_39415(color);
        class_286.method_43433((class_9801)buffer.method_60800());
        if (application.isDuration()) {
            float gaugeProgress = (float)(application.getCurrentGauge() / application.getGaugeUnits());
            buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            buffer.method_22918(positionMatrix, xOffset, 0.0f - yOffset, 1.0E-4f).method_39415(color);
            buffer.method_22918(positionMatrix, gaugeWidth * gaugeProgress + xOffset, 0.0f - yOffset, 1.0E-4f).method_39415(color);
            buffer.method_22918(positionMatrix, gaugeWidth * gaugeProgress + xOffset, 1.0f - yOffset, 1.0E-4f).method_39415(color);
            buffer.method_22918(positionMatrix, xOffset, 1.0f - yOffset, 1.0E-4f).method_39415(color);
            class_286.method_43433((class_9801)buffer.method_60800());
        }
        RenderSystem.setShader(class_757::method_34535);
        RenderSystem.disableCull();
        float scaledGauge = (float)(0.1 * (double)gaugeWidth / application.getGaugeUnits());
        int splits = (int)Math.floor((double)gaugeWidth / (0.1 * (double)gaugeWidth / application.getGaugeUnits()));
        for (int c = 1; c < splits && config.developer.displayGaugeRuler; ++c) {
            float i = (float)c * scaledGauge;
            float addedY = c % 10 == 0 ? 1.0f : (c % 5 == 0 ? 0.5f : 0.25f);
            float lineWidth = c % 10 == 0 ? 5.0f : 2.5f;
            buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
            buffer.method_22918(positionMatrix, xOffset + i, 0.0f - yOffset, -5.0E-4f).method_39415(-16777216).method_22914(0.0f, lineWidth, 0.0f);
            buffer.method_22918(positionMatrix, xOffset + i, addedY - yOffset, -5.0E-4f).method_39415(-16777216).method_22914(xOffset + i, lineWidth, 0.0f);
            float prev = RenderSystem.getShaderLineWidth();
            RenderSystem.lineWidth((float)lineWidth);
            class_286.method_43433((class_9801)buffer.method_60800());
            RenderSystem.lineWidth((float)prev);
        }
        RenderSystem.enableCull();
        matrixStack.method_22909();
    }

    @Unique
    private float sevenelements$getProgress(ElementalApplication application, float tickDelta) {
        float f;
        if (application instanceof DurationElementalApplication) {
            DurationElementalApplication durationApp = (DurationElementalApplication)application;
            f = (float)((double)((float)application.getRemainingTicks() - tickDelta) / durationApp.getDuration());
        } else {
            f = (float)(application.getCurrentGauge() / application.getGaugeUnits());
        }
        return f;
    }

    @Unique
    private void sevenelements$renderCrystallizeShield(class_1309 entity, class_4587 matrixStack) {
        ClientConfig config = ClientConfig.get();
        if (!SpecialEffectsRenderer.shouldRender((class_1297)entity)) {
            return;
        }
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)entity);
        @Nullable class_3545<Element, Double> crystallizeShield = component.getCrystallizeShield();
        if (crystallizeShield == null) {
            return;
        }
        double lengthY = entity.method_5829().method_17940();
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40715.rotationDegrees(this.field_4676.field_4686.method_19330()));
        matrixStack.method_22904(0.0, lengthY * 0.6, 0.0);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        SphereRenderer.render(matrixStack, new class_243(0.0, 0.0, 0.0), (float)(lengthY / 2.0 * 1.25), config.rendering.elements.sphereResolution, config.rendering.elements.sphereResolution * 2, pos -> ((Element)((Object)((Object)crystallizeShield.method_15442()))).getDamageColor().multiply(1.0, 1.0, 1.0, 0.75 * Math.pow(pos.field_1352, 4.0)).asARGB());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        matrixStack.method_22909();
    }

    @Unique
    private FrozenEffectComponent sevenelements$getComponent(class_1309 entity) {
        return (FrozenEffectComponent)FrozenEffectComponent.KEY.get((Object)entity);
    }

    @Unique
    private <R> R sevenelements$ifFrozen(class_1309 entity, Function<FrozenEffectComponent, R> ifFrozen, R ifNotFrozen) {
        FrozenEffectComponent component = (FrozenEffectComponent)FrozenEffectComponent.KEY.get((Object)entity);
        return component.isFrozen() ? ifFrozen.apply(component) : ifNotFrozen;
    }

    @ModifyExpressionValue(method={"getRenderLayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/LivingEntityRenderer;getTexture(Lnet/minecraft/entity/Entity;)Lnet/minecraft/util/Identifier;")})
    private class_2960 renderFrostedModel(class_2960 original, @Local(argsOnly=true) class_1309 entity) {
        if (!ClientConfig.getEffectRenderType().allowsSpecialEffects()) {
            return original;
        }
        return this.sevenelements$ifFrozen(entity, c -> class_2960.method_60655((String)"minecraft", (String)"textures/block/ice.png"), original);
    }

    @ModifyReturnValue(method={"isShaking"}, at={@At(value="RETURN")})
    private boolean isShakingWhenFrozen(boolean original, @Local(argsOnly=true) class_1309 entity) {
        return original || this.sevenelements$getComponent(entity).isFrozen();
    }

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="HEAD")})
    private void forceFrozenPose(T livingEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci, @Local(argsOnly=true) class_1309 entity) {
        FrozenEffectComponent component = (FrozenEffectComponent)FrozenEffectComponent.KEY.get((Object)entity);
        if (component.isFrozen()) {
            livingEntity.method_18380(component.getForcePose());
        }
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;lerpAngleDegrees(FFF)F", ordinal=0)})
    private float forceFrozenBodyYaw(float original, @Local(argsOnly=true) class_1309 entity) {
        return this.sevenelements$ifFrozen(entity, FrozenEffectComponent::getForceBodyYaw, Float.valueOf(original)).floatValue();
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;lerpAngleDegrees(FFF)F", ordinal=1)})
    private float forceFrozenHeadYaw(float original, @Local(argsOnly=true) class_1309 entity) {
        return this.sevenelements$ifFrozen(entity, FrozenEffectComponent::getForceHeadYaw, Float.valueOf(original)).floatValue();
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;lerp(FFF)F", ordinal=0)})
    private float forceFrozenPitch(float original, @Local(argsOnly=true) class_1309 entity) {
        return this.sevenelements$ifFrozen(entity, FrozenEffectComponent::getForcePitch, Float.valueOf(original)).floatValue();
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LimbAnimator;getSpeed(F)F")})
    private float forceFrozenLimbDistance(float original, @Local(argsOnly=true) class_1309 entity) {
        return this.sevenelements$ifFrozen(entity, FrozenEffectComponent::getForceLimbDistance, Float.valueOf(original)).floatValue();
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LimbAnimator;getPos(F)F")})
    private float forceFrozenLimbAngle(float original, @Local(argsOnly=true) class_1309 entity) {
        return this.sevenelements$ifFrozen(entity, FrozenEffectComponent::getForceLimbAngle, Float.valueOf(original)).floatValue();
    }
}

