/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.registry.dynamic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.mixin.RegistryLoaderAccessor;
import io.github.xrickastley.sevenelements.registry.SevenElementsRegistryKeys;
import io.github.xrickastley.sevenelements.registry.dynamic.DynamicRegistryLoadEvents;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5912;
import net.minecraft.class_6903;
import net.minecraft.class_7654;
import net.minecraft.class_7655;
import net.minecraft.class_7782;
import net.minecraft.class_7924;
import net.minecraft.class_9248;
import org.jetbrains.annotations.Nullable;

public final class SevenElementsRegistryLoader {
    private static final List<Entry<?, ?>> DYNAMIC_REGISTRIES = new ArrayList();
    private static final Multimap<class_5321<?>, class_2960> UNMODIFIABLE_ENTRIES = HashMultimap.create();

    static void add(Entry<?, ?> entry) {
        DYNAMIC_REGISTRIES.add(entry);
    }

    static void addUnmodifiableEntries(class_5321<? extends class_2378<?>> key, class_2960 ... ids) {
        SevenElementsRegistryLoader.addUnmodifiableEntries(key, List.of(ids));
    }

    static void addUnmodifiableEntries(class_5321<? extends class_2378<?>> key, List<class_2960> ids) {
        if (!SevenElementsRegistryLoader.isDynamicRegistry(key)) {
            throw new IllegalArgumentException("You may only pass a dynamic registry registered to the SevenElementsRegistryLoader!");
        }
        UNMODIFIABLE_ENTRIES.putAll(key, ids);
    }

    public static <E> void loadFromResource(class_3300 resourceManager, class_6903.class_7863 infoGetter, class_2385<E> registry, Decoder<E> elementDecoder, Map<class_5321<?>, Exception> errors) {
        @Nullable Entry<E, C> dynRegEntry = SevenElementsRegistryLoader.getDynamicRegistry(registry);
        if (dynRegEntry == null) {
            throw new IllegalArgumentException("You may only pass a dynamic registry registered to the SevenElementsRegistryLoader!");
        }
        ((DynamicRegistryLoadEvents.BeforeLoad)DynamicRegistryLoadEvents.BEFORE_LOAD.invoker()).onBeforeLoad(new DynamicRegistryLoadEvents.RegistryContextImpl<E>(registry.method_30517(), registry));
        dynRegEntry.requireUnmodifiableEntries(registry);
        String path = dynRegEntry.getPath();
        class_7654 resourceFinder = class_7654.method_45114((String)path);
        class_6903 registryOps = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_6903.class_7863)infoGetter);
        for (Map.Entry entry : resourceFinder.method_45113(resourceManager).entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            class_2960 resourceId = resourceFinder.method_45115(identifier);
            if (dynRegEntry.isUnmodifiable(resourceId)) {
                SevenElements.sublogger().warn("The data pack (\"{}\") with file at path ({}/{}) attempted to overwrite the preloaded entry {}, ignoring!", new Object[]{((class_3298)entry.getValue()).method_14480(), identifier.method_12836(), identifier.method_12832(), resourceId});
                continue;
            }
            class_5321 registryKey = class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)resourceId);
            class_3298 resource = (class_3298)entry.getValue();
            class_9248 registryEntryInfo = RegistryLoaderAccessor.getResourceEntryInfoGetter().apply(resource.method_56936());
            try {
                SevenElementsRegistryLoader.parseAndAdd(registry, (Entry)ClassInstanceUtil.cast(dynRegEntry), (class_6903<JsonElement>)registryOps, registryKey, resourceId, resource, registryEntryInfo);
            }
            catch (Exception var15) {
                errors.put(registryKey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", identifier, resource.method_14480()), var15));
            }
        }
        ((DynamicRegistryLoadEvents.AfterLoad)DynamicRegistryLoadEvents.AFTER_LOAD.invoker()).onAfterLoad(new DynamicRegistryLoadEvents.RegistryContextImpl<E>(registry.method_30517(), registry));
    }

    public static <E> void loadFromNetwork(Map<class_5321<? extends class_2378<?>>, List<class_7782.class_9176>> data, class_5912 factory, class_6903.class_7863 infoGetter, class_2385<E> registry, Decoder<E> decoder, Map<class_5321<?>, Exception> loadingErrors) {
        @Nullable Entry<E, C> dynRegEntry = SevenElementsRegistryLoader.getDynamicRegistry(registry);
        if (dynRegEntry == null) {
            throw new IllegalArgumentException("You may only pass a dynamic registry registered to the SevenElementsRegistryLoader!");
        }
        ((DynamicRegistryLoadEvents.BeforeLoad)DynamicRegistryLoadEvents.BEFORE_LOAD.invoker()).onBeforeLoad(new DynamicRegistryLoadEvents.RegistryContextImpl<E>(registry.method_30517(), registry));
        dynRegEntry.requireUnmodifiableEntries(registry);
        List<class_7782.class_9176> list = data.get(registry.method_30517());
        if (list != null) {
            class_6903 registryOps = class_6903.method_40414((DynamicOps)class_2509.field_11560, (class_6903.class_7863)infoGetter);
            class_6903 registryOps2 = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_6903.class_7863)infoGetter);
            String string = class_7924.method_60915((class_5321)registry.method_30517());
            class_7654 resourceFinder = class_7654.method_45114((String)string);
            for (class_7782.class_9176 serializedRegistryEntry : list) {
                if (dynRegEntry.isUnmodifiable(serializedRegistryEntry.comp_2256())) continue;
                class_5321 registryKey = class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)serializedRegistryEntry.comp_2256());
                Optional optional = serializedRegistryEntry.comp_2257();
                if (optional.isPresent()) {
                    try {
                        DataResult dataResult = decoder.parse((DynamicOps)registryOps, (Object)((class_2520)optional.get()));
                        Object object = dataResult.getOrThrow();
                        registry.method_10272(registryKey, object, RegistryLoaderAccessor.getExperimentalEntryInfo());
                        ((DynamicRegistryLoadEvents.EntryLoad)DynamicRegistryLoadEvents.ENTRY_LOAD.invoker()).onEntryLoad(new DynamicRegistryLoadEvents.RegistryEntryContextImpl<Object>(object, (class_5321<class_2378<Object>>)registry.method_30517(), (class_2378<Object>)registry));
                    }
                    catch (Exception var17) {
                        loadingErrors.put(registryKey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", optional.get()), var17));
                    }
                    continue;
                }
                class_2960 identifier = resourceFinder.method_45112(serializedRegistryEntry.comp_2256());
                try {
                    class_3298 resource = factory.getResourceOrThrow(identifier);
                    class_2960 resourceId = resourceFinder.method_45115(identifier);
                    if (dynRegEntry.isUnmodifiable(resourceId)) {
                        SevenElements.sublogger().warn("The data pack (\"{}\") with file at path ({}/{}) attempted to overwrite the preloaded entry {}, ignoring!", new Object[]{resource.method_14480(), identifier.method_12836(), identifier.method_12832(), resourceId});
                        continue;
                    }
                    SevenElementsRegistryLoader.parseAndAdd(registry, (Entry)ClassInstanceUtil.cast(dynRegEntry), (class_6903<JsonElement>)registryOps2, registryKey, resourceFinder.method_45115(identifier), resource, RegistryLoaderAccessor.getExperimentalEntryInfo());
                }
                catch (Exception var18) {
                    loadingErrors.put(registryKey, new IllegalStateException("Failed to parse local data", var18));
                }
            }
            ((DynamicRegistryLoadEvents.AfterLoad)DynamicRegistryLoadEvents.AFTER_LOAD.invoker()).onAfterLoad(new DynamicRegistryLoadEvents.RegistryContextImpl<E>(registry.method_30517(), registry));
        }
    }

    public static <E> void parseAndAdd(class_2385<E> registry, Entry<E, ?> entry, class_6903<JsonElement> ops, class_5321<E> key, class_2960 identifier, class_3298 resource, class_9248 entryInfo) throws IOException {
        try (BufferedReader reader = resource.method_43039();){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            E object = entry.parse(ops, jsonElement, identifier);
            registry.method_10272(key, object, entryInfo);
            ((DynamicRegistryLoadEvents.EntryLoad)DynamicRegistryLoadEvents.ENTRY_LOAD.invoker()).onEntryLoad(new DynamicRegistryLoadEvents.RegistryEntryContextImpl<E>(object, registry.method_30517(), registry));
        }
    }

    public static boolean isDynamicRegistry(class_2378<?> registry) {
        return SevenElementsRegistryLoader.isDynamicRegistry(registry.method_30517());
    }

    public static boolean isDynamicRegistry(class_5321<? extends class_2378<?>> registryKey) {
        return DYNAMIC_REGISTRIES.stream().anyMatch(entry -> entry.key == registryKey);
    }

    @Nullable
    private static <T, C> Entry<T, C> getDynamicRegistry(class_2378<T> registry) {
        return SevenElementsRegistryLoader.getDynamicRegistry(registry.method_30517());
    }

    @Nullable
    private static <T, C> Entry<T, C> getDynamicRegistry(class_5321<? extends class_2378<T>> registryKey) {
        for (Entry<?, ?> entry : DYNAMIC_REGISTRIES) {
            if (entry.key != registryKey) continue;
            return (Entry)ClassInstanceUtil.cast(entry);
        }
        return null;
    }

    static {
        new IdentifiedEntry<InternalCooldownType, InternalCooldownType.Builder>(InternalCooldownType.class, SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE, InternalCooldownType.Builder.CODEC, InternalCooldownType.Builder::getInstance);
    }

    public static class Entry<T, C> {
        private final Class<T> entryClass;
        private final class_5321<? extends class_2378<T>> key;
        private final Codec<C> elementCodec;
        private final boolean requiredNonEmpty;
        private boolean useNamespace = false;

        public Entry(Class<T> entryClass, class_5321<? extends class_2378<T>> registryKey, Codec<C> codec) {
            this(entryClass, registryKey, codec, false);
        }

        public Entry(Class<T> entryClass, class_5321<? extends class_2378<T>> key, Codec<C> elementCodec, boolean requiredNonEmpty) {
            this.entryClass = entryClass;
            this.key = key;
            this.elementCodec = elementCodec;
            this.requiredNonEmpty = requiredNonEmpty;
        }

        public void shouldUseNamespace(boolean useNamespace) {
            this.useNamespace = useNamespace;
        }

        public String getPath() {
            String path = class_7924.method_60915(this.key);
            return this.useNamespace ? this.key.method_29177().method_12836() + "/" + path : path;
        }

        public class_7655.class_7657<T> asRegistryLoaderEntry() {
            return new class_7655.class_7657(this.key, (Codec)ClassInstanceUtil.cast(this.elementCodec), this.requiredNonEmpty);
        }

        public T parse(class_6903<JsonElement> ops, JsonElement jsonElement, class_2960 identifier) {
            DataResult dataResult = this.elementCodec.parse(ops, (Object)jsonElement);
            return this.entryClass.cast(dataResult.getOrThrow());
        }

        public T parse(class_6903<class_2520> ops, class_2520 nbt, class_2960 identifier) {
            DataResult dataResult = this.elementCodec.parse(ops, (Object)nbt);
            return this.entryClass.cast(dataResult.getOrThrow());
        }

        public boolean isUnmodifiable(class_2960 id) {
            @Nullable Collection entries = UNMODIFIABLE_ENTRIES.get(this.key);
            return entries != null && entries.contains(id);
        }

        public void requireUnmodifiableEntries(class_2385<?> registry) {
            @Nullable Collection entries = UNMODIFIABLE_ENTRIES.get(this.key);
            if (entries == null) {
                return;
            }
            List<class_2960> unregistered = entries.stream().filter(Predicate.not(arg_0 -> registry.method_10250(arg_0))).toList();
            if (unregistered.isEmpty()) {
                return;
            }
            throw new IllegalStateException("Some unmodifiable holders were not registered: " + String.valueOf(unregistered));
        }
    }

    public static class IdentifiedEntry<T, R>
    extends Entry<T, R> {
        private final BiFunction<R, class_2960, T> resultFn;

        public IdentifiedEntry(Class<T> resultClass, class_5321<? extends class_2378<T>> registryKey, Codec<R> resultCodec, BiFunction<R, class_2960, T> resultFn) {
            this(resultClass, registryKey, resultCodec, resultFn, false);
        }

        public IdentifiedEntry(Class<T> resultClass, class_5321<? extends class_2378<T>> registryKey, Codec<R> resultCodec, BiFunction<R, class_2960, T> resultFn, boolean requiredNonEmpty) {
            super(resultClass, (class_5321)ClassInstanceUtil.cast(registryKey), resultCodec, requiredNonEmpty);
            this.resultFn = resultFn;
        }

        @Override
        public T parse(class_6903<JsonElement> ops, JsonElement jsonElement, class_2960 identifier) {
            DataResult dataResult = this.elementCodec.parse(ops, (Object)jsonElement);
            return this.resultFn.apply(dataResult.getOrThrow(), identifier);
        }

        @Override
        public T parse(class_6903<class_2520> ops, class_2520 nbt, class_2960 identifier) {
            DataResult dataResult = this.elementCodec.parse(ops, (Object)nbt);
            return this.resultFn.apply(dataResult.getOrThrow(), identifier);
        }
    }
}

