package io.github.xrickastley.sevenelements.registry.dynamic;

import com.mojang.serialization.Codec;

import java.util.List;
import java.util.function.BiFunction;

import net.fabricmc.fabric.impl.registry.sync.DynamicRegistriesImpl;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public final class DynamicRegistries {
	public static <T> void register(Class<T> entryClass, class_5321<? extends class_2378<T>> key, Codec<T> elementCodec) {
		SevenElementsRegistryLoader.add(
			new SevenElementsRegistryLoader.Entry<>(entryClass, key, elementCodec)
		);

		net.fabricmc.fabric.api.event.registry.DynamicRegistries.registerSynced(key, elementCodec);
		DynamicRegistriesImpl.FABRIC_DYNAMIC_REGISTRY_KEYS.remove(key);
	}

	public static <T, R> void registerIdentified(Class<T> resultClass, class_5321<? extends class_2378<T>> key, Codec<R> builderCodec, Codec<T> elementCodec, BiFunction<R, class_2960, T> resultFn) {
		SevenElementsRegistryLoader.add(
			new SevenElementsRegistryLoader.IdentifiedEntry<>(resultClass, key, builderCodec, resultFn)
		);

		net.fabricmc.fabric.api.event.registry.DynamicRegistries.registerSynced(key, elementCodec);
		DynamicRegistriesImpl.FABRIC_DYNAMIC_REGISTRY_KEYS.remove(key);
	}

	public static void addUnmodifiableEntries(class_5321<? extends class_2378<?>> key, class_2960... ids) {
		SevenElementsRegistryLoader.addUnmodifiableEntries(key, ids);
	}

	public static void addUnmodifiableEntries(class_5321<? extends class_2378<?>> key, List<class_2960> ids) {
		SevenElementsRegistryLoader.addUnmodifiableEntries(key, ids);
	}
}
