/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.registry.SevenElementsRegistryKeys;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5381;
import net.minecraft.class_5699;

public final class InternalCooldownType {
    private static final List<InternalCooldownType> PRELOADED_INSTANCES = new ArrayList<InternalCooldownType>();
    public static final InternalCooldownType NONE = InternalCooldownType.registered(SevenElements.identifier("none"), 0, 0);
    public static final InternalCooldownType DEFAULT = InternalCooldownType.registered(SevenElements.identifier("default"), 50, 3);
    public static final InternalCooldownType INTERVAL_ONLY = InternalCooldownType.registered(SevenElements.identifier("interval_only"), 50, Integer.MAX_VALUE);
    public static final Codec<InternalCooldownType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(InternalCooldownType::getId), (App)class_5699.method_48766((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("reset_interval", (Object)50).forGetter(InternalCooldownType::getResetInterval), (App)class_5699.method_48766((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("gauge_sequence", (Object)3).forGetter(InternalCooldownType::getGaugeSequence)).apply((Applicative)instance, InternalCooldownType::new));
    public static final class_5381<InternalCooldownType> REGISTRY_CODEC = class_5381.method_29749(SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE, CODEC);
    private final class_2960 id;
    private final int resetInterval;
    private final int gaugeSequence;

    private InternalCooldownType(class_2960 id, int resetInterval, int gaugeSequence) {
        if (resetInterval < 0) {
            throw new IllegalArgumentException("Provided resetInterval " + resetInterval + " is out of range: [0, 2147483647]");
        }
        if (gaugeSequence < 0) {
            throw new IllegalArgumentException("Provided gaugeSequence " + gaugeSequence + " is out of range: [0, 2147483647]");
        }
        this.id = id;
        this.resetInterval = resetInterval;
        this.gaugeSequence = gaugeSequence;
    }

    public static InternalCooldownType of(class_2960 id, int resetInterval, int gaugeSequence) {
        return new InternalCooldownType(id, resetInterval, gaugeSequence);
    }

    public static InternalCooldownType registered(class_2960 id, int resetInterval, int gaugeSequence) {
        InternalCooldownType icdType = new InternalCooldownType(id, resetInterval, gaugeSequence);
        PRELOADED_INSTANCES.add(icdType);
        return icdType;
    }

    public static void onBeforeRegistryLoad(class_2378<InternalCooldownType> registry) {
        PRELOADED_INSTANCES.forEach(inst -> class_2378.method_10230((class_2378)registry, (class_2960)inst.getId(), (Object)inst));
    }

    public static List<class_2960> getPreloadedInstances() {
        return PRELOADED_INSTANCES.stream().map(InternalCooldownType::getId).toList();
    }

    public class_2960 getId() {
        return this.id;
    }

    public int getResetInterval() {
        return this.resetInterval;
    }

    public int getGaugeSequence() {
        return this.gaugeSequence;
    }

    public Builder getBuilder() {
        return new Builder(this.resetInterval, this.gaugeSequence);
    }

    public String toString() {
        return String.format("InternalCooldownType[%s/resetInterval=%d,gaugeSequence=%d]", this.id, this.resetInterval, this.gaugeSequence);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InternalCooldownType)) {
            return false;
        }
        InternalCooldownType type = (InternalCooldownType)obj;
        return this.id.equals((Object)type.id) && this.gaugeSequence == type.gaugeSequence && this.resetInterval == type.resetInterval;
    }

    public class_5250 getText() {
        return class_2561.method_43470((String)this.id.toString());
    }

    public class_5250 getText(boolean addValues) {
        if (!addValues) {
            return this.getText();
        }
        String gaugeSequence = this.gaugeSequence == Integer.MAX_VALUE ? DecimalFormatSymbols.getInstance().getInfinity() : String.valueOf(this.gaugeSequence);
        return class_2561.method_43473().method_10852((class_2561)this.getText()).method_27693(" (").method_10852((class_2561)class_2561.method_43469((String)"formats.seven-elements.icd_type", (Object[])new Object[]{(double)this.resetInterval / 20.0, gaugeSequence})).method_27693(")");
    }

    public static final class Builder {
        public static final Codec<Builder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("reset_interval", (Object)50).forGetter(Builder::getResetInterval), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("gauge_sequence", (Object)3).forGetter(Builder::getGaugeSequence)).apply((Applicative)instance, Builder::new));
        private final int resetInterval;
        private final int gaugeSequence;

        private Builder(int resetInterval, int gaugeSequence) {
            this.resetInterval = resetInterval;
            this.gaugeSequence = gaugeSequence;
        }

        public InternalCooldownType getInstance(class_2960 registryId) {
            return new InternalCooldownType(registryId, this.resetInterval, this.gaugeSequence);
        }

        private int getResetInterval() {
            return this.resetInterval;
        }

        private int getGaugeSequence() {
            return this.gaugeSequence;
        }
    }
}

