/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element.reaction;

import com.google.common.base.Suppliers;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.annotation.mixin.At;
import io.github.xrickastley.sevenelements.annotation.mixin.Inject;
import io.github.xrickastley.sevenelements.annotation.mixin.Local;
import io.github.xrickastley.sevenelements.annotation.mixin.ModifyExpressionValue;
import io.github.xrickastley.sevenelements.annotation.mixin.ModifyVariable;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementHolder;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.element.reaction.AbstractDendroCoreElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.events.ElementEvents;
import io.github.xrickastley.sevenelements.events.ReactionTriggered;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypes;
import io.github.xrickastley.sevenelements.registry.SevenElementsRegistries;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractBurningElementalReaction
extends ElementalReaction {
    private static final InternalCooldownType BURNING_PYRO_ICD = InternalCooldownType.registered(SevenElements.identifier("reactions/burning/pyro_icd"), 40, Integer.MAX_VALUE);
    private static final Supplier<Set<ElementalReaction>> REACTIONS = Suppliers.memoize(() -> SevenElementsRegistries.ELEMENTAL_REACTION.method_40270().map(class_6880.class_6883::comp_349).filter(r -> !(r instanceof AbstractDendroCoreElementalReaction) && r.getAuraElement() != Element.PYRO && (r.getTriggeringElement() != Element.PYRO || !r.reversable)).collect(Collectors.toSet()));

    AbstractBurningElementalReaction(ElementalReaction.Settings settings) {
        super(settings);
    }

    @Override
    public boolean isTriggerable(class_1309 entity) {
        return super.isTriggerable(entity) && !((ElementComponent)ElementComponent.KEY.get((Object)entity)).hasElementalApplication(Element.BURNING);
    }

    @Override
    protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)entity);
        InternalCooldownContext context = InternalCooldownContext.ofType(origin, "seven-elements:reactions/burning", BURNING_PYRO_ICD);
        ElementHolder holder = component.getElementHolder(Element.PYRO);
        if (context.hasOrigin() && context.getInternalCooldown(holder).handleInternalCooldown()) {
            ElementalApplication application = ElementalApplications.gaugeUnits(entity, Element.PYRO, 1.0, true);
            if (!holder.hasElementalApplication() || holder.getElementalApplication().isEmpty()) {
                holder.setElementalApplication(application);
            } else {
                holder.getElementalApplication().reapply(application);
            }
        }
        component.getElementHolder(Element.BURNING).setElementalApplication(ElementalApplications.gaugeUnits(entity, Element.BURNING, 2.0, true));
        component.resetBurningCD();
        component.setOrRetainBurningOrigin(origin);
        ElementComponent.sync((class_1297)entity);
    }

    @Inject(method={"Lio/github/xrickastley/sevenelements/component/ElementComponentImpl;tick()V"}, at={@At(value="HEAD")})
    public static void mixin$tick(@Local(field="owner:Lnet/minecraft/entity/LivingEntity;") class_1309 entity) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)entity);
        if (!component.hasElementalApplication(Element.BURNING) || component.isBurningOnCD() || entity.method_37908().field_9236) {
            return;
        }
        if (!component.hasElementalApplication(Element.DENDRO) && !component.hasElementalApplication(Element.QUICKEN)) {
            component.getElementHolder(Element.BURNING).setElementalApplication(null);
            return;
        }
        for (class_1309 target : ElementalReaction.getEntitiesInAoE(entity, 1.0, t -> !((ElementComponent)ElementComponent.KEY.get(t)).isBurningOnCD())) {
            float damage = ElementalReaction.getReactionDamage((class_1297)entity, 0.25);
            ElementalDamageSource source = new ElementalDamageSource(entity.method_48923().method_48797(SevenElementsDamageTypes.BURNING, (class_1297)entity, (class_1297)component.getBurningOrigin()), target == entity ? ElementalApplications.gaugeUnits(target, Element.PYRO, 0.0) : ElementalApplications.gaugeUnits(target, Element.PYRO, 1.0), target == entity ? InternalCooldownContext.ofNone() : InternalCooldownContext.ofType(entity, "seven-elements:reactions/burning", BURNING_PYRO_ICD)).shouldApplyDMGBonus(false);
            target.method_5643((class_1282)source, damage);
            target.method_33572(true);
            target.method_20803(5);
            ElementComponent targetComponent = (ElementComponent)ElementComponent.KEY.get((Object)target);
            ElementHolder holder = targetComponent.getElementHolder(Element.PYRO);
            if (target == entity && holder.canApplyElement(Element.PYRO, InternalCooldownContext.ofType(entity, "seven-elements:reactions/burning", BURNING_PYRO_ICD), true)) {
                ElementalApplication application = holder.getElementalApplication();
                if (application == null) {
                    holder.setElementalApplication(ElementalApplications.gaugeUnits(target, Element.PYRO, 1.0));
                } else {
                    application.reapply(Element.PYRO, 1.0);
                }
            }
            targetComponent.resetBurningCD();
        }
    }

    @Inject(method={"Lio/github/xrickastley/sevenelements/component/ElementComponentImpl;attemptReapply(Lio/github/xrickastley/sevenelements/element/ElementalApplication;)Z"}, at={@At(value="IF", ordinal=2)}, directive="INJECT_AS_ELSE")
    public static void mixin$forceReapplyDendroWhenBurning(@Local(self=true) ElementComponent component, @Local(argsOnly=true) ElementalApplication application) {
        if (application.getElement() != Element.DENDRO) {
            return;
        }
        Set appliedElements = component.getAppliedElements().stream().map(ElementalApplication::getElement).collect(Collectors.toSet());
        if (!appliedElements.contains((Object)Element.BURNING)) {
            return;
        }
        component.getElementHolder(Element.DENDRO).setElementalApplication(application.asAura());
        ElementComponent.sync((class_1297)component.getOwner());
    }

    @ModifyExpressionValue(method={"Lio/github/xrickastley/sevenelements/component/ElementComponentImpl;triggerReactions(Lio/github/xrickastley/sevenelements/element/ElementalApplication;Lnet/minecraft/entity/LivingEntity;)Ljava/util/Set;"}, at={@At(value="INVOKE", target="Ljava/util/stream/Stream;noneMatch(Ljava/util/function/Predicate;)Z")})
    public static boolean mixin$onlyAllowPyroReactions(boolean original, @Local(self=true) ElementComponent component, @Local ElementalReaction reaction) {
        if (!component.hasElementalApplication(Element.BURNING)) {
            return original;
        }
        return original && !REACTIONS.get().contains(reaction);
    }

    @ModifyExpressionValue(method={"Lio/github/xrickastley/sevenelements/component/ElementComponentImpl;triggerReactions(Lio/github/xrickastley/sevenelements/element/ElementalApplication;Lnet/minecraft/entity/LivingEntity;)Ljava/util/Set;"}, at={@At(value="CONSTANT_ACCESS", target="hasHigherPriority;Z")})
    public static boolean mixin$allowDendroPassthrough(boolean original, @Local ElementComponent component, @Local ElementalApplication application) {
        return original && (!component.hasElementalApplication(Element.BURNING) || application.getElement() != Element.DENDRO && application.getElement() != Element.PYRO);
    }

    @Inject(method={"Lio/github/xrickastley/sevenelements/element/ElementalApplication;tick()V"}, at={@At(value="HEAD")})
    public static void mixin$reduceQuickenGauge(@Local(argsOnly=true) ElementalApplication application) {
        ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)application.getEntity());
        if (!component.hasElementalApplication(Element.BURNING) || component.hasElementalApplication(Element.DENDRO) || application.getElement() != Element.QUICKEN) {
            return;
        }
        application.reduceGauge(Element.DENDRO.getCustomDecayRate().apply(application).doubleValue());
    }

    @ModifyVariable(method={"Lio/github/xrickastley/sevenelements/component/ElementComponentImpl;triggerReactions(Lio/github/xrickastley/sevenelements/element/ElementalApplication;Lnet/minecraft/entity/LivingEntity;)Ljava/util/Set;"}, at=@At(value="STORE", ordinal=3, shift=At.Shift.AFTER))
    public static Optional<ElementalReaction> mixin$changeReaction(Optional<ElementalReaction> original, @Local(self=true) ElementComponent component, @Local(argsOnly=true) ElementalApplication application) {
        if (!component.hasElementalApplication(Element.BURNING)) {
            return original;
        }
        return SevenElementsRegistries.ELEMENTAL_REACTION.method_40270().map(class_6880.class_6883::comp_349).filter(r -> r.isTriggerable(component.getOwner()) && (r.getAuraElement() == Element.PYRO || r.getTriggeringElement() == Element.PYRO && r.reversable)).min(Comparator.comparing(r -> r.getPriority(application)));
    }

    static {
        ElementEvents.APPLIED.register((element, application) -> {
            if (application.getEntity().method_37908().field_9236 || element != Element.BURNING) {
                return;
            }
            ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)application.getEntity());
            if (component.hasElementalApplication(Element.DENDRO) || component.hasElementalApplication(Element.QUICKEN)) {
                return;
            }
            component.getElementHolder(Element.BURNING).setElementalApplication(null);
            ElementComponent.sync((class_1297)application.getEntity());
        });
        ElementEvents.REMOVED.register((element, application) -> {
            if (element == Element.BURNING) {
                ElementComponent.sync((class_1297)application.getEntity());
            }
            if (element != Element.DENDRO && element != Element.QUICKEN) {
                return;
            }
            ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)application.getEntity());
            component.getElementHolder(Element.BURNING).setElementalApplication(null);
            ElementComponent.sync((class_1297)application.getEntity());
        });
        ReactionTriggered.EVENT.register((reaction, reducedGauge, target, origin) -> {
            ElementComponent component = (ElementComponent)ElementComponent.KEY.get((Object)target);
            if (!component.hasElementalApplication(Element.BURNING) || reaction instanceof AbstractBurningElementalReaction) {
                return;
            }
            ElementalApplication applicationAE = component.getElementalApplication(reaction.getAuraElement());
            ElementalApplication applicationTE = component.getElementalApplication(reaction.getTriggeringElement());
            double newReducedGauge = (applicationAE.getElement() == Element.PYRO ? applicationTE.getCurrentGauge() + reducedGauge : applicationAE.getCurrentGauge() + reducedGauge) * reaction.reactionCoefficient;
            component.getElementalApplication(Element.BURNING).reduceGauge(newReducedGauge);
            ElementComponent.sync((class_1297)target);
        });
    }
}

