/*
 * Decompiled with CFR 0.152.
 */
package i18nupdatemod.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import i18nupdatemod.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class AssetUtil {
    private static final String CFPA_ASSET_ROOT = "http://downloader1.meitangdehulu.com:22943/";
    private static final List<String> MIRRORS = new ArrayList<String>();

    public static void download(String url, Path localFile) throws IOException, URISyntaxException {
        Log.info("Downloading: %s -> %s", url, localFile);
        FileUtils.copyURLToFile((URL)new URI(url).toURL(), (File)localFile.toFile(), (int)((int)TimeUnit.SECONDS.toMillis(3L)), (int)((int)TimeUnit.SECONDS.toMillis(33L)));
        Log.debug("Downloaded: %s -> %s", url, localFile);
    }

    public static String getString(String url) throws IOException, URISyntaxException {
        return IOUtils.toString((URL)new URI(url).toURL(), (Charset)StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFastestUrl() {
        ArrayList<String> urls = new ArrayList<String>(MIRRORS);
        urls.add(CFPA_ASSET_ROOT);
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(urls.size(), 10));
        try {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            for (String url : urls) {
                CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
                    try {
                        return AssetUtil.testUrlConnection(url);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }, executor);
                futures.add(future);
            }
            String fastest = null;
            while (!futures.isEmpty()) {
                CompletableFuture<Object> first = CompletableFuture.anyOf(futures.toArray(new CompletableFuture[0]));
                fastest = (String)first.join();
                futures.removeIf(CompletableFuture::isDone);
                if (fastest == null) continue;
                for (CompletableFuture f : futures) {
                    f.cancel(true);
                }
                Log.info("Using fastest url: %s", fastest);
                String string = fastest;
                return string;
            }
            Log.info("All urls are unreachable, using CFPA_ASSET_ROOT");
            String string = CFPA_ASSET_ROOT;
            return string;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static String testUrlConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod("HEAD");
        conn.setConnectTimeout(3000);
        conn.setReadTimeout(5000);
        conn.connect();
        int code = conn.getResponseCode();
        if (code >= 200 && code < 300) {
            return url;
        }
        Log.debug("URL unreachable: %s, code: %d", url, code);
        throw new IOException("URL unreachable: " + url);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Map<String, String> getGitIndex() {
        try {
            URL index_url = new URL("https://raw.githubusercontent.com/CFPAOrg/Minecraft-Mod-Language-Package/refs/heads/index/version-index.json");
            HttpURLConnection httpConn = (HttpURLConnection)index_url.openConnection();
            httpConn.setRequestMethod("GET");
            httpConn.setConnectTimeout(5000);
            httpConn.setReadTimeout(5000);
            try {
                Map map;
                try (InputStreamReader reader = new InputStreamReader(httpConn.getInputStream());){
                    Type mapType = new TypeToken<Map<String, String>>(){}.getType();
                    map = (Map)new Gson().fromJson((Reader)reader, mapType);
                }
                return map;
            }
            finally {
                httpConn.disconnect();
            }
        }
        catch (Exception ignore) {
            return new HashMap<String, String>();
        }
    }

    static {
        MIRRORS.add("https://raw.githubusercontent.com/");
        MIRRORS.add("http://8.137.167.65:64684/");
    }
}

