/*
 * Decompiled with CFR 0.152.
 */
package net.fiv.actor;

import akka.actor.AbstractActor;
import akka.actor.Props;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.fiv.BorukvaInventoryBackup;
import net.fiv.actor.BActorMessages;
import net.fiv.actor.SQLExceptionWrapper;
import net.fiv.config.ModConfigs;
import net.fiv.data_base.BorukvaInventoryBackupDB;
import net.fiv.data_base.entities.DeathTable;
import net.fiv.data_base.entities.LoginTable;
import net.fiv.data_base.entities.LogoutTable;
import net.fiv.data_base.entities.PreRestoreTable;
import net.fiv.gui.DeathHistoryGui;
import net.fiv.gui.InventoryGui;
import net.fiv.gui.LoginHistoryGui;
import net.fiv.gui.LogoutHistoryGui;
import net.fiv.gui.PreRestoreGui;
import net.fiv.gui.TableListGui;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DatabaseManagerActor
extends AbstractActor {
    private static BorukvaInventoryBackupDB borukvaInventoryBackupDB;

    public static Props props() {
        return Props.create(DatabaseManagerActor.class, (Object[])new Object[0]);
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(BActorMessages.SavePlayerDataOnPlayerDeath.class, this::onPlayerDeath).match(BActorMessages.SavePlayerDataOnPlayerConnect.class, this::onPlayerConnect).match(BActorMessages.SavePlayerDataOnPlayerLogout.class, this::onPlayerLogout).match(BActorMessages.SavePlayerDataOnPlayerRestore.class, this::onPlayerRestore).match(BActorMessages.SavePlayerDataOnPlayerRestoreNbt.class, this::onPlayerRestoreNbt).match(BActorMessages.GetDeathTableMap.class, this::getDeathTableMap).match(BActorMessages.GetLogoutTableMap.class, this::getLogoutTableMap).match(BActorMessages.GetLoginTableMap.class, this::getLoginTableMap).match(BActorMessages.GetPreRestoreTableMap.class, this::getPreRestoreTableMap).match(BActorMessages.GetInventoryHistory.class, this::getInventoryHistory).match(BActorMessages.InitializeDatabase.class, this::initializeDatabase).build();
    }

    private void initializeDatabase(BActorMessages.InitializeDatabase msg) {
        try {
            String dbType = ModConfigs.getCONFIG().getOrDefault("key.borukvaInventoryBackup.DATABASE", "H2");
            if ("h2".equalsIgnoreCase(dbType)) {
                borukvaInventoryBackupDB = new BorukvaInventoryBackupDB();
            } else {
                String url = ModConfigs.getCONFIG().getOrDefault("key.borukvaInventoryBackup.DB_URL", "");
                String user = ModConfigs.getCONFIG().getOrDefault("key.borukvaInventoryBackup.DB_USER", "");
                String password = ModConfigs.getCONFIG().getOrDefault("key.borukvaInventoryBackup.DB_PASSWORD", "");
                borukvaInventoryBackupDB = new BorukvaInventoryBackupDB(url, user, password);
            }
            BorukvaInventoryBackup.LOGGER.info("DataBase file successfully initialized!");
        }
        catch (SQLException e) {
            BorukvaInventoryBackup.LOGGER.info("Fail connect to database!");
            throw new SQLExceptionWrapper(e);
        }
    }

    public void getInventoryHistory(BActorMessages.GetInventoryHistory msg) {
        CommandContext<class_2168> context = msg.context();
        try {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            String playerName = StringArgumentType.getString(context, (String)"player");
            if (!borukvaInventoryBackupDB.playerLoginTableExist(playerName)) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"There is no such player!").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
                return;
            }
            TableListGui tableListGui = new TableListGui(player, playerName);
            tableListGui.open();
        }
        catch (SQLException e) {
            BorukvaInventoryBackup.LOGGER.warn(e.getMessage());
            throw new SQLExceptionWrapper(e);
        }
    }

    private void onPlayerDeath(BActorMessages.SavePlayerDataOnPlayerDeath msg) {
        class_3222 player = msg.player();
        class_1282 source = msg.source();
        class_2371 inventory = player.method_31548().method_67533();
        List<class_1799> armor = List.of(player.method_31548().method_5438(36), player.method_31548().method_5438(37), player.method_31548().method_5438(38), player.method_31548().method_5438(39));
        class_2371 enderChest = player.method_7274().field_5828;
        ArrayList<class_1799> offHand = new ArrayList<class_1799>();
        offHand.add(player.method_6079());
        double x = player.method_23317();
        double y = player.method_23318();
        double z = player.method_23321();
        String name = player.method_5477().getString();
        String world = player.method_51469().method_27983().method_29177().toString();
        String place = "%.2f %.2f %.2f".formatted(x, y, z);
        String deathTime = LocalDateTime.now().toString();
        String formattedTime = deathTime.replace("T", " ").split("\\.")[0];
        String deathReason = source.method_5525();
        String inventr = InventoryGui.playerItems((List<class_1799>)inventory, (class_1657)player).toString();
        String armorString = InventoryGui.playerItems(armor, (class_1657)player).toString();
        String offHandString = InventoryGui.playerItems(offHand, (class_1657)player).toString();
        String enderChestString = InventoryGui.playerItems((List<class_1799>)enderChest, (class_1657)player).toString();
        int xp = player.field_7520;
        try {
            borukvaInventoryBackupDB.addDataDeath(name, world, place, formattedTime, deathReason, inventr, armorString, offHandString, enderChestString, xp);
        }
        catch (SQLException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private void onPlayerConnect(BActorMessages.SavePlayerDataOnPlayerConnect msg) {
        class_3222 player = msg.player();
        class_2371 inventory = player.method_31548().method_67533();
        List<class_1799> armor = List.of(player.method_31548().method_5438(36), player.method_31548().method_5438(37), player.method_31548().method_5438(38), player.method_31548().method_5438(39));
        class_2371 enderChest = player.method_7274().field_5828;
        ArrayList<class_1799> offHand = new ArrayList<class_1799>();
        offHand.add(player.method_6079());
        double x = player.method_23317();
        double y = player.method_23318();
        double z = player.method_23321();
        String place = "%.2f %.2f %.2f".formatted(x, y, z);
        String name = player.method_5477().getString();
        String world = player.method_51469().method_27983().method_29177().toString();
        String loginTime = LocalDateTime.now().toString();
        String formattedTime = loginTime.replace("T", " ").split("\\.")[0];
        String inventr = InventoryGui.playerItems((List<class_1799>)inventory, (class_1657)player).toString();
        String armorString = InventoryGui.playerItems(armor, (class_1657)player).toString();
        String offHandString = InventoryGui.playerItems(offHand, (class_1657)player).toString();
        String enderChestString = InventoryGui.playerItems((List<class_1799>)enderChest, (class_1657)player).toString();
        int xp = player.field_7520;
        try {
            borukvaInventoryBackupDB.addDataLogin(name, world, place, formattedTime, inventr, armorString, offHandString, enderChestString, xp);
        }
        catch (SQLException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private void onPlayerLogout(BActorMessages.SavePlayerDataOnPlayerLogout msg) {
        class_3222 player = msg.player();
        class_2371 inventory = player.method_31548().method_67533();
        List<class_1799> armor = List.of(player.method_31548().method_5438(36), player.method_31548().method_5438(37), player.method_31548().method_5438(38), player.method_31548().method_5438(39));
        class_2371 enderChest = player.method_7274().field_5828;
        ArrayList<class_1799> offHand = new ArrayList<class_1799>();
        offHand.add(player.method_6079());
        double x = player.method_23317();
        double y = player.method_23318();
        double z = player.method_23321();
        String place = "%.2f %.2f %.2f".formatted(x, y, z);
        String name = player.method_5477().getString();
        String world = player.method_51469().method_27983().method_29177().toString();
        String logoutTime = LocalDateTime.now().toString();
        String formattedTime = logoutTime.replace("T", " ").split("\\.")[0];
        String inventr = InventoryGui.playerItems((List<class_1799>)inventory, (class_1657)player).toString();
        String armorString = InventoryGui.playerItems(armor, (class_1657)player).toString();
        String offHandString = InventoryGui.playerItems(offHand, (class_1657)player).toString();
        String enderChestString = InventoryGui.playerItems((List<class_1799>)enderChest, (class_1657)player).toString();
        int xp = player.field_7520;
        try {
            borukvaInventoryBackupDB.addDataLogout(name, world, place, formattedTime, inventr, armorString, offHandString, enderChestString, xp);
        }
        catch (SQLException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private void onPlayerRestore(BActorMessages.SavePlayerDataOnPlayerRestore msg) {
        String restoreTime = LocalDateTime.now().toString();
        String formattedTime = restoreTime.replace("T", " ").split("\\.")[0];
        try {
            borukvaInventoryBackupDB.addDataPreRestore(msg.playerName(), formattedTime, msg.inventory(), msg.armor(), msg.offHand(), msg.enderChest(), msg.isInventory(), msg.xp());
        }
        catch (SQLException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private void onPlayerRestoreNbt(BActorMessages.SavePlayerDataOnPlayerRestoreNbt msg) {
        class_2499 mainInventory = new class_2499();
        class_2499 armor = new class_2499();
        class_2499 offHand = new class_2499();
        for (class_2520 nbtElement : msg.inventory()) {
            class_2487 itemNbt = (class_2487)nbtElement;
            Optional slotOpt = itemNbt.method_10571("Slot");
            if (!slotOpt.isPresent()) continue;
            byte slot = (Byte)slotOpt.get();
            if (slot >= 100) {
                armor.add((Object)itemNbt);
                continue;
            }
            if (slot >= -106) {
                offHand.add((Object)itemNbt);
                continue;
            }
            mainInventory.add((Object)itemNbt);
        }
        String restoreTime = LocalDateTime.now().toString();
        String formattedTime = restoreTime.replace("T", " ").split("\\.")[0];
        try {
            borukvaInventoryBackupDB.addDataPreRestore(msg.playerName(), formattedTime, mainInventory.toString(), armor.toString(), offHand.toString(), msg.enderChest().toString(), msg.isInventory(), msg.xp());
        }
        catch (SQLException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    public void getDeathTableMap(BActorMessages.GetDeathTableMap msg) {
        class_3222 player = msg.player();
        String playerName = msg.playerName();
        try {
            List<DeathTable> deathTableList = borukvaInventoryBackupDB.getDeathData(playerName);
            if (deathTableList == null) {
                player.method_64398((class_2561)class_2561.method_43470((String)"There are no records of this player in the death database!"));
            } else {
                new DeathHistoryGui(player, 0, deathTableList).open();
            }
        }
        catch (SQLException e) {
            BorukvaInventoryBackup.LOGGER.info(e.getMessage());
            throw new SQLExceptionWrapper(e);
        }
    }

    public void getLogoutTableMap(BActorMessages.GetLogoutTableMap msg) {
        class_3222 player = msg.player();
        String playerName = msg.playerName();
        try {
            List<LogoutTable> logoutTableList = borukvaInventoryBackupDB.getLogoutData(playerName);
            if (logoutTableList == null) {
                player.method_64398((class_2561)class_2561.method_43470((String)"There are no records of this player in the logout database!"));
            } else {
                new LogoutHistoryGui(player, 0, logoutTableList).open();
            }
        }
        catch (SQLException e) {
            BorukvaInventoryBackup.LOGGER.info(e.getMessage());
            throw new SQLExceptionWrapper(e);
        }
    }

    public void getLoginTableMap(BActorMessages.GetLoginTableMap msg) {
        class_3222 player = msg.player();
        String playerName = msg.playerName();
        try {
            List<LoginTable> loginTableList = borukvaInventoryBackupDB.getLoginData(playerName);
            new LoginHistoryGui(player, 0, loginTableList).open();
        }
        catch (SQLException e) {
            BorukvaInventoryBackup.LOGGER.info(e.getMessage());
            throw new SQLExceptionWrapper(e);
        }
    }

    public void getPreRestoreTableMap(BActorMessages.GetPreRestoreTableMap msg) {
        class_3222 player = msg.player();
        String playerName = msg.playerName();
        try {
            List<PreRestoreTable> preRestoreTableList = borukvaInventoryBackupDB.getPreRestoreData(playerName);
            if (preRestoreTableList == null) {
                player.method_64398((class_2561)class_2561.method_43470((String)"There are no records of this player in the pre_restore database!"));
            } else {
                new PreRestoreGui(player, 0, preRestoreTableList).open();
            }
        }
        catch (SQLException e) {
            BorukvaInventoryBackup.LOGGER.info(e.getMessage());
            throw new SQLExceptionWrapper(e);
        }
    }

    @Generated
    public static BorukvaInventoryBackupDB getBorukvaInventoryBackupDB() {
        return borukvaInventoryBackupDB;
    }
}

