/*
 * Decompiled with CFR 0.152.
 */
package net.fiv.data_base;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import java.util.List;
import net.fiv.config.ModConfigs;
import net.fiv.data_base.entities.BaseEntity;
import net.fiv.data_base.entities.DeathTable;
import net.fiv.data_base.entities.LoginTable;
import net.fiv.data_base.entities.LogoutTable;
import net.fiv.data_base.entities.PreRestoreTable;

public class BorukvaInventoryBackupDB {
    private Dao<DeathTable, String> deathTableDao;
    private Dao<LoginTable, String> loginTableDao;
    private Dao<LogoutTable, String> logoutTableDao;
    private Dao<PreRestoreTable, String> preRestoreTableDao;
    private final JdbcConnectionSource connectionSource;

    public BorukvaInventoryBackupDB() throws SQLException {
        this.connectionSource = new JdbcConnectionSource("jdbc:h2:./borukva_inventory_backup");
        this.init();
        this.modifyTableForH2();
    }

    public BorukvaInventoryBackupDB(String url, String user, String password) throws SQLException {
        this.connectionSource = new JdbcConnectionSource("jdbc:mysql://" + url, user, password);
        this.init();
    }

    private void init() throws SQLException {
        TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, DeathTable.class);
        TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, LoginTable.class);
        TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, LogoutTable.class);
        TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, PreRestoreTable.class);
        this.deathTableDao = DaoManager.createDao((ConnectionSource)this.connectionSource, DeathTable.class);
        this.loginTableDao = DaoManager.createDao((ConnectionSource)this.connectionSource, LoginTable.class);
        this.logoutTableDao = DaoManager.createDao((ConnectionSource)this.connectionSource, LogoutTable.class);
        this.preRestoreTableDao = DaoManager.createDao((ConnectionSource)this.connectionSource, PreRestoreTable.class);
    }

    public void addDataDeath(String name, String world, String place, String date, String reason, String inventory, String armor, String offHand, String enderChest, int xp) throws SQLException {
        this.deleteOldestRecord(name, this.deathTableDao);
        DeathTable deathTable = new DeathTable(name, world, place, date, inventory, armor, offHand, enderChest, xp, reason);
        this.deathTableDao.create((Object)deathTable);
    }

    public void addDataLogin(String name, String world, String place, String date, String inventory, String armor, String offHand, String enderChest, int xp) throws SQLException {
        this.deleteOldestRecord(name, this.loginTableDao);
        LoginTable loginTable = new LoginTable(name, world, place, date, inventory, armor, offHand, enderChest, xp);
        this.loginTableDao.create((Object)loginTable);
    }

    public void addDataLogout(String name, String world, String place, String date, String inventory, String armor, String offHand, String enderChest, int xp) throws SQLException {
        this.deleteOldestRecord(name, this.logoutTableDao);
        LogoutTable logoutTable = new LogoutTable(name, world, place, date, inventory, armor, offHand, enderChest, xp);
        this.logoutTableDao.create((Object)logoutTable);
    }

    public void addDataPreRestore(String name, String date, String inventory, String armor, String offHand, String enderChest, boolean isInventory, int xp) throws SQLException {
        this.deleteOldestRecord(name, this.preRestoreTableDao);
        PreRestoreTable preRestoreTable = new PreRestoreTable(name, date, inventory, armor, offHand, enderChest, isInventory, xp);
        this.preRestoreTableDao.create((Object)preRestoreTable);
    }

    public List<DeathTable> getDeathData(String playerName) throws SQLException {
        List results = this.deathTableDao.queryForEq("name", (Object)playerName);
        if (results != null && !results.isEmpty()) {
            return results;
        }
        return null;
    }

    public List<LoginTable> getLoginData(String playerName) throws SQLException {
        List results = this.loginTableDao.queryForEq("name", (Object)playerName);
        if (results != null && !results.isEmpty()) {
            return results;
        }
        return null;
    }

    public List<LogoutTable> getLogoutData(String playerName) throws SQLException {
        List results = this.logoutTableDao.queryForEq("name", (Object)playerName);
        if (results != null && !results.isEmpty()) {
            return results;
        }
        return null;
    }

    public List<PreRestoreTable> getPreRestoreData(String playerName) throws SQLException {
        List results = this.preRestoreTableDao.queryForEq("name", (Object)playerName);
        if (results != null && !results.isEmpty()) {
            return results;
        }
        return null;
    }

    private <T extends BaseEntity> void deleteOldestRecord(String playerName, Dao<T, String> dao) throws SQLException {
        List results = dao.queryForEq("name", (Object)playerName);
        if (results != null && !results.isEmpty()) {
            int maxRecords = ModConfigs.getCONFIG().getOrDefault("key.borukvaInventoryBackup.MAX_RECORDS", 100);
            if (results.size() >= maxRecords) {
                int index = 0;
                for (int recordsForDelete = results.size() - maxRecords; recordsForDelete > 0; --recordsForDelete) {
                    BaseEntity oldestRecord = (BaseEntity)results.get(index);
                    dao.delete((Object)oldestRecord);
                    ++index;
                }
            }
        }
    }

    public boolean playerLoginTableExist(String playerName) throws SQLException {
        List results = this.loginTableDao.queryForEq("name", (Object)playerName);
        return results != null && !results.isEmpty();
    }

    private void modifyTableForH2() throws SQLException {
        String[] alterStatementsDeath = new String[]{"ALTER TABLE death_table ALTER COLUMN inventory VARCHAR(2000000);", "ALTER TABLE death_table ALTER COLUMN armor VARCHAR(1000000);", "ALTER TABLE death_table ALTER COLUMN offHand VARCHAR(300000);", "ALTER TABLE death_table ALTER COLUMN enderChest VARCHAR(2000000);"};
        String[] alterStatementsLogin = new String[]{"ALTER TABLE login_table ALTER COLUMN inventory VARCHAR(2000000);", "ALTER TABLE login_table ALTER COLUMN armor VARCHAR(1000000);", "ALTER TABLE login_table ALTER COLUMN offHand VARCHAR(300000);", "ALTER TABLE login_table ALTER COLUMN enderChest VARCHAR(2000000);"};
        String[] alterStatementsLogout = new String[]{"ALTER TABLE logout_table ALTER COLUMN inventory VARCHAR(2000000);", "ALTER TABLE logout_table ALTER COLUMN armor VARCHAR(1000000);", "ALTER TABLE logout_table ALTER COLUMN offHand VARCHAR(300000);", "ALTER TABLE logout_table ALTER COLUMN enderChest VARCHAR(2000000);"};
        String[] alterStatementsPreRestore = new String[]{"ALTER TABLE pre_restore_table ALTER COLUMN inventory VARCHAR(2000000);", "ALTER TABLE pre_restore_table ALTER COLUMN armor VARCHAR(1000000);", "ALTER TABLE pre_restore_table ALTER COLUMN offHand VARCHAR(300000);", "ALTER TABLE pre_restore_table ALTER COLUMN enderChest VARCHAR(2000000);"};
        for (String sql : alterStatementsDeath) {
            this.deathTableDao.executeRawNoArgs(sql);
        }
        for (String sql : alterStatementsLogin) {
            this.loginTableDao.executeRawNoArgs(sql);
        }
        for (String sql : alterStatementsLogout) {
            this.logoutTableDao.executeRawNoArgs(sql);
        }
        for (String sql : alterStatementsPreRestore) {
            this.preRestoreTableDao.executeRawNoArgs(sql);
        }
    }

    public void closeDbConnection() throws Exception {
        this.connectionSource.close();
    }
}

