/*
 * Decompiled with CFR 0.152.
 */
package net.fiv.gui;

import com.mojang.serialization.DynamicOps;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fiv.BorukvaInventoryBackup;
import net.fiv.gui.InventoryGui;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5218;
import net.minecraft.class_5250;

public class EnderChestGui
extends SimpleGui {
    public EnderChestGui(class_3222 player, String playerName, Map<Integer, class_1799> enderChestMap, SimpleGui caller) {
        super(class_3917.field_18666, player, false);
        this.addItems(enderChestMap, playerName, caller);
    }

    private void addItems(Map<Integer, class_1799> enderChestMap, String playerName, SimpleGui caller) {
        int i = 0;
        for (class_1799 item : enderChestMap.values()) {
            this.setSlot(i, (GuiElementInterface)new GuiElementBuilder(item).setCount(item.method_7947()).build());
            ++i;
        }
        this.setSlot(33, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8545).setName((class_2561)class_2561.method_43470((String)"Backup player items to the box").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})).setLore(new ArrayList<class_5250>(List.of(class_2561.method_43470((String)"clear your inventory before issuing").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})))).setCallback((index, type, action) -> {
            InventoryGui.backUpPlayerItemsToChest(enderChestMap, -1, this.player.method_5682().method_3760().method_14566(playerName), this.player);
            this.getPlayer().method_64398((class_2561)class_2561.method_43470((String)"You have successfully restored items to box!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
        }).build());
        this.setSlot(35, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8407).setName((class_2561)class_2561.method_43470((String)"Backup player ender chest(recovery will be irreversible)").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).setCallback((index, type, action) -> {
            UUID uuid = InventoryGui.getOfflinePlayerProfile(playerName, this.player.method_5682());
            if (this.player.method_5682().method_3760().method_14566(playerName) != null) {
                this.backUpPlayerItems(enderChestMap, this.player.method_5682().method_3760().method_14566(playerName));
                this.getPlayer().method_64398((class_2561)class_2561.method_43470((String)"You have successfully restored items to an online player!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            } else {
                this.saveOfflinePlayerEnderChest(uuid, enderChestMap, playerName);
                this.getPlayer().method_64398((class_2561)class_2561.method_43470((String)"You have successfully restored items to an offline player!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            }
        }).build());
        this.setSlot(27, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8687).setName((class_2561)class_2561.method_43470((String)"Return back")).setCallback((index, type, action) -> caller.open()).build());
    }

    private void backUpPlayerItems(Map<Integer, class_1799> itemStackMap, class_3222 player) {
        int index = 0;
        class_1730 enderChestInventory = player.method_7274();
        InventoryGui.savePreRestorePlayerInventory(player.method_5477().getString(), InventoryGui.playerItems((List<class_1799>)player.method_7274().field_5828, (class_1657)player).toString(), null, null, null, false, 0);
        enderChestInventory.method_5448();
        for (class_1799 itemStack : itemStackMap.values()) {
            enderChestInventory.method_5447(index, itemStack);
            ++index;
        }
    }

    private void saveOfflinePlayerEnderChest(UUID uuid, Map<Integer, class_1799> itemStackMap, String playerName) {
        File playerDataDir = this.player.method_5682().method_27050(class_5218.field_24182).toFile();
        try {
            File file2 = new File(playerDataDir, uuid.toString() + ".dat");
            class_2487 nbtCompound = class_2507.method_10629((InputStream)new FileInputStream(file2), (class_2505)class_2505.method_53898());
            class_2499 inventoryList = (class_2499)nbtCompound.method_10554("EnderItems").get();
            InventoryGui.savePreRestorePlayerInventory(playerName, inventoryList.toString(), null, null, null, false, 0);
            inventoryList.clear();
            int index = 0;
            for (class_1799 itemStack : itemStackMap.values()) {
                class_2487 nbt = InventoryGui.getItemStackNbt(itemStack, (DynamicOps<class_2520>)this.player.method_56673().method_57093((DynamicOps)class_2509.field_11560));
                nbt.method_10567("Slot", (byte)index);
                inventoryList.method_68586(index, (class_2520)nbt);
                ++index;
            }
            nbtCompound.method_10566("EnderItems", (class_2520)inventoryList);
            class_2507.method_30614((class_2487)nbtCompound, (Path)file2.toPath());
        }
        catch (Exception e) {
            BorukvaInventoryBackup.LOGGER.warn(e.getMessage());
        }
    }
}

