/*
 * Decompiled with CFR 0.152.
 */
package net.fiv.gui;

import akka.actor.ActorRef;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fiv.BorukvaInventoryBackup;
import net.fiv.actor.BActorMessages;
import net.fiv.gui.EnderChestGui;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3917;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_9326;
import net.minecraft.server.MinecraftServer;

public class InventoryGui
extends SimpleGui {
    public InventoryGui(class_3222 player, String playerName, Map<Integer, class_1799> itemStackMap, Map<Integer, class_1799> enderChestMap, int xp, SimpleGui caller) {
        super(class_3917.field_17327, player, false);
        this.addItems(itemStackMap, enderChestMap, xp, playerName, caller);
    }

    private void addItems(Map<Integer, class_1799> itemStackMap, Map<Integer, class_1799> enderChestMap, int xp, String playerName, SimpleGui caller) {
        int i = 0;
        for (class_1799 item : itemStackMap.values()) {
            this.setSlot(i, (GuiElementInterface)new GuiElementBuilder(item).setCount(item.method_7947()).build());
            ++i;
        }
        this.setSlot(53, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8407).setName((class_2561)class_2561.method_43470((String)"Backup player inventory(recovery will be irreversible)").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).setCallback((index, type, action) -> {
            UUID uuid = InventoryGui.getOfflinePlayerProfile(playerName, this.player.method_5682());
            if (this.player.method_5682().method_3760().method_14566(playerName) != null) {
                this.backUpPlayerItems(itemStackMap, xp, this.player.method_5682().method_3760().method_14566(playerName));
                this.getPlayer().method_64398((class_2561)class_2561.method_43470((String)"You have successfully restored items to an online player!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            } else {
                this.saveOfflinePlayerInventory(uuid, xp, itemStackMap, playerName);
                this.getPlayer().method_64398((class_2561)class_2561.method_43470((String)"You have successfully restored items to an offline player!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            }
        }).build());
        this.setSlot(51, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8545).setName((class_2561)class_2561.method_43470((String)"Backup player items to the box").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})).setLore(new ArrayList<class_5250>(List.of(class_2561.method_43470((String)"clear your inventory before issuing").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})))).setCallback((index, type, action) -> {
            InventoryGui.backUpPlayerItemsToChest(itemStackMap, xp, this.player.method_5682().method_3760().method_14566(playerName), this.player);
            this.getPlayer().method_64398((class_2561)class_2561.method_43470((String)"You have successfully restored items to box!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
        }).build());
        this.setSlot(47, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8466).setName((class_2561)class_2561.method_43470((String)"Player ender chest").method_27692(class_124.field_1064)).setCallback((index, type, action) -> new EnderChestGui(this.player, playerName, enderChestMap, this).open()).build());
        this.setSlot(46, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8287).setName((class_2561)class_2561.method_43470((String)("XP level: " + xp)).method_27692(class_124.field_1054)).build());
        this.setSlot(45, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8687).setName((class_2561)class_2561.method_43470((String)"Return back")).setCallback((index, type, action) -> caller.open()).build());
    }

    protected static void savePreRestorePlayerInventory(String playerName, String inventory, String armor, String offHand, String enderChest, boolean isInventory, int xp) {
        BorukvaInventoryBackup.getDatabaseManagerActor().tell((Object)new BActorMessages.SavePlayerDataOnPlayerRestore(playerName, inventory, armor, offHand, enderChest, isInventory, xp), ActorRef.noSender());
    }

    protected static void savePreRestorePlayerInventory(String playerName, class_2499 inventory, class_2499 enderChest, int xp) {
        BorukvaInventoryBackup.getDatabaseManagerActor().tell((Object)new BActorMessages.SavePlayerDataOnPlayerRestoreNbt(playerName, inventory, enderChest, true, xp), ActorRef.noSender());
    }

    public static UUID getOfflinePlayerProfile(String playerName, MinecraftServer server) {
        if (server == null) {
            return null;
        }
        class_3312 cache = server.method_3793();
        if (cache == null) {
            return null;
        }
        Optional optionalGameProfile = cache.method_14515(playerName);
        if (optionalGameProfile.isPresent()) {
            GameProfile gameProfile = (GameProfile)optionalGameProfile.get();
            return gameProfile.getId();
        }
        return null;
    }

    private void backUpPlayerItems(Map<Integer, class_1799> itemStackMap, int xp, class_3222 player) {
        int index = 0;
        class_1661 playerInventory = player.method_31548();
        List<class_1799> armor = List.of(player.method_31548().method_5438(36), player.method_31548().method_5438(37), player.method_31548().method_5438(38), player.method_31548().method_5438(39));
        InventoryGui.savePreRestorePlayerInventory(player.method_5477().getString(), InventoryGui.playerItems((List<class_1799>)playerInventory.method_67533(), (class_1657)player).toString(), InventoryGui.playerItems(armor, (class_1657)player).toString(), InventoryGui.playerItems(List.of(player.method_6079()), (class_1657)player).toString(), InventoryGui.playerItems((List<class_1799>)player.method_7274().field_5828, (class_1657)player).toString(), true, xp);
        playerInventory.method_5448();
        for (class_1799 itemStack : itemStackMap.values()) {
            if (index < 4) {
                playerInventory.method_5447(36 + index, itemStack);
            } else if (index == 4) {
                playerInventory.method_5447(40, itemStack);
            } else {
                playerInventory.method_5447(index - 5, itemStack);
            }
            ++index;
        }
        player.method_14252(xp);
    }

    private void saveOfflinePlayerInventory(UUID uuid, int xp, Map<Integer, class_1799> itemStackMap, String playerName) {
        File playerDataDir = this.player.method_5682().method_27050(class_5218.field_24182).toFile();
        try {
            File file2 = new File(playerDataDir, uuid.toString() + ".dat");
            class_2487 nbtCompound = class_2507.method_10629((InputStream)new FileInputStream(file2), (class_2505)class_2505.method_53898());
            class_2499 inventoryList = (class_2499)nbtCompound.method_10554("Inventory").get();
            class_2499 enderChestLists = (class_2499)nbtCompound.method_10554("EnderItems").get();
            InventoryGui.savePreRestorePlayerInventory(playerName, inventoryList, enderChestLists, xp);
            inventoryList.clear();
            int index = 0;
            for (class_1799 itemStack : itemStackMap.values()) {
                class_2487 nbt = InventoryGui.getItemStackNbt(itemStack, (DynamicOps<class_2520>)this.player.method_56673().method_57093((DynamicOps)class_2509.field_11560));
                byte slotByte = index < 4 ? (byte)(100 + index) : (index == 4 ? (byte)-106 : (byte)((byte)(index - 5)));
                nbt.method_10567("Slot", slotByte);
                inventoryList.method_68586(index, (class_2520)nbt);
                ++index;
            }
            nbtCompound.method_10566("Inventory", (class_2520)inventoryList);
            nbtCompound.method_10569("XpLevel", xp);
            class_2507.method_30614((class_2487)nbtCompound, (Path)file2.toPath());
        }
        catch (Exception e) {
            BorukvaInventoryBackup.LOGGER.warn(e.getMessage());
        }
    }

    public static class_2487 getItemStackNbt(class_1799 stack, DynamicOps<class_2520> ops) {
        DataResult result = class_9326.field_49589.encodeStart(ops, (Object)stack.method_57380());
        result.ifError(e -> {});
        class_2487 nbtCompound = new class_2487();
        class_2520 nbtElement = (class_2520)result.getOrThrow();
        if (nbtElement != null) {
            nbtCompound.method_10566("components", nbtElement);
        }
        nbtCompound.method_10569("count", stack.method_7947());
        nbtCompound.method_10582("id", stack.method_7909().toString());
        return nbtCompound;
    }

    public static ArrayList<String> playerItems(List<class_1799> inventory, class_1657 player) {
        ArrayList<String> playerItems = new ArrayList<String>();
        for (class_1799 itemStack : inventory) {
            class_2487 nbt = InventoryGui.getItemStackNbt(itemStack, (DynamicOps<class_2520>)player.method_56673().method_57093((DynamicOps)class_2509.field_11560));
            playerItems.add(nbt.toString());
        }
        return playerItems;
    }

    public static void backUpPlayerItemsToChest(Map<Integer, class_1799> itemStackMap, int xp, class_3222 player, class_3222 operatorPlayer) {
        class_1799 chest;
        ArrayList toRemove = new ArrayList();
        itemStackMap.forEach((index, item) -> {
            if (item.method_7909() == class_1802.field_8162) {
                toRemove.add(index);
            }
        });
        toRemove.forEach(itemStackMap::remove);
        List<class_1799> list = itemStackMap.values().stream().toList();
        if (itemStackMap.size() > 27) {
            chest = InventoryGui.createChestItem(list.subList(27, list.size()), player.method_5477().getString() + " second inventory", operatorPlayer);
            operatorPlayer.method_5775(operatorPlayer.method_51469(), chest);
        }
        chest = InventoryGui.createChestItem(list.subList(0, Math.min(27, list.size())), player.method_5477().getString() + " first inventory", operatorPlayer);
        operatorPlayer.method_5775(operatorPlayer.method_51469(), chest);
        if (xp != -1) {
            player.method_14252(xp);
        }
    }

    public static class_1799 createChestItem(List<class_1799> items, String name, class_3222 operatorPlayer) {
        class_2499 containerList = new class_2499();
        for (int i = 0; i < items.size(); ++i) {
            class_1799 stack = items.get(i);
            if (stack.method_7960()) continue;
            class_2487 slotTag = new class_2487();
            class_2487 nbt = InventoryGui.getItemStackNbt(stack, (DynamicOps<class_2520>)operatorPlayer.method_56673().method_57093((DynamicOps)class_2509.field_11560));
            slotTag.method_10566("item", (class_2520)nbt);
            slotTag.method_10569("slot", i);
            containerList.add((Object)slotTag);
        }
        class_2487 components = new class_2487();
        components.method_10566("minecraft:container", (class_2520)containerList);
        components.method_10582("minecraft:item_name", "{\"text\":\"" + name + "\"}");
        class_2487 blockEntityTag = new class_2487();
        blockEntityTag.method_10566("components", (class_2520)components);
        blockEntityTag.method_10569("count", 1);
        blockEntityTag.method_10582("id", "minecraft:chest");
        return (class_1799)class_1799.field_24671.parse((DynamicOps)operatorPlayer.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)blockEntityTag).getOrThrow();
    }
}

