/*
 * Decompiled with CFR 0.152.
 */
package net.fiv.gui;

import com.mojang.serialization.DynamicOps;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.fiv.BorukvaInventoryBackup;
import net.fiv.commands.GetInventoryHistoryCommand;
import net.fiv.util.InventorySerializer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7923;

public class TableListGui
extends SimpleGui {
    public TableListGui(class_3222 player, String playerName) {
        super(class_3917.field_18664, player, false);
        this.setTitle((class_2561)class_2561.method_43470((String)(playerName + "'s tables list")));
        this.addButtons(playerName);
    }

    private void addButtons(String playerName) {
        this.setSlot(2, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8106).setName((class_2561)class_2561.method_43470((String)"Login history").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})).setCallback((index, type, action) -> GetInventoryHistoryCommand.getLoginTableMap(this.player, playerName)).build());
        this.setSlot(3, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8106).setName((class_2561)class_2561.method_43470((String)"Logout history").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})).setCallback((index, type, action) -> GetInventoryHistoryCommand.getLogoutTableMap(this.player, playerName)).build());
        this.setSlot(5, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8106).setName((class_2561)class_2561.method_43470((String)"Death history").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).setCallback((index, type, action) -> GetInventoryHistoryCommand.getDeathTableMap(this.player, playerName)).build());
        this.setSlot(6, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8106).setName((class_2561)class_2561.method_43470((String)"Backups history").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).setCallback((index, type, action) -> GetInventoryHistoryCommand.getPreRestoreTableMap(this.player, playerName)).build());
    }

    protected static Map<Integer, class_1799> inventorySerialization(String inventory, String armor, String offHand, class_3222 player) {
        HashMap<Integer, class_1799> itemsToGive = new HashMap<Integer, class_1799>();
        class_3218 world = player.method_51469();
        class_2487 nbtCompoundArmor = InventorySerializer.deserializeInventory(armor);
        class_2499 nbtListArmor = (class_2499)nbtCompoundArmor.method_10554("Inventory").get();
        int index = 0;
        for (class_2520 nbtElement : nbtListArmor) {
            class_2487 itemNbt = (class_2487)nbtElement;
            class_1799 itemStack = !((String)itemNbt.method_10558("id").get()).equals("minecraft:air") ? (class_1799)class_1799.field_24671.parse((DynamicOps)world.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)itemNbt).getOrThrow() : (((String)itemNbt.method_10558("id").get()).equals("minecraft:air") ? new class_1799((class_1935)class_1802.field_8162) : new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60654((String)((String)itemNbt.method_10558("id").get()))), ((Integer)itemNbt.method_10550("Count").get()).intValue()));
            itemsToGive.put(index, itemStack);
            ++index;
        }
        class_2487 nbtCompoundOffHand = InventorySerializer.deserializeInventory(offHand);
        class_2499 nbtListOffHand = (class_2499)nbtCompoundOffHand.method_10554("Inventory").get();
        for (class_2520 nbtElement : nbtListOffHand) {
            class_2487 itemNbt = (class_2487)nbtElement;
            class_1799 itemStack = !((String)itemNbt.method_10558("id").get()).equals("minecraft:air") ? (class_1799)class_1799.field_24671.parse((DynamicOps)world.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)itemNbt).getOrThrow() : (((String)itemNbt.method_10558("id").get()).equals("minecraft:air") ? new class_1799((class_1935)class_1802.field_8162) : new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60654((String)((String)itemNbt.method_10558("id").get()))), ((Integer)itemNbt.method_10550("Count").get()).intValue()));
            itemsToGive.put(index, itemStack);
            ++index;
        }
        class_2487 nbtCompoundInventory = InventorySerializer.deserializeInventory(inventory);
        class_2499 nbtListInventory = (class_2499)nbtCompoundInventory.method_10554("Inventory").get();
        for (class_2520 nbtElement : nbtListInventory) {
            class_2487 itemNbt = (class_2487)nbtElement;
            class_1799 itemStack = !((String)itemNbt.method_10558("id").get()).equals("minecraft:air") ? (class_1799)class_1799.field_24671.parse((DynamicOps)world.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)itemNbt).getOrThrow() : (((String)itemNbt.method_10558("id").get()).equals("minecraft:air") ? new class_1799((class_1935)class_1802.field_8162) : new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60654((String)((String)itemNbt.method_10558("id").get()))), ((Integer)itemNbt.method_10550("Count").get()).intValue()));
            itemsToGive.put(index, itemStack);
            ++index;
        }
        return itemsToGive;
    }

    protected static Map<Integer, class_1799> inventorySerialization(String enderChest, class_3222 player) {
        try {
            class_3218 world = player.method_51469();
            class_2487 nbtCompound = InventorySerializer.deserializeInventory(enderChest);
            class_2499 inventoryList = (class_2499)nbtCompound.method_10554("Inventory").orElseThrow(() -> new IllegalArgumentException("No Inventory tag found"));
            AtomicInteger index = new AtomicInteger(0);
            return inventoryList.stream().map(el -> el.method_68571().orElse(null)).filter(Objects::nonNull).map(arg_0 -> TableListGui.lambda$inventorySerialization$6((class_1937)world, index, arg_0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (Exception e) {
            BorukvaInventoryBackup.LOGGER.error("Exception when try to serialize ender chest: " + e.getMessage());
            return Collections.emptyMap();
        }
    }

    private static String getStringOr(class_2487 nbt, String key, String def) {
        return nbt.method_10558(key).orElse(def);
    }

    private static int getIntOr(class_2487 nbt, String key, int def) {
        return nbt.method_10550(key).orElse(def);
    }

    private static /* synthetic */ Map.Entry lambda$inventorySerialization$6(class_1937 world, AtomicInteger index, class_2487 itemNbt) {
        String id = TableListGui.getStringOr(itemNbt, "id", "minecraft:air");
        int count = TableListGui.getIntOr(itemNbt, "Count", 1);
        class_1799 stack = !id.equals("minecraft:air") ? (class_1799)class_1799.field_24671.parse((DynamicOps)world.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)itemNbt).getOrThrow() : new class_1799((class_1935)class_1802.field_8162, count);
        return Map.entry(index.getAndIncrement(), stack);
    }
}

