/*
 * Decompiled with CFR 0.152.
 */
package net.phie.tutorialmod;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.phie.tutorialmod.block.ModBlocks;
import net.phie.tutorialmod.event.PlayerHungerHandler;
import net.phie.tutorialmod.event.RunesHandler;
import net.phie.tutorialmod.event.TooltipHandler;
import net.phie.tutorialmod.item.ModItemGroups;
import net.phie.tutorialmod.item.ModItems;
import net.phie.tutorialmod.loot.GlobalLootModifier;
import net.phie.tutorialmod.world.gen.ModWorldGeneration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TutorialMod
implements ModInitializer {
    public static final String MOD_ID = "tutorialmod";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tutorialmod");
    private static final class_6862<class_2248> LOG_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("minecraft", "logs"));
    private static final class_6862<class_2248> LEAF_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("minecraft", "leaves"));
    private static final class_6862<class_2248> DIGGABLE_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("minecraft", "mineable/shovel"));
    public static final class_6862<class_2248> ORES_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("minecraft", "ores"));

    public void onInitialize() {
        ModItemGroups.registerItemGroups();
        ModItems.registerModItems();
        ModBlocks.registerModBlocks();
        ModWorldGeneration.generateModWorldGen();
        GlobalLootModifier.register();
        RunesHandler.register();
        PlayerHungerHandler.register();
        TooltipHandler.register();
        LOGGER.info("Tutorial Mod Initialized!");
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (!world.method_8608() && world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                this.handleBlockBreak(serverWorld, player, pos, state);
            }
        });
    }

    private void handleBlockBreak(class_3218 world, class_1657 player, class_2338 pos, class_2680 state) {
        if (player.method_6047().method_7909() == ModItems.NIHILITE_PICKAXE) {
            this.handleNihilitePickaxe(world, player, pos);
        } else if (player.method_6047().method_7909() == ModItems.NIHILITE_SHOVEL) {
            this.handleNihiliteShovel(world, player, pos);
        } else if (player.method_6047().method_7909() == ModItems.NIHILITE_AXE && this.isLog(state)) {
            this.handleNihiliteAxe(world, player, pos);
        }
    }

    private void handleNihilitePickaxe(class_3218 world, class_1657 player, class_2338 pos) {
        class_2338 nearestOre = this.findNearestBlock(world, pos, 2, this::isOre);
        if (nearestOre != null) {
            this.createParticlePath(world, pos, nearestOre);
        }
    }

    private void handleNihiliteShovel(class_3218 world, class_1657 player, class_2338 center) {
        this.iterateBlockArea(center, 1, targetPos -> {
            class_2680 targetState = world.method_8320(targetPos);
            if (this.isDiggable(targetState) && !targetState.method_26215()) {
                world.method_8651(targetPos, true, (class_1297)player);
            }
        });
    }

    private void handleNihiliteAxe(class_3218 world, class_1657 player, class_2338 center) {
        this.iterateBlockArea(center, 3, targetPos -> {
            class_2680 targetState = world.method_8320(targetPos);
            if (this.isLeaf(targetState)) {
                world.method_8651(targetPos, true, (class_1297)player);
            }
        });
    }

    private class_2338 findNearestBlock(class_3218 world, class_2338 start, int radius, Predicate<class_2680> condition) {
        class_2338 nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_2338 currentPos : class_2338.method_25996((class_2338)start, (int)radius, (int)radius, (int)radius)) {
            double distance;
            class_2680 currentState = world.method_8320(currentPos);
            if (!condition.test(currentState) || !((distance = start.method_10262((class_2382)currentPos)) < nearestDistance)) continue;
            nearest = currentPos;
            nearestDistance = distance;
        }
        return nearest;
    }

    private void iterateBlockArea(class_2338 center, int radius, Consumer<class_2338> action) {
        class_2338.method_10097((class_2338)center.method_10069(-radius, -radius, -radius), (class_2338)center.method_10069(radius, radius, radius)).forEach(action);
    }

    private void createParticlePath(class_3218 world, class_2338 start, class_2338 end) {
        class_243 startVec = class_243.method_24953((class_2382)start);
        class_243 endVec = class_243.method_24953((class_2382)end);
        class_243 direction = endVec.method_1020(startVec).method_1029();
        double distance = startVec.method_1022(endVec);
        for (double i = 0.0; i < distance; i += 0.5) {
            class_243 particlePos = startVec.method_1019(direction.method_1021(i));
            world.method_14199((class_2394)class_2398.field_11207, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private boolean isOre(class_2680 state) {
        return state.method_26164(ORES_TAG) || state.method_26204() == ModBlocks.RAW_NIHILITE_BLOCK;
    }

    private boolean isLog(class_2680 state) {
        return state.method_26164(LOG_TAG);
    }

    private boolean isLeaf(class_2680 state) {
        return state.method_26164(LEAF_TAG);
    }

    private boolean isDiggable(class_2680 state) {
        return state.method_26164(DIGGABLE_TAG);
    }
}

