/*
 * Decompiled with CFR 0.152.
 */
package net.phie.tutorialmod.item;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.phie.tutorialmod.TutorialMod;
import net.phie.tutorialmod.block.ModBlocks;

public class NihilitePickaxeItem
extends class_1810 {
    private static final int[] LEVEL_THRESHOLDS = new int[]{0, 25, 60, 120, 200, 300, 450, 650, 900, 1200};
    private static final float[] LEVEL_SPEEDS = new float[]{10.0f, 10.5f, 11.0f, 12.0f, 13.0f, 14.5f, 16.0f, 17.5f, 19.0f, 20.0f};

    public NihilitePickaxeItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    private boolean isOre(class_2680 state) {
        return state.method_26164(TutorialMod.ORES_TAG) || state.method_26204() == ModBlocks.RAW_NIHILITE_BLOCK;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!world.field_9236 && miner instanceof class_1657) {
            class_1657 player = (class_1657)miner;
            if (this.isOre(state)) {
                class_2487 nbt = stack.method_7948();
                int oresMined = nbt.method_10550("OresMined") + 1;
                nbt.method_10569("OresMined", oresMined);
                int currentLevel = NihilitePickaxeItem.calculateLevel(oresMined - 1);
                int newLevel = NihilitePickaxeItem.calculateLevel(oresMined);
                if (newLevel > currentLevel) {
                    world.method_8396(null, player.method_24515(), class_3417.field_14709, class_3419.field_15248, 1.0f, 0.5f);
                    player.method_7353((class_2561)class_2561.method_43470((String)("Your Nihilite Pickaxe is now Level " + newLevel + "!")).method_27692(class_124.field_1060), true);
                }
            }
        }
        return super.method_7879(stack, world, state, pos, miner);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        int level = NihilitePickaxeItem.getLevel(stack);
        return level > 0 && level <= LEVEL_SPEEDS.length ? LEVEL_SPEEDS[level - 1] : 10.0f;
    }

    public static int getLevel(class_1799 stack) {
        if (stack.method_7969() == null || !stack.method_7969().method_10545("OresMined")) {
            return 1;
        }
        int oresMined = stack.method_7969().method_10550("OresMined");
        return NihilitePickaxeItem.calculateLevel(oresMined);
    }

    private static int calculateLevel(int oresMined) {
        for (int i = LEVEL_THRESHOLDS.length - 1; i >= 0; --i) {
            if (oresMined < LEVEL_THRESHOLDS[i]) continue;
            return i + 1;
        }
        return 1;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int currentLevel;
        int oresMined = stack.method_7969() != null ? stack.method_7969().method_10550("OresMined") : 0;
        int nextLevelIndex = currentLevel = NihilitePickaxeItem.calculateLevel(oresMined);
        String oresProgress = nextLevelIndex < LEVEL_THRESHOLDS.length ? oresMined + " / " + LEVEL_THRESHOLDS[nextLevelIndex] : "" + oresMined;
        tooltip.add((class_2561)class_2561.method_43470((String)("Level: " + currentLevel)).method_27692(class_124.field_1075));
        tooltip.add((class_2561)class_2561.method_43470((String)("Ores Mined: " + oresProgress)).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43470((String)("Mining Speed: " + this.method_7865(stack, null))).method_27692(class_124.field_1065));
        super.method_7851(stack, world, tooltip, context);
    }
}

