/*
 * Decompiled with CFR 0.152.
 */
package net.phie.tutorialmod.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class NihiliteSwordItem
extends class_1829 {
    private static final int[] LEVEL_THRESHOLDS = new int[]{0, 25, 75, 150, 300, 500, 750, 1000, 1250, 1500};
    private static final float[] DAMAGE_BONUSES = new float[]{0.0f, 0.5f, 1.0f, 1.5f, 2.5f, 4.0f, 5.5f, 7.0f, 8.5f, 10.0f};

    public NihiliteSwordItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            if (this.isHostileMob(target)) {
                class_2487 nbt = stack.method_7948();
                int xp = nbt.method_10550("MobXP") + 1;
                nbt.method_10569("MobXP", xp);
                int currentLevel = NihiliteSwordItem.calculateLevel(xp - 1);
                int newLevel = NihiliteSwordItem.calculateLevel(xp);
                if (newLevel > currentLevel) {
                    player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14709, class_3419.field_15248, 1.0f, 0.5f);
                    player.method_7353((class_2561)class_2561.method_43470((String)("Your Nihilite Sword is now Level " + newLevel + "!")).method_27692(class_124.field_1060), true);
                }
            }
            if ((double)player.method_37908().method_8409().method_43057() < 0.1 && !target.method_37908().method_8608()) {
                class_1538 lightning = (class_1538)class_1299.field_6112.method_5883(target.method_37908());
                Objects.requireNonNull(lightning).method_29495(target.method_19538());
                target.method_37908().method_8649((class_1297)lightning);
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public boolean method_24357(class_1282 source) {
        return super.method_24357(source);
    }

    private boolean isHostileMob(class_1309 entity) {
        return entity.method_5864() == class_1299.field_6051 || entity.method_5864() == class_1299.field_6137 || entity.method_5864() == class_1299.field_6046 || entity.method_5864() == class_1299.field_6079 || entity.method_5864() == class_1299.field_6091 || entity.method_5864() == class_1299.field_6099 || entity.method_5864() == class_1299.field_6076 || entity.method_5864() == class_1299.field_6050 || entity.method_5864() == class_1299.field_6078 || entity.method_5864() == class_1299.field_6069 || entity.method_5864() == class_1299.field_6102 || entity.method_5864() == class_1299.field_6123 || entity.method_5864() == class_1299.field_6107 || entity.method_5864() == class_1299.field_6071 || entity.method_5864() == class_1299.field_6105 || entity.method_5864() == class_1299.field_6134 || entity.method_5864() == class_1299.field_6145 || entity.method_5864() == class_1299.field_6119 || entity.method_5864() == class_1299.field_6090 || entity.method_5864() == class_1299.field_6117 || entity.method_5864() == class_1299.field_6059 || entity.method_5864() == class_1299.field_6118 || entity.method_5864() == class_1299.field_6086;
    }

    public static int getLevel(class_1799 stack) {
        if (stack.method_7969() == null || !stack.method_7969().method_10545("MobXP")) {
            return 1;
        }
        int xp = stack.method_7969().method_10550("MobXP");
        return NihiliteSwordItem.calculateLevel(xp);
    }

    private static int calculateLevel(int xp) {
        for (int i = LEVEL_THRESHOLDS.length - 1; i >= 0; --i) {
            if (xp < LEVEL_THRESHOLDS[i]) continue;
            return i + 1;
        }
        return 1;
    }

    public float method_8020() {
        return super.method_8020() + NihiliteSwordItem.getBonusDamage(this.method_7854());
    }

    private static float getBonusDamage(class_1799 stack) {
        int level = NihiliteSwordItem.getLevel(stack);
        return level > 0 && level <= DAMAGE_BONUSES.length ? DAMAGE_BONUSES[level - 1] : 0.0f;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int xp = stack.method_7969() != null ? stack.method_7969().method_10550("MobXP") : 0;
        int currentLevel = NihiliteSwordItem.calculateLevel(xp);
        String xpProgress = currentLevel < LEVEL_THRESHOLDS.length ? xp + " / " + LEVEL_THRESHOLDS[currentLevel] : "" + xp;
        tooltip.add((class_2561)class_2561.method_43470((String)("Level: " + currentLevel)).method_27692(class_124.field_1075));
        tooltip.add((class_2561)class_2561.method_43470((String)("Monsters hit : " + xpProgress)).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43470((String)("Bonus Damage: +" + NihiliteSwordItem.getBonusDamage(stack))).method_27692(class_124.field_1061));
        super.method_7851(stack, world, tooltip, context);
    }
}

