/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.toms_mobs.util;

import de.tomalbrc.bil.core.component.AnimationComponent;
import de.tomalbrc.bil.core.holder.entity.living.LivingEntityHolder;
import de.tomalbrc.bil.core.holder.wrapper.DisplayWrapper;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Pose;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SimpleMovementRotatingHolder<T extends class_1309>
extends LivingEntityHolder<T> {
    private float lastYaw = 0.0f;
    private float lastPitch = 0.0f;

    public SimpleMovementRotatingHolder(T parent, Model model) {
        super(parent, model);
    }

    protected void applyPose(class_3222 serverPlayer, Pose pose, DisplayWrapper<?> display) {
        Vector3f translation = new Vector3f(0.0f, -0.1f, 0.0f);
        Matrix4f matrix4f = new Matrix4f().translate((Vector3fc)translation);
        Vector3f movement = ((class_1309)this.parent).method_18798().method_46409();
        if (movement.lengthSquared() > 1.0E-4f) {
            movement.normalize();
            float movementYaw = (float)Math.atan2(-movement.x, movement.z);
            float movementPitch = (float)Math.asin(movement.y);
            this.lastPitch = class_3532.method_61345((float)0.5f, (float)movementPitch, (float)this.lastPitch);
            this.lastYaw = class_3532.method_61345((float)0.5f, (float)movementYaw, (float)this.lastYaw);
            matrix4f.rotateLocalZ(0.0f).rotateLocalX(this.lastPitch).rotateLocalY(-this.lastYaw + (float)Math.PI);
            display.element().setTransformation(serverPlayer, matrix4f);
            display.element().startInterpolationIfDirty(serverPlayer);
        }
    }

    public void updateElement(class_3222 serverPlayer, DisplayWrapper<?> display, @Nullable Pose pose) {
        if (pose == null) {
            this.applyPose(serverPlayer, display.getLastPose(serverPlayer), display);
        } else {
            this.applyPose(serverPlayer, pose, display);
        }
    }

    protected void updateElement(class_3222 serverPlayer, DisplayWrapper<?> display) {
        AnimationComponent.PoseQueryResult queryResult = this.animationComponent.findPose(serverPlayer, display);
        if (queryResult != null) {
            if (queryResult.owner() != serverPlayer && display.element().getDataTracker().isDirty()) {
                return;
            }
            this.updateElement(queryResult.owner(), display, queryResult.pose());
        } else {
            this.updateElement(null, display, display.getDefaultPose());
        }
    }
}

