/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.toms_mobs.entity.goal;

import de.tomalbrc.toms_mobs.entity.goal.AnimatedGoal;
import de.tomalbrc.toms_mobs.entity.hostile.IceSpike;
import de.tomalbrc.toms_mobs.entity.hostile.IceSpikeSmall;
import de.tomalbrc.toms_mobs.entity.hostile.Iceologer;
import de.tomalbrc.toms_mobs.registry.MobRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class IceSpikeGoal
extends AnimatedGoal {
    @Nullable
    private class_1309 target;
    private final class_1308 mob;
    private int count = 0;

    public IceSpikeGoal(class_1588 monster) {
        super(100, 35, 20);
        this.mob = monster;
    }

    @Override
    public boolean method_6264() {
        --this.goalUseDelay;
        class_1309 livingEntity = this.mob.method_5968();
        return super.method_6264() && livingEntity != null && livingEntity.method_5805() && livingEntity.method_5858((class_1297)this.mob) < 11.0;
    }

    @Override
    public boolean method_6266() {
        return super.method_6266() || this.count > 0;
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.mob.method_5942().method_6340();
        this.target = this.mob.method_5968();
        class_1308 class_13082 = this.mob;
        if (class_13082 instanceof Iceologer) {
            Iceologer iceologer = (Iceologer)class_13082;
            iceologer.animate("summon_spikes");
        }
        this.count = 1;
    }

    @Override
    public void method_6270() {
        super.method_6270();
        this.target = null;
    }

    @Override
    public void method_6268() {
        this.mob.method_5942().method_6340();
        super.method_6268();
    }

    @Override
    protected void customTick() {
        if (!this.hasWarmupDelay() && this.count > 0) {
            this.mob.method_5942().method_6340();
            --this.count;
            this.performSpellCasting();
        }
    }

    protected void performSpellCasting() {
        if (this.target == null) {
            return;
        }
        double minY = Math.min(this.target.method_23318(), this.mob.method_23318());
        double maxY = Math.max(this.target.method_23318(), this.mob.method_23318()) + 1.0;
        float angle = (float)class_3532.method_15349((double)(this.target.method_23321() - this.mob.method_23321()), (double)(this.target.method_23317() - this.mob.method_23317()));
        int max = 6;
        for (int i = 0; i < max; ++i) {
            double h = (double)i * 1.3 + 1.5;
            this.createSpellEntity(this.mob.method_23317() + (double)class_3532.method_15362((float)angle) * h, this.mob.method_23321() + (double)class_3532.method_15374((float)angle) * h, minY, maxY, i == max - 1, angle);
        }
    }

    private void createSpellEntity(double x, double z, double minY, double maxY, boolean big, float angle) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)maxY, (double)z);
        boolean canSpawn = false;
        double j = 0.0;
        do {
            class_2680 blockState2;
            class_265 voxelShape;
            class_2338 blockPos2 = blockPos.method_10074();
            class_2680 blockState = this.mob.method_73183().method_8320(blockPos2);
            if (!blockState.method_26206((class_1922)this.mob.method_73183(), blockPos2, class_2350.field_11036)) continue;
            if (!this.mob.method_73183().method_22347(blockPos) && !(voxelShape = (blockState2 = this.mob.method_73183().method_8320(blockPos)).method_26220((class_1922)this.mob.method_73183(), blockPos)).method_1110()) {
                j = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            canSpawn = true;
            break;
        } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)minY) - 1);
        if (canSpawn || big) {
            class_1297 iceSpike;
            if (big) {
                iceSpike = new IceSpike(MobRegistry.ICE_SPIKE, this.mob.method_73183());
                iceSpike.setOwner((class_1309)this.mob);
            } else {
                iceSpike = new IceSpikeSmall(MobRegistry.ICE_SPIKE_SMALL, this.mob.method_73183());
                ((IceSpikeSmall)iceSpike).setOwner((class_1309)this.mob);
            }
            iceSpike.method_5814(x, j + (double)blockPos.method_10264(), z);
            iceSpike.method_36456((float)Math.toDegrees(angle) - 90.0f + (float)this.mob.method_59922().method_43048(20) - 10.0f);
            this.mob.method_73183().method_8649(iceSpike);
        }
    }
}

