/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.toms_mobs.entity.passive.butterfly;

import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.toms_mobs.entity.passive.butterfly.AbstractButterfly;
import de.tomalbrc.toms_mobs.registry.MobRegistry;
import de.tomalbrc.toms_mobs.util.SimpleMovementRotatingHolder;
import de.tomalbrc.toms_mobs.util.Util;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1429;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class Butterfly
extends AbstractButterfly {
    public static final class_2960 ID = Util.id("butterfly");
    public static final Model MODEL = Util.loadModel(ID);
    private int color;
    private String variant;
    private static final String[] variants = new String[]{"default", "1", "2"};

    public static boolean checkButterflySpawnRules(class_1299<? extends class_1308> type, class_1936 level, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return level.method_8311(pos) && !level.method_8320(pos.method_10074()).method_26227().method_15767(class_3486.field_15517);
    }

    public Butterfly(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void setupModel() {
        this.holder = new SimpleMovementRotatingHolder<Butterfly>(this, MODEL);
        EntityAttachment.ofTicking((ElementHolder)this.holder, (class_1297)this);
        this.setColor(Color.hslToRgb(this.method_59922().method_43057(), 0.99f, 0.65f));
        this.setVariant(variants[this.field_5974.method_43048(variants.length)]);
    }

    private void setColor(int color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.holder.setColor(color);
    }

    private void setVariant(String variant) {
        if (this.variant != null && this.variant.equals(variant)) {
            return;
        }
        this.variant = variant;
        this.holder.getVariantController().setVariant(variant);
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        boolean special;
        boolean bl = special = this.method_73183().field_9229.method_43048(1000) == 42;
        if (special) {
            return (class_1296)MobRegistry.EMPEROR_BUTTERFLY.method_5883((class_1937)serverLevel, class_3730.field_16466);
        }
        return (class_1296)MobRegistry.BUTTERFLY.method_5883((class_1937)serverLevel, class_3730.field_16466);
    }

    public void method_5749(class_11368 input) {
        super.method_5749(input);
        input.method_71439("Color").ifPresent(this::setColor);
        input.method_71441("Variant").ifPresent(variant -> {
            if (this.containsVariant((String)variant)) {
                this.setVariant((String)variant);
            }
        });
    }

    public void method_5652(class_11372 output) {
        super.method_5652(output);
        output.method_71465("Color", this.color);
        output.method_71469("Variant", this.variant);
    }

    private boolean containsVariant(String target) {
        for (String variant : variants) {
            if (!variant.equals(target)) continue;
            return true;
        }
        return false;
    }

    static class Color {
        Color() {
        }

        public static int hslToRgb(float h, float s, float l) {
            float r;
            float g;
            float b;
            if (s == 0.0f) {
                g = b = l;
                r = b;
            } else {
                float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
                float p = 2.0f * l - q;
                r = Color.hueToRgb(p, q, h + 0.33333334f);
                g = Color.hueToRgb(p, q, h);
                b = Color.hueToRgb(p, q, h - 0.33333334f);
            }
            return Color.to255(r) << 16 | Color.to255(g) << 8 | Color.to255(b);
        }

        public static int to255(float v) {
            return (int)Math.min(255.0f, 256.0f * v);
        }

        public static float hueToRgb(float p, float q, float t) {
            if (t < 0.0f) {
                t += 1.0f;
            }
            if (t > 1.0f) {
                t -= 1.0f;
            }
            if (t < 0.16666667f) {
                return p + (q - p) * 6.0f * t;
            }
            if (t < 0.5f) {
                return q;
            }
            if (t < 0.6666667f) {
                return p + (q - p) * (0.6666667f - t) * 6.0f;
            }
            return p;
        }
    }
}

