/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.toms_mobs.entity.hostile;

import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.core.holder.entity.EntityHolder;
import de.tomalbrc.bil.core.holder.entity.simple.SimpleEntityHolder;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.toms_mobs.util.Util;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5819;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;

public class IceCluster
extends class_1297
implements AnimatedEntity,
class_8046 {
    public static final class_2960 ID = Util.id("ice_cluster");
    public static final Model MODEL = Util.loadModel(ID);
    private final EntityHolder<IceCluster> holder;
    @Nullable
    private class_1309 owner;
    private UUID ownerUUID;
    private class_1309 target;
    private UUID targetUUID;
    private boolean falling = false;
    private int groundTicks = 0;

    public EntityHolder<IceCluster> getHolder() {
        return this.holder;
    }

    public IceCluster(class_1299<? extends class_1297> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5648(true);
        this.method_5875(true);
        this.holder = new SimpleEntityHolder((class_1297)this, MODEL);
        EntityAttachment.ofTicking(this.holder, (class_1297)this);
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float f) {
        return false;
    }

    public void method_36456(float f) {
        super.method_36456(f);
        this.holder.getElements().forEach(element -> {
            if (element instanceof DisplayElement) {
                DisplayElement displayElement = (DisplayElement)element;
                displayElement.setYaw(f);
            }
        });
    }

    public void method_5773() {
        class_1937 class_19372;
        super.method_5773();
        if (this.getTarget() != null) {
            class_243 towardsTarget = this.getTarget().method_19538().method_1020(this.method_19538()).method_1021(0.08);
            double distance = towardsTarget.method_37267();
            if (this.method_19538().field_1351 > this.getTarget().method_19538().field_1351 && distance < 0.08 || this.falling) {
                if (!this.falling) {
                    this.falling = true;
                }
                this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
                if (this.method_24828() || this.groundTicks > 0) {
                    class_1937 class_19373;
                    if (this.groundTicks == 0) {
                        this.hitEntities();
                    }
                    ++this.groundTicks;
                    if (this.groundTicks % 2 == 0 && (class_19373 = this.method_37908()) instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)class_19373;
                        int num = 16;
                        for (int i = 0; i < num; ++i) {
                            double step = Math.PI * 2 / (double)num;
                            class_243 position = this.method_19538();
                            class_243 delta = new class_243(Math.cos(step * (double)i), 0.3, Math.sin(step * (double)i)).method_1021(0.03);
                            serverLevel.method_65096((class_2394)class_2398.field_11204, position.field_1352, position.field_1351 + 0.2, position.field_1350, 0, delta.field_1352, delta.field_1351, delta.field_1350, 2.0);
                        }
                    }
                    if (this.groundTicks > 5) {
                        this.method_31472();
                    }
                }
            } else {
                this.method_18799(towardsTarget.method_1023(0.0, towardsTarget.field_1351, 0.0).method_1031(0.0, 0.1 * (this.getTarget().method_19538().field_1351 - this.method_19538().field_1351 + 4.0), 0.0));
            }
        } else {
            this.method_31472();
        }
        if (this.falling && this.groundTicks == 0 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_65096((class_2394)class_2398.field_28013, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, 10, 0.3, 1.0, 0.3, 0.0);
        }
        if (this.field_6012 > 400) {
            this.hitEntities();
            this.method_31472();
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    private void hitEntities() {
        List list = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1009(1.0, 1.0, 1.0));
        for (class_1309 livingEntity : list) {
            if (livingEntity == this.getOwner()) continue;
            this.dealDamageTo(livingEntity);
        }
    }

    public void method_5749(class_11368 compoundTag) {
        compoundTag.method_71426("Owner", class_4844.field_25122).ifPresent(uuid -> {
            this.ownerUUID = uuid;
        });
        compoundTag.method_71426("Target", class_4844.field_25122).ifPresent(uuid -> {
            this.targetUUID = uuid;
        });
        this.method_5875(true);
    }

    protected void method_5652(class_11372 output) {
        if (this.ownerUUID != null) {
            output.method_71477("Owner", class_4844.field_25122, (Object)this.ownerUUID);
        }
        if (this.targetUUID != null) {
            output.method_71477("Target", class_4844.field_25122, (Object)this.targetUUID);
        }
    }

    private void dealDamageTo(class_1309 livingEntity) {
        if (livingEntity.method_5805() && !livingEntity.method_5655() && livingEntity != this.getOwner()) {
            if (this.getOwner() == null) {
                livingEntity.method_64419(this.method_48923().method_48831(), 14.0f);
            } else if (!this.getOwner().method_5722((class_1297)livingEntity)) {
                livingEntity.method_64419(this.method_48923().method_48815((class_1297)this, (class_1297)this.getOwner()), 10.0f);
            }
            livingEntity.method_32317(300);
            this.spawnParticles(livingEntity.method_19538());
        }
    }

    private void spawnParticles(class_243 pos) {
        int particleCount = 20;
        float radius = 2.0f;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_5819 random = this.field_5974;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = random.method_43058() * (double)radius - (double)radius * 0.5;
                double offsetY = random.method_43058() * (double)radius - (double)radius * 0.5;
                double offsetZ = random.method_43058() * (double)radius - (double)radius * 0.5;
                double x = pos.field_1352 + offsetX;
                double y = pos.field_1351 + offsetY;
                double z = pos.field_1350 + offsetZ;
                serverLevel.method_65096((class_2394)class_2398.field_11205, x, y + 1.0, z, 0, random.method_43058(), random.method_43058(), random.method_43058(), 0.0);
            }
        }
    }

    public void setOwner(@Nullable class_1309 livingEntity) {
        this.owner = livingEntity;
        if (livingEntity != null) {
            this.ownerUUID = livingEntity.method_5667();
        }
    }

    public class_1309 getOwner() {
        class_1297 entity;
        if (this.owner == null && this.ownerUUID != null && this.method_37908() instanceof class_3218 && (entity = this.method_37908().method_66347(this.ownerUUID)) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    public class_1309 getTarget() {
        class_1297 entity;
        if (this.target == null && this.targetUUID != null && this.method_37908() instanceof class_3218 && (entity = this.method_37908().method_66347(this.targetUUID)) instanceof class_1309) {
            this.target = (class_1309)entity;
        }
        return this.target;
    }

    public void setTarget(class_1309 target) {
        this.target = target;
        if (target != null) {
            this.targetUUID = target.method_5667();
        }
    }
}

